import time
import redis
import logging
# useful for handling different item types with a single interface
from amazon_spider.db.redis_db import hincrby
from func_timeout.exceptions import FunctionTimedOut


class FidleMonitorPipeline:
    def __init__(self, site):
        self.site = site
        self.field_list = ["price", "img_url", "rank", "title", "volume", "weight", "weight_str", "launch_time"]

    @classmethod
    def from_crawler(cls, crawler):
        return cls(
            site=crawler.spider.site
        )

    def field_count(self, item, spider):
        stats = spider.crawler.stats
        stats.inc_value("items_count")
        site = item.get("site")
        while True:
            try:
                hincrby(f'counter:{site}:asin_detail', 'items_count', 1)
                logging.info("item_count +1")
                break
            except redis.exceptions.ConnectionError as e:
                logging.info(f"item_count 统计失败{e}")
                time.sleep(5)
                continue
            except FunctionTimedOut as e:
                logging.info(f"item_count 统计超时 {e}")
                continue
        for k, v in item.items():
            if v:
                stats.inc_value(k)
                while True:
                    try:
                        hincrby(f'counter:{site}:asin_detail', k, 1)
                        logging.info(f"asin_detail {k} +1")
                        break
                    except redis.exceptions.ConnectionError as e:
                        logging.info(f"asin_detail {k} 统计失败 {e}")
                        time.sleep(5)
                        continue
                    except FunctionTimedOut as e:
                        logging.info(f"asin_detail {k} 统计超时 {e}")
                        continue
                # print(hgetall('counter'))
            else:
                pass
                # if k in self.field_list:
                #     # f"field:{self.site}:{k}"
                #     for i in range(0, 15):
                #         try:
                #             sadd(f"field:{site}:{k}", item.get("asin"), use_md5=False)
                #             break
                #         except redis.exceptions.ConnectionError as e:
                #             continue

    def process_item(self, item, spider):
        if item.get("inner_item"):
            self.field_count(item.get("inner_item"), spider)
            return item
        return item

