# coding=utf-8
import time
import sys, os
import logging
import platform
sys.path.append(os.path.dirname(sys.path[0]))
from db.mysql_db import get_country_engine, sql_update, sql_connect


if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                    level=logging.INFO)


class CollectionAsin:
    """
    每天修改收藏asin状态
    """
    def __init__(self, site):
        self.site = site
        self.conn = None
        self.engine = get_country_engine(self.site)
        self.sites = {
            "us": "Amazon.com",
            "uk": "Amazon.co.uk",
            "de": "Amazon.de",
            "es": "Amazon.es",
            "it": "Amazon.it",
            "fr": "Amazon.fr",
            "mx": "Amazon.com.mx",
            "ca": "Amazon.ca",
        }

    def update_asin_state(self):
        sql_connect(self.site)
        # 更新收藏asin状态
        sql = '''update us_self_real_spider set state=1 WHERE end_time>=now() and (data_type like "%%8%%" or data_type like "%%9%%");'''
        # 测试
        logging.info("{}".format(sql))
        sql_update(sql)
        logging.info("更新收藏asin状态")


if __name__ == '__main__':
    logging.info("开始更新-------------")
    CollectionAsin("us").update_asin_state()



