import pandas as pd
import sys, os
import logging
import time
sys.path.append(os.path.dirname(sys.path[0]))
from db.mysql_db import get_country_engine, sql_insert, sql_insert_many, sql_connect, sql_delete, sql_update_many

logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                    level=logging.INFO)

engine = get_country_engine('us')


def get_self_asin():
    sql = f"SELECT DISTINCT(asin) AS asin from us_self_asin;"
    df_syn_asin = pd.read_sql(sql, con=engine)
    return df_syn_asin


def get_self_asin_detail():
    sql = f'SELECT asin from us_self_asin_detail where site="us";'
    df_syn_asin = pd.read_sql(sql, con=engine)
    return df_syn_asin


self_asin = get_self_asin()
detail_asin = get_self_asin_detail()
up_a = self_asin[~self_asin['asin'].isin(detail_asin["asin"])]
print(up_a)

up_asin = [list(i) for i in up_a.values]

sql_up = f"UPDATE `us_self_asin` set state=1  where asin=(%s);"
sql_connect("us")
sql_update_many(sql_up, up_asin)





