import sys, os, platform
import json
import logging
import time
import redis
from scrapy.utils.project import get_project_settings

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(sys.path[0]))))

from amazon_spider.utils.read_db_data import ReadDb

if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()

REDIS_CONF = get_project_settings().get('REDIS')


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                            level=logging.INFO)


def get_redis_client():
    client = redis.StrictRedis(**REDIS_CONF)
    return client


redis_client = get_redis_client()


def seeds(site="us"):
    r_db = ReadDb(site)

    seeds = r_db.read_db_seller_asin()
    seeds = seeds[~seeds["updated_at"].isna()].fillna("")
    seeds = [list(v) for v in seeds.values]
    pipe = redis_client.pipeline(transaction=False)
    for job in seeds[0:200000]:
        meta = {
            "asin": job[1],
            "asin_type": job[3],
            "is_variation": job[4],
            "date_info": job[5],
            "site": job[2],
            "account_id": job[6],
            "priority": job[7],
            "updated_at": str(job[8]),
            "other_sellers_id": job[9],
            "other_seller_name": job[10],
            "other_seller_buy_boy_type": job[11],
        }
        k = json.dumps(meta)
        pipe.zadd(f"{site}_real_zset_seed", {k: job[7]})
        # pipe.sadd(f"{site}_real_seed", k)
    pipe.execute()


if __name__ == '__main__':
    for i in ["us"]:
    # for i in ["us", "uk", "fr", "de", "it", "es"]:
        logging.info(f"推送{i}任务——————")
        seeds(i)
        logging.info(f"推送{i}任务完成——————")
        time.sleep(5)


