import pandas as pd
import logging
from db.pg_db import get_pg_country_engine
from db.mysql_db import sql_update


engine = get_pg_country_engine("us")
# sql1 = f"select a.asin, a.rank, a.volume, a.weight, a.launch_time from us_self_asin_detail_base as a join (select asin  from us_self_asin_detail_base where rank is null and launch_time is null and volume is null and updated_at>='2023-11-20') as b on a.asin=b.asin;"

sql1 = f"select a.asin, a.rank, a.volume, a.weight, a.launch_time from us_self_asin_detail_base as a join (select asin  from us_self_asin_detail_base where rank is null and launch_time is null and volume is null and updated_at>='2023-11-23') as b on a.asin=b.asin;"

df_keepa_trend = pd.read_sql(sql1, con=engine)

logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                    level=logging.INFO)

group_asin = df_keepa_trend.groupby(['asin'])

error_asin = []
for name, d in group_asin:
    if d.shape[0] >= 2:
        asin_null = d[d['rank'].isnull() & d['volume'].isnull() & d['weight'].isnull() & d['launch_time'].isnull()]
        if asin_null.shape[0] != d.shape[0]:
            print(f"error {name}")
            error_asin.append(name)


def update_asin_state(error_asin):
    if len(error_asin)>1:
        # 更新收藏asin状态
        sql = f'update us_self_real_spider set state=1 WHERE asin in {tuple(error_asin)};'
    else:
        sql = f'update us_self_real_spider set state=1 WHERE asin = "{error_asin[0]}";'
    logging.info(f"{sql}")
    sql_update(sql)
    logging.info("更新收藏asin状态")


update_asin_state(error_asin)