Java.perform(function () {
    try {
        // 1. Hook 系统 CookieManager 的 setCookie 方法（指定重载版本：url + cookie 字符串）
        const AndroidCookieManager = Java.use("android.webkit.CookieManager");
        // 明确选择两个 String 参数的重载：setCookie(String url, String value)
        AndroidCookieManager.setCookie.overload('java.lang.String', 'java.lang.String').implementation = function (url, value) {
            // 检查 Cookie 中是否包含 session-id（amznSessionId 的源头）
            if (value && value.includes("session-id=")) {
                console.log("\n=== 捕获 session-id Cookie ===");
                console.log("服务器 URL: " + url);
                console.log("Cookie 内容: " + value);

                // 解析 URL 中的参数
                if (url) {
                    try {
                        const urlObj = new URL(url);
                        const params = urlObj.searchParams;
                        if (params.size > 0) {
                            console.log("URL 参数:");
                            params.forEach((v, k) => console.log(`  ${k}=${v}`));
                        } else {
                            console.log("URL 参数: 无");
                        }
                    } catch (e) {
                        console.log("URL 解析失败（非标准格式）: " + url);
                    }
                }
            }
            // 调用原方法，不影响正常逻辑
            return this.setCookie(url, value);
        };

        // 2. Hook CookieBridge 的 put 方法（处理服务器响应的 Set-Cookie 头）
        const CookieBridge = Java.use("com.amazon.mShop.net.CookieBridge");
        CookieBridge.put.implementation = function (uri, responseHeaders) {
            const url = uri.toString();
            // 提取响应头中的 Set-Cookie 字段（可能包含 session-id）
            const setCookieHeaders = responseHeaders.get("Set-Cookie") || responseHeaders.get("set-cookie");
            if (setCookieHeaders && setCookieHeaders.length > 0) {
                for (const cookie of setCookieHeaders) {
                    if (cookie.includes("session-id=")) {
                        console.log("\n=== 服务器响应中包含 session-id ===");
                        console.log("请求的 URL: " + url);
                        break;
                    }
                }
            }
            // 调用原方法
            this.put(uri, responseHeaders);
        };

        console.log("✅ 已成功 Hook，等待 session-id 下发...");
    } catch (e) {
        console.log("❌ Hook 失败: " + e.message);
    }
});