import sys
import os

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
import pymysql
from amazon_params.params import DB_CONN_DICT, PG_CONN_DICT
from sqlalchemy import create_engine
import pandas as pd
import time
from threading_spider.db_connectivity import connect_db


def init_db(site_name):
    if site_name == 'us':
        connect = pymysql.connect(host=DB_CONN_DICT['mysql_host'], port=DB_CONN_DICT['mysql_port'],
                                  user=DB_CONN_DICT['mysql_user'],
                                  password=DB_CONN_DICT['mysql_pwd'], database="selection", charset="utf8mb4")
    else:
        connect = pymysql.connect(host=DB_CONN_DICT['mysql_host'], port=DB_CONN_DICT['mysql_port'],
                                  user=DB_CONN_DICT['mysql_user'],
                                  password=DB_CONN_DICT['mysql_pwd'], database="selection_" + site_name,
                                  charset="utf8mb4")
    cursor = connect.cursor()
    if site_name == 'us':
        engine_pg = create_engine(
            f"postgresql+psycopg2://{PG_CONN_DICT['pg_user']}:{PG_CONN_DICT['pg_pwd']}@{PG_CONN_DICT['pg_host']}:{PG_CONN_DICT['pg_port']}/selection",
            encoding='utf-8')
    else:
        engine_pg = create_engine(
            f"postgresql+psycopg2://{PG_CONN_DICT['pg_user']}:{PG_CONN_DICT['pg_pwd']}@{PG_CONN_DICT['pg_host']}:{PG_CONN_DICT['pg_port']}/selection_{site_name}",
            encoding='utf-8')
    print('同步erp asin 到 pg')
    _time = time.strftime('%Y-%m-%d', time.localtime(time.time()))

    sql_read = f"SELECT asin, img_url, title, title_len, price, rating, total_comments, buy_box_seller_type, page_inventory, category, volume, weight, rank, launch_time, video_url, add_url, material, created_at, updated_at, img_num, img_type, qa_num, brand, ac_name, node_id, sp_num, mpn, online_time, `describe`, one_star, two_star, three_star, four_star, five_star, low_star,    asin_type, is_coupon, search_category, weight_str, date_info, site,account_name, other_seller_name, bsr_date_info, account_id FROM us_self_asin_detail where date_info = '{_time}'"
    print(sql_read)
    cursor.execute(sql_read)
    data_search_term = cursor.fetchall()
    df = pd.DataFrame(data=data_search_term,
                      columns=['asin', 'img_url', 'title', 'title_len', 'price', 'rating', 'total_comments',
                               'buy_box_seller_type', 'page_inventory', 'category', 'volume', 'weight', 'rank',
                               'launch_time', 'video_url', 'add_url', 'material', 'created_at', 'updated_at', 'img_num',
                               'img_type', 'qa_num', 'brand', 'ac_name', 'node_id', 'sp_num', 'mpn', 'online_time',
                               'describe', 'one_star', 'two_star', 'three_star', 'four_star', 'five_star', 'low_star',
                               'asin_type', 'is_coupon', 'search_category', 'weight_str', 'date_info', 'site',
                               'account_name', 'other_seller_name', 'bsr_date_info', 'account_id'])
    df.loc[df['launch_time'] == '0000-00-00', 'launch_time'] = None
    df.to_sql('us_self_asin_detail_2024', con=engine_pg, if_exists="append", index=False)
    title = site_name + '站点 每日同步 us_self_asin_detail 数据 ',
    content = f'{_time} 同步数据成功 to pg us_self_asin_detail_2024'
    account = 'pengyanbing'
    connect_db(None).send_mg(account, title, content)

    print(' 同步公司asin 到pg。并且 us_bsr_asin_detail、us_nsr_asin_detail 更新 asin_type 字段标记')
    sql_self_asin = f"SELECT asin,created_at,updated_at FROM us_self_asin"
    print(sql_self_asin)
    cursor.execute(sql_self_asin)
    self_aisn_data = cursor.fetchall()
    df_asin = pd.DataFrame(data=self_aisn_data, columns=['asin', 'created_at', 'updated_at'])

    with engine_pg.begin() as conn:
        tr_sql = 'TRUNCATE us_self_asin'
        conn.execute(tr_sql)
    print('开始存储')
    df_asin.to_sql('us_self_asin', con=engine_pg, if_exists="append", index=False)
    print('存储成功')
    with engine_pg.begin() as conn:
        u_bsr_sql = 'UPDATE us_bsr_asin_detail b SET asin_type = 1 FROM us_self_asin a WHERE a.asin = b.asin and b.asin_type !=1;'
        print(u_bsr_sql)
        conn.execute(u_bsr_sql)
        u_nsr_sql = 'UPDATE us_nsr_asin_detail b SET asin_type = 1 FROM us_self_asin a WHERE a.asin = b.asin and b.asin_type !=1;'
        print(u_nsr_sql)
        conn.execute(u_nsr_sql)
    title = site_name + '站点 每日同步 us_self_asin 数据',
    content = F'{_time} 同步数据成功 to pg 成功。更改 us_nsr_asin_detail，us_bsr_asin_detail 表 asin_type 成功 '
    account = 'pengyanbing'
    connect_db(None).send_mg(account, title, content)

    # # #备份 _one_category_report 数据
    # year_month = time.strftime('%Y_%m', time.localtime(time.time()))
    # year_month =year_month.replace('_0','_')
    # category_report_sql = f'select cate_1_id,`name`,rank,orders,orders_day,`year_month`,created_at,updated_at,`week` from {site_name}_one_category_report where `year_month` = "{year_month}"'
    # print(category_report_sql)
    # cursor.execute(category_report_sql)
    # category_report_data = cursor.fetchall()
    # df = pd.DataFrame(data=category_report_data,
    #                   columns=['cate_1_id', 'name', 'rank', 'orders', 'orders_day', 'year_month', 'created_at',
    #                            'updated_at', 'week'])
    # df.to_sql(f'{site_name}_one_category_report', con=engine_pg, if_exists="append", index=False)

    # 监控搜索词数据入库数量
    if site_name == 'us':
        sql_read = f"SELECT DISTINCT(date_info) FROM {site_name}_search_term_pg where state in (1, 2) GROUP BY date_info"
        print(sql_read)
        df = pd.read_sql(sql_read, con=engine_pg)
        date_info = list(df.date_info)
        print(date_info)
        if date_info:
            report_date = date_info[0]
            print("report_date: ", report_date)
            ymd = report_date.replace('-', '_')
            for i in ['zr', 'sp', 'sb', 'ac', 'er', 'tr', 'bs', 'hr']:
                sql_count = f"select count(id) from {site_name}_search_term_rank_{i}_{ymd}"
                print(sql_count)
                df_count = pd.read_sql(sql_count, con=engine_pg)
                count = list(df_count.values)[0][0]
                print(count)
                if i == 'er':
                    if count < 10000:
                        print('数据解析错误')
                        title = site_name + '站点 周搜索词抓取',
                        content = report_date + ' 周搜索词 ' + i + f'  入库总数 {count}'
                        account = 'pengyanbing'
                        connect_db(None).send_mg(account, title, content)
                elif i == 'ac' or i == 'tr':
                    if count < 90000:
                        print('数据解析错误')
                        title = site_name + '站点 周搜索词抓取',
                        content = report_date + ' 周搜索词 ' + i + f'  入库总数 {count}'
                        account = 'pengyanbing'
                        connect_db(None).send_mg(account, title, content)
                else:
                    if count < 200000:
                        print('数据解析错误')
                        title = site_name + '站点 周搜索词抓取',
                        content = report_date + ' 周搜索词 ' + i + f'  入库总数 {count}'
                        account = 'pengyanbing'
                        connect_db(None).send_mg(account, title, content)


if __name__ == '__main__':
    init_db('us')
