import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.spark_util import SparkUtil
from utils.common_util import CommonUtil

# 导出
if __name__ == '__main__':
    spark = SparkUtil.get_spark_session("export_title_tmp_export.py")

    sql = f"""
    select word,count
    from word_count_tmp1
    order by count desc
    limit 1000000
"""

    save_df = spark.sql(sql)
    path = CommonUtil.df_export_csv(spark, save_df, "word_count_calc", limit=100 * 10000)

    CommonUtil.send_wx_msg(['wujicang', 'chenjianyun'], "提醒", f"asin标题count完成！csv；路径为{path}")
    pass
