import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil, DateTypes
from utils.db_util import DBUtil


if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)

    CommonUtil.judge_is_work_hours(site_name=site_name, date_type=date_type, date_info=date_info,
                                   principal='wangrui4', priority=3, export_tools_type=1, belonging_to_process='最小产品线市场数据汇总')
    db_type = 'mysql'
    export_tb = f"keepa_{site_name}_asin_bsr_rank_sum_level_1"

    # 获取数据库连接
    mysql_engine = DBUtil.get_db_engine('mysql', site_name)

    sql = f"""
        truncate {export_tb}
    """

    DBUtil.engine_exec_sql(mysql_engine, sql)

    # 导出表名
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_keepa_asin_bsr_rank",
        export_tb=export_tb,
        col=[
            "cat_id",
            "orders_sum",
            "success_orders_sum",
            "fail_orders_sum",
            "success_num",
            "fail_num",
            "is_inner",
            "category"
        ],
        partition_dict={
            "site_name": site_name,
            "date_type": date_type,
            "date_info": date_info
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()

    print("success")
    CommonUtil.send_wx_msg(["wangrui4", "heqinsi"], f"{export_tb} 导出完成", f"时间：{date_info} 最小产品线市场数据汇总信息导出完成")
