import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.hdfs_utils import HdfsUtils

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_info = CommonUtil.get_sys_arg(2, None)
    assert site_name is not None, "sitename 不能为空！"
    assert date_info is not None, "date_info 不能为空！"
    hive_tb = "ods_new_releases_top100_asin"
    partition_dict = {
        "site_name": site_name
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_tb, partition_dict=partition_dict)
    print(f"hdfs_path is {hdfs_path}")
    if date_info == 'all':
        query = f"""
            select id,
            asin,
            cate_1_id,
            cate_current_id,
            bsr_rank,
            rating,
            total_comments,
            created_at as updated_at,
            date_info,
            category_id
            from {site_name}_new_releases_top100_asin
            where 1 = 1
            and \$CONDITIONS
"""
        pass
    else:
        query = f"""
            select id,
            asin,
            cate_1_id,
            cate_current_id,
            bsr_rank,
            rating,
            total_comments,
            created_at as updated_at,
            date_info,
            category_id
            from {site_name}_new_releases_top100_asin
            where 1 = 1
            and date_info = '{date_info}'
            and \$CONDITIONS
"""
        pass

    print("================================sql====================================")
    print(query)
    db_type = "mysql"
    empty_flag, check_flag = CommonUtil.check_schema_before_import(db_type=db_type,
                                                                   site_name=site_name,
                                                                   query=query,
                                                                   hive_tb_name=hive_tb,
                                                                   msg_usr=['wujicang']
                                                                   )
    assert check_flag, f"导入hive表{hive_tb}表结构检查失败！请检查query是否异常！！"

    if not empty_flag:
        sh = CommonUtil.build_import_sh(site_name=site_name,
                                        db_type=db_type,
                                        query=query,
                                        hdfs_path=hdfs_path)
        # 导入前先删除
        HdfsUtils.delete_hdfs_file(hdfs_path)
        client = SSHUtil.get_ssh_client()
        SSHUtil.exec_command_async(client, sh, ignore_err=False)
        CommonUtil.after_import(hdfs_path=hdfs_path, hive_tb=hive_tb)
    pass
