import json
import time
import redis
import logging
import sys, os
import platform
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(sys.path[0]))))
from amazon_spider.utils.read_db_data import ReadDb
from scrapy.utils.project import get_project_settings

if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()

REDIS_CONF = get_project_settings().get('REDIS')


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                            level=logging.INFO)


def get_redis_client():
    client = redis.StrictRedis(**REDIS_CONF)
    return client


redis_client = get_redis_client()


def seeds(site="us"):
    r_db = ReadDb(site)
    seed = list(list(i) for i in r_db.read_db_real_collect_keepa().values)
    print(len(seed))
    pipe = redis_client.pipeline(transaction=False)
    for job in seed:
        meta = {
            "asin": job[0],
            "asin_type": job[2],
            "is_variation": job[3],
            "date_info": job[4],
            "site": job[5],
            "account_id": job[6],
            "priority": job[7]
        }
        k = json.dumps(meta)
        pipe.zadd(f"{site}_real_zset_seed", {k: job[7]})
        # pipe.sadd(f"{site}_real_seed", k)
    pipe.execute()


if __name__ == '__main__':
    for i in ["us"]:
    # for i in ["us", "uk", "fr", "de", "it", "es"]:
        logging.info(f"推送{i}任务——————")
        seeds(i)
        logging.info(f"推送{i}任务完成——————")
        time.sleep(5)


# spiders = {}
# module_content = import_module(f'amazon_spider.spiders.test_redis')
# # print(module_content)
# # print(vars(module_content))
# # obj = getattr(module_content, 'TestSpider')
# for block_name, block_type in vars(module_content).items():
#     if block_name == 'TestSpider':
#         print(block_name, block_type)
#         spiders.update({block_type.name: block_type})
# print("-----")
# print(spiders)
# spider = spiders['test']().custom_settings
# seeds_generate = seeds(spider)
# count = 0
# for seed in seeds_generate:
#     try:
#         spider.push_request(seed)
#         count += 1
#     except Exception as e:
#         logging.exception(f'error push')

