# -*- coding: utf-8 -*-
import logging
import time
import httpx
import scrapy
from scrapy.http import HtmlResponse
from amazon_spider.utils.random_ssl import ssl_context


logger = logging.getLogger(__name__)


class HttpxMiddleware:
    """
    可以下载http2 处理socks代理
    """

    def __init__(self, delay=0):
        self.delay = delay

    @classmethod
    def from_crawler(cls, crawler):
        s = crawler.settings
        delay = s.get('DOWNLOAD_DELAY', 0)
        return cls(delay)

    async def process_request(self, request: scrapy.Request, spider):
        if request.meta.get("use_httpx", False):
            logging.getLogger().info("Start to set httpx")
            proxies = {
                "http://": request.meta.get('proxy'),
                "https://": request.meta.get('proxy'),
            }
            start_time = time.time()
            async with httpx.AsyncClient(http2=True, verify=ssl_context, proxies=proxies) as client:
                httpx_request = client.build_request(request.method, request.url, headers=request.headers.to_unicode_dict(),
                                       cookies=request.cookies,
                                       data=request.body if request.method in ('POST', 'PUT', 'PATCH') else None)
                response = await client.send(httpx_request)
                end_time = time.time()  # 记录结束时间
                response_time = end_time - start_time  # 计算响应时间
                logger.info(f"httpx Response time: {response_time} seconds")
                response = HtmlResponse(
                    request.url,
                    encoding=response.encoding,
                    status=response.status_code,
                    # headers=response.headers,
                    body=response.content,
                    request=request
                )
                stats = spider.crawler.stats
                stats.inc_value("downloader/request_count")
                stats.inc_value(f"downloader/request_method_count/{request.method}")
                return response

    # def process_request(self, request, spider):
    #     if request.meta.get("use_httpx", False):
    #         proxies = {
    #             "http://": request.meta.get('proxy'),
    #             "https://": request.meta.get('proxy'),
    #         }
    #         with httpx.Client(http2=True, verify=ssl_context, proxies=proxies) as client:
    #             httpx_request = client.build_request(request.method, request.url, headers=request.headers.to_unicode_dict(),
    #                                    cookies=request.cookies,
    #                                    data=request.body if request.method in ('POST', 'PUT', 'PATCH') else None)
    #             response = client.send(httpx_request)
    #             response = HtmlResponse(
    #                 request.url,
    #                 encoding=response.encoding,
    #                 status=response.status_code,
    #                 # headers=response.headers,
    #                 body=response.content,
    #                 request=request
    #             )
    #             return response

    def process_response(self, request, response, spider):
        return response

    def process_exception(self, request, exception, spider):
        logging.info(f"middleware error {spider.r_utils(request)} {exception}")
        return None
