import sys
import os

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.secure_db_client import get_remote_engine
"""
每周三定时修改 feedback ， product， 同步表修改状态 为 1 六个站点
"""

def run(site):
    engine_mysql = get_remote_engine(
        site_name=site,  # -> database "selection"
        db_type="mysql",  # -> 服务端 alias "mysql"
    )
    engine_pg = get_remote_engine(
        site_name=site,  # -> database "selection"
        db_type="postgresql_14_outer",  # -> 服务端 alias "mysql"
    )
    # cursor = connect.cursor()
    # 更改 feedback syn 表 状态为1
    with engine_mysql.begin() as conn_mysql:
        update_feedback_sql = f"update {site}_seller_account_syn_distinct set state = 1, product_state=1 and state!=12"
        conn_mysql.execute(update_feedback_sql)

        # 更改 店铺syn 表 状态为1
        update_product_sql = f"update {site}_seller_account_product_syn set state = 1"
        print(update_product_sql)
        conn_mysql.execute(update_product_sql)

        update_feedback_sql = f"update {site}_seller_account_syn set state = 1, product_state=1"
        print(update_feedback_sql)
        conn_mysql.execute(update_feedback_sql)

    if site in ('us'):
        with engine_pg.begin() as conn:
            conn.execute(update_feedback_sql)
            conn.execute(update_product_sql)
            conn.execute(update_feedback_sql)


if __name__ == '__main__':
    run('us')
    run('de')
    run('uk')
    run('fr')
    run('es')
    run('it')