import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from amazon_params import py_ja3
from amazon_save_db.save_asin_detail_pg import Save_asin_detail
from utils.asin_parse import ParseAsinUs
from queue import Queue
import re
from lxml import etree
import requests
import urllib3
import threading
from func_timeout.exceptions import FunctionTimedOut
import traceback
from datetime import datetime
import gzip
import json
from kafka.errors import KafkaTimeoutError

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
sess = requests.Session()
urllib3.disable_warnings()


class async_asin_pg():
    def __init__(self, site_name='us', proxy_name=None, week=None, month=None, spider_int=None):
        self.site_name = site_name  # 站点
        self.save_asin_detail = Save_asin_detail(site_name=self.site_name, proxy_name=proxy_name, month=month,
                                                 spider_int=spider_int)
        self.spider_int = spider_int
        self.reuests_para_val = self.save_asin_detail.reuests_para_val
        self.kafuka_producer_str = self.save_asin_detail.kafuka_producer_str
        self.redis14 = self.save_asin_detail.redis_db14
        self.requests_error_asin_list = []  # 1
        self.asin_not_found_list = []  # 4
        self.asin_not_sure_list = []  # 6
        self.asin_not_foot_list = []  # 7
        self.asin_not_foot2_list = []  # 8
        self.asin_not_buyBox_list = []  # 9
        self.asin_not_response_list = []  # 10
        self.asin_not_redirect_list = []  # 12
        self.asin_not_div_id_dp_list = []  # 返回html没有包含div @id=dp,状态13
        self.asin_list_update = []  # 3
        self.cookies_queue = Queue()  # cookie队列
        self.item_queue = Queue()  # 存储 item 详情数据队列
        self.queries_asin_queue = Queue()  # 需要爬取的asin队列
        self.buyBox_list = []  # 卖家名称 url 列表
        self.asin_detail_list = []  # 存储asin 详情的列表
        self.buyBoxname_asin_list = []  # asin 卖家的列表item
        self.delete_cookies_list = []  # 存储出现中国邮编的cookie
        self.stop_item_queue = True  # 用于是否退出循环存储的条件
        self.spider_de_feedback = False
        self.cookie_dict_delete_id = {}
        self.headers_num_int = 0
        self.star_list = []  # 存储星级百分比
        self.add_cart_asin_list = []  # 存储 绑定购买的asin
        self.asin_brand_list = []  # 存储asin 对应 的品牌
        self.bs_category_asin_list = []  # 存储 asin 详情 bsr 文本类目
        self.bs_category_asin_list_pg = []  # 存储 asin 详情 bsr 文本类目
        self.month_ = month
        self.week = week
        # 返回 对应站点的host，首页链接
        self.site_url, self.host = self.reuests_para_val.get_site_url(self.site_name)
        # 验证码 1
        self.yzm_err_total_list = []
        # 异常 2
        self.asin_request_errp_total_list = []
        # 成功 3
        self.success_asin_total_list = []
        # 每小时
        self.hour_total_count_list = []
        # 总请求 4
        self.request_total_count_list = []
        self.topic_detail_month = f'{self.site_name}_asin_detail_month_2025_{self.month_}'
        self.topic_asin_html = f'asin_html_2025_{self.month_}'
        self.asin_video_list = []

    def get_asin(self):
        while True:
            if self.queries_asin_queue.empty() == False:
                querys = self.queries_asin_queue.get()
                if self.cookies_queue.empty():
                    cookies_dict = self.reuests_para_val.get_cookie()
                    self.cookie_dict_delete_id = cookies_dict
                    for ck in cookies_dict.values():
                        self.cookies_queue.put(ck)
                # 获取组装cookie
                cookie_str = self.reuests_para_val.get_cookie_str(self.cookies_queue)
                query = str(querys).split('|')
                is_variat = query[2]
                asin = query[0]
                date_info = query[1]
                data_type_asin = int(query[3])
                volume_str = query[4]
                weight_str = query[5]
                headers = self.reuests_para_val.requests_amazon_headers(host=self.host, site_url=self.site_url,
                                                                        asin=asin, scraper_url=None)
                headers["cookie"] = cookie_str
                self.month_ = date_info.split('-')[1]
                if self.headers_num_int > 20:
                    break
                if is_variat == '1':
                    scraper_url = self.site_url + 'dp/' + query[0] + "?th=1&psc=1"
                else:
                    scraper_url = self.site_url + 'dp/' + query[0]
                self.request_total_count_list.append(4)
                print('scraper_url::', scraper_url)
                try:
                    sess.mount(self.site_url, py_ja3.DESAdapter())
                    resp = sess.get(scraper_url, headers=headers,
                                    timeout=10, verify=False)
                    # with open(rf'D:\新建文件夹\requests_files\{self.site_name}_{asin}.html', 'w', encoding='utf-8')as f:
                    #     f.write(resp.text)
                    if self.reuests_para_val.check_amazon_yzm(resp):
                        self.yzm_err_total_list.append(1)
                        self.headers_num_int += 1
                        self.requests_error_asin_list.append(query[0])
                        continue
                except Exception as e:
                    self.asin_request_errp_total_list.append(2)
                    print("请求错误错误: ", e)
                    if 'Received response with content-encoding: gzip' in str(e):
                        self.asin_not_found_list.append(asin)
                    else:
                        self.requests_error_asin_list.append(query[0])
                    continue
                response_url = resp.url
                response = resp.text
                response_s = etree.HTML(response)
                self.success_asin_total_list.append(3)

                if self.reuests_para_val.check_amazon_not_page(response):
                    self.asin_not_found_list.append(asin)
                    continue
                if self.reuests_para_val.check_amazon_page(response, response_url):
                    self.asin_not_redirect_list.append(asin)
                    continue
                if self.reuests_para_val.check_amazon_allow_redirects(response_url, asin):
                    self.asin_not_redirect_list.append(asin)
                    continue
                # 获取邮编
                try:
                    ingress = response_s.xpath("//span[@id='glow-ingress-line2']/text()")
                except Exception as e:
                    self.asin_not_response_list.append(asin)
                    continue
                try:
                    ingress = ingress[0].strip()
                except:
                    ingress = None
                print(ingress, ' 打印 邮编 ', resp.url)
                if ingress:
                    if self.reuests_para_val.check_amazon_ingress(ingress):
                        try:
                            cookie_ubid_main_id = re.findall(r'ubid-main=(.*?);', cookie_str)[0]
                        except:
                            cookie_ubid_main_id = re.findall(r'session-id=(.*?);', cookie_str)[0]
                        for cookie_key_value in self.cookie_dict_delete_id.items():
                            if cookie_ubid_main_id in cookie_key_value[1]:
                                self.delete_cookies_list.append(cookie_key_value[0])
                        self.requests_error_asin_list.append(asin)
                        continue

                div_dp = response_s.xpath('//div[@id="dp"]')
                if div_dp:
                    # 解析resp=_response_text, asin=asin
                    items = ParseAsinUs(resp=response, asin=asin, month=self.month_, date_info=date_info,
                                        site_name=self.site_name).xpath_html()
                    new_date = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                    item = {'asin': items["asin"], 'week': items["week"], 'month': items["month"],
                            'title': items["title"],
                            'img_url': items["img_url"],
                            'rating': items["rating"],
                            'total_comments': items["total_comments"],
                            'price': items["price"], "rank": items["rank"], 'category': items["category"],
                            'launch_time': items["launch_time"],
                            'volume': items["volume"],
                            'weight': items["weight"], "page_inventory": items["page_inventory"],
                            "buy_box_seller_type": items["buy_box_seller_type"],
                            "asin_vartion_list": items["asin_vartion_list"], 'title_len': items["title_len"],
                            'img_num': items["img_num"], 'img_type': items["img_type"],
                            'activity_type': items["activity_type"],
                            'one_two_val': items["one_two_val"], 'three_four_val': items["three_four_val"],
                            'eight_val': items["eight_val"],
                            'qa_num': items["qa_num"], 'five_star': items["five_star"], 'four_star': items["four_star"],
                            'three_star': items["three_star"],
                            'two_star': items["two_star"], 'one_star': items["one_star"], 'low_star': items["low_star"],
                            'together_asin': items["together_asin"],
                            'brand': items["brand"], 'ac_name': items["ac_name"], 'material': items["material"],
                            'node_id': items["node_id"], 'data_type': data_type_asin,
                            'sp_num': items["sp_num"], 'describe': items["describe"], 'date_info': date_info,
                            'weight_str': items["weight_str"], 'package_quantity': items['package_quantity'],
                            'pattern_name': items['pattern_name'], 'seller_id': items["seller_id"],
                            'variat_num': items['variat_num'],
                            'site_name': self.site_name, 'best_sellers_rank': items["best_sellers_rank"],
                            'best_sellers_herf': items["best_sellers_herf"], 'account_url': items["account_url"],
                            'account_name': items["account_name"], 'parentAsin': items["parentAsin"],
                            'asinUpdateTime': new_date, 'follow_sellers': items['sellers_num'],
                            'spider_int': self.spider_int, 'all_best_sellers_herf': items['all_best_sellers_herf'],
                            'product_description': items['product_description'], 'buy_sales': items['buySales'],
                            'image_view': items['image_view'], 'product_json': items['product_json'],
                            'product_detail_json': items['productdetail_json'],
                            'review_ai_text': items['review_ai_text'], 'review_label_json': items['review_label_json'],
                            'lob_asin_json': items['lob_asin_json'],
                            'sp_initial_seen_asins_json': items['sp_initial_seen_asins_json'],
                            'sp_4stars_initial_seen_asins_json': items['sp_4stars_initial_seen_asins_json'],
                            'sp_delivery_initial_seen_asins_json': items['sp_delivery_initial_seen_asins_json'],
                            'compare_similar_asin_json': items['compare_similar_asin_json'],
                            'customer_reviews_json': items['customer_reviews_json'],
                            'together_asin_json': items['together_asin_json'],
                            'min_match_asin_json': items['min_match_asin_json'], 'seller_json': items['seller_json'],
                            'created_time': new_date, 'current_asin': items['current_asin'],
                            'parent_asin': items["parentAsin"], 'div_id_list': items['div_id_list'],
                            'bundles_this_asins_json': items['bundles_this_asins_data_json'],
                            'video_m3u8_url': items["video_m3u8"], 'result_list_json': items['result_list_json'],
                            'bundle_asin_component_json': None, 'review_json_list': items['review_json_list'],
                            'asin_buySales_list': items['asin_buySales_list']
                            }
                    if self.site_name in ['uk', 'de', 'fr', 'es', 'it']:
                        item['five_six_val'] = items['five_six_val']
                    else:
                        item['five_six_val'] = None
                        # 第二次请求
                    _response_text = None
                    # if (item['weight'] is None and item['volume'] is None and item['rank'] is None and item[
                    #     'launch_time'] is None) or (item['variat_num'] > 0 and is_variat == '0'):
                    if item['variat_num'] > 0 and is_variat == '0':
                        self.request_total_count_list.append(4)
                        if item['variat_num'] > 0:
                            _url = self.site_url + 'dp/' + asin + "?th=1&psc=1"
                        else:
                            _url = self.site_url + 'dp/' + asin
                        print('第二次请求:', _url)
                        try:
                            _response_text = None
                            _response_text = self.reuests_para_val.requests_amazon(headers=headers, scraper_url=_url)
                            if _response_text:
                                _items = ParseAsinUs(resp=_response_text, asin=asin, month=self.month_,
                                                     date_info=date_info,
                                                     site_name=self.site_name).xpath_html()
                                if _items["volume"] and item['volume'] is None:
                                    item['volume'] = _items["volume"]
                                if _items['result_list_json'] and item['result_list_json'] is None:
                                    item['result_list_json'] = _items["result_list_json"]
                                if _items["weight_str"] and item['weight_str'] is None:
                                    item['weight_str'] = _items["weight_str"]
                                if _items["weight"] and item['weight'] is None:
                                    item['weight'] = _items["weight"]
                                if item["rank"] is None:
                                    item["rank"] = _items["rank"]
                                if item["launch_time"] is None:
                                    item["launch_time"] = _items["launch_time"]
                                if item['product_description'] is None:
                                    item['product_description'] = _items["product_description"]
                                if item["price"] is None:
                                    item["price"] = _items["price"]
                                elif item["price"] < 1:
                                    item["price"] = _items["price"]
                                if item["buy_sales"] is None:
                                    item["buy_sales"] = _items["buySales"]
                                if item['buy_box_seller_type'] is None or item['buy_box_seller_type'] == 4:
                                    item["buy_box_seller_type"] = _items["buy_box_seller_type"]
                                if item['page_inventory'] == 0 or item['page_inventory'] == 3:
                                    item["page_inventory"] = _items["page_inventory"]
                                if item['account_name'] is None:
                                    item["account_name"] = _items["account_name"]
                                if item['seller_id'] is None:
                                    item["seller_id"] = _items["seller_id"]
                                if item['seller_json'] is None:
                                    item["seller_json"] = _items["seller_json"]
                        except:
                            pass
                    print('itemitem:::', item)
                    _response_text_var = None
                    if item["buy_box_seller_type"] == 4 and item['page_inventory'] == 3 and item['variat_num'] > 0 and \
                            items["asin_variation_list"]:
                        self.request_total_count_list.append(4)
                        try:
                            if asin != items["asin_variation_list"][0][0]:
                                _to_asin = items["asin_variation_list"][0][0]
                            elif len(items["asin_variation_list"]) > 1:
                                _to_asin = items["asin_variation_list"][1][0]
                            else:
                                _to_asin = item['parentAsin']
                            _url = self.site_url + 'dp/' + _to_asin + "?th=1&psc=1"
                            print('请求asin 出现缺货，拿变体asin进行请求:', _url)
                            _response_text_var = self.reuests_para_val.requests_amazon(headers=headers,
                                                                                       scraper_url=_url)
                            _to_items = ParseAsinUs(resp=_response_text_var, asin=asin, month=self.month_,
                                                    date_info=date_info,
                                                    site_name=self.site_name).xpath_html()
                            if item['buy_box_seller_type'] is None or item['buy_box_seller_type'] == 4:
                                item["buy_box_seller_type"] = _to_items["buy_box_seller_type"]
                            if item['account_name'] is None:
                                item["account_name"] = _to_items["account_name"]
                            if item['seller_id'] is None:
                                item["seller_id"] = _to_items["seller_id"]
                            if item['seller_json'] is None:
                                item["seller_json"] = _to_items["seller_json"]
                        except Exception as e:
                            print('请求asin 第二次请求 报错：', f"\n{traceback.format_exc()}")

                    if item['volume'] is None and volume_str != 'null':
                        item['volume'] = volume_str
                    if item['weight_str'] is None and weight_str != 'null':
                        item['weight_str'] = weight_str
                    new_date_hour = datetime.now().strftime("%Y-%m-%d:%H")
                    num = self.reuests_para_val.get_hour(new_date_hour)
                    self.hour_total_count_list.append(num)
                    print("+++++++++++item['buy_sales']::", item['buy_sales'])
                    if not item['title'] or not item['img_url']:
                        self.asin_not_sure_list.append(asin)
                        continue
                    elif len(item['img_url'].strip()) > 2:
                        for key in ['None', 'null', 'none']:
                            if key in item['img_url']:
                                self.asin_not_sure_list.append(asin)
                                continue
                    elif len(item['title'].strip()) > 2:
                        for key in ['None', 'null', 'none']:
                            if key in item['title']:
                                self.asin_not_sure_list.append(asin)
                                continue
                    # 上架时间 排名  重量 底部信息 如果都为None 重新抓取
                    if item["launch_time"] is None and item["rank"] is None and item['weight'] is None and item[
                        'product_detail_json'] is None and len(items['div_id_list']) < 1:
                        print('上架时间 排名  重量 底部信息 如果都为None 重新抓取:::', asin)
                        self.requests_error_asin_list.append(asin)
                        continue
                    if (self.reuests_para_val.check_contain_chinese(item['title'])) or (
                            self.reuests_para_val.check_contain_chinese(item['category'])):
                        self.asin_not_sure_list.append(asin)
                        continue
                    if items["buyBox_list"]:
                        self.buyBox_list.extend(items["buyBox_list"])
                    if items["buyBoxname_asin_list"]:
                        self.buyBoxname_asin_list.extend(items["buyBoxname_asin_list"])
                    if items["bs_category_asin_list_pg"]:
                        self.bs_category_asin_list_pg.extend(items["bs_category_asin_list_pg"])

                    if items["asin_variation_list"]:
                        item['variat_list'] = json.dumps(items["asin_variation_list"])  # 变体
                    else:
                        item['variat_list'] = None
                    item['asin_vartion_list'] = items["asin_variation_list"]
                    if items["all_img_video_list"]:
                        item['img_list'] = json.dumps(items["all_img_video_list"])
                    else:
                        item['img_list'] = None
                    self.item_queue.put(item)
                    if item['img_list'] is None:
                        item['img_list'] = []
                    # 获取字段值为None的字段名称写入redis进行统计
                    none_keys = [key for key, value in item.items() if
                                 (value is None) or (value == -1 and key == 'price') or (
                                         value == 0 and key in ['weight', 'total_comments', 'rating'])]
                    for key in ['parentAsin', 'week', 'all_best_sellers_herf', 'best_sellers_rank', 'seller_id',
                                'account_url', 'product_json', 'product_detail_json', 'review_ai_text', 'lob_asin_json',
                                'sp_initial_seen_asins_json', 'sp_4stars_initial_seen_asins_json',
                                'sp_delivery_initial_seen_asins_json', 'compare_similar_asin_json',
                                'customer_reviews_json', 'together_asin_json', 'min_match_asin_json',
                                'product_description', 'variat_num', 'qa_num', 'asin_vartion_list', 'review_label_json',
                                'seller_json', 'current_asin', 'five_six_val', 'best_sellers_herf',
                                'bundles_this_asins_json'
                                ]:
                        if key in none_keys:
                            none_keys.remove(key)

                else:
                    self.asin_not_div_id_dp_list.append(asin)
                    continue
            else:
                print(f"当前线程-已完成-爬取-跳出循环")
                break

    def on_send_success(self, record_metadata):
        print(f"消息发送成功: {record_metadata.topic}-{record_metadata.partition}-{record_metadata.offset}")

    def on_send_error(self, excp):
        print("消息发送失败", excp)

    def send_kafka(self, items=None, html_data=None, topic=None, num=3):
        print('向Kafka发送数据')
        for i in range(3):
            try:
                if items:
                    del items['div_id_list']
                    future = self.kafuka_producer_str.send(topic, json.dumps(items))
                    future.add_callback(self.on_send_success).add_errback(self.on_send_error)

                if html_data:
                    future = self.kafuka_producer_str.send(topic, html_data)
                    future.add_callback(self.on_send_success).add_errback(self.on_send_error)
                print('向Kafka发送数据 发送成功')
                break
            except Exception as e:
                print(e)
                if i >= 1:
                    self.kafuka_producer_str = self.save_asin_detail.kafuka_producer_str
        try:
            self.kafuka_producer_str.flush(timeout=10)
        except KafkaTimeoutError as e:
            print("flush 超时，跳过这次等待：", e)

    # 压缩字符串
    def compress_string(self, input_string):
        return gzip.compress(input_string.encode())

    def init_list(self):
        print("=======清空变量==========")

        self.asin_not_found_list = []  # 4
        self.asin_not_sure_list = []  # 6
        self.asin_not_foot_list = []  # 7
        self.asin_not_foot2_list = []  # 8
        self.asin_not_buyBox_list = []  # 9
        self.asin_not_response_list = []  # 10
        self.asin_not_redirect_list = []  # 12
        self.asin_not_div_id_dp_list = []  # 13 返回html没有包含div @id=dp,状态13
        self.requests_error_asin_list = []  # 1
        self.asin_list_update = []  # 3
        self.item_queue = Queue()  # 存储 item 详情数据队列
        self.queries_asin_queue = Queue()  # 需要爬取的asin队列
        self.buyBox_list = []  # 卖家名称 url 列表
        self.asin_detail_list = []  # 存储asin 详情的列表
        self.buyBoxname_asin_list = []  # asin 卖家的列表
        self.delete_cookies_list = []  # 存储出现中国邮编的cookie
        self.star_list = []
        self.add_cart_asin_list = []  # 存储绑定购买的asin
        self.asin_brand_list = []
        self.bs_category_asin_list = []
        self.bs_category_asin_list_pg = []
        # 关闭redis
        self.redis14.close()
        self.kafuka_producer_str.close(timeout=10)
        self.asin_video_list = []
        self.cookies_queue = Queue()  # cookie队列
        self.item_queue = Queue()  # 存储 item 详情数据队列
        self.queries_asin_queue = Queue()  # 需要爬取的asin队列
        self.buyBox_list = []  # 卖家名称 url 列表
        self.asin_detail_list = []  # 存储asin 详情的列表
        self.buyBoxname_asin_list = []  # asin 卖家的列表item
        self.delete_cookies_list = []  # 存储出现中国邮编的cookie
        self.cookie_dict_delete_id = {}
        self.star_list = []  # 存储星级百分比
        self.add_cart_asin_list = []  # 存储 绑定购买的asin
        self.asin_brand_list = []  # 存储asin 对应 的品牌
        self.bs_category_asin_list = []  # 存储 asin 详情 bsr 文本类目
        self.bs_category_asin_list_pg = []  # 存储 asin 详情 bsr 文本类目
        # 验证码 1
        self.yzm_err_total_list = []
        # 异常 2
        self.asin_request_errp_total_list = []
        # 成功 3
        self.success_asin_total_list = []
        # 每小时
        self.hour_total_count_list = []
        # 总请求 4
        self.request_total_count_list = []

    def run(self):
        # asin_list = self.save_asin_detail.read_db_data()
        asin_list = ['B0FHPBN5BD|2025-01|1|1|null|null',
                     'B0F98H3X25|2025-01|1|1|null|null',
                     'B0FC5C8LYB|2025-01|1|1|null|null',
                     'B0F1C95Y7Z|2025-01|1|1|null|null',
                     'B0F1XPL81W|2025-01|1|1|null|null',
                     'B0FH6HXXKG|2025-01|1|1|null|null',
                     'B0FCDXQNKW|2025-01|1|1|null|null',
                     'B0FB8D2RZX|2025-01|1|1|null|null',
                     'B0F4QJ2PKL|2025-01|1|1|null|null',
                     'B0FTTSTYBH|2025-01|1|1|null|null',
                     'B0F1X7Y6HG|2025-01|1|1|null|null',
                     'B0FK4RJ8BQ|2025-01|1|1|null|null',
                     'B0FB31NQ6C|2025-01|1|1|null|null',
                     'B0F1XBNK8N|2025-01|1|1|null|null',
                     'B0F4R31W9G|2025-01|1|1|null|null',
                     'B0F2RZ7SQY|2025-01|1|1|null|null',
                     'B0FJL52XZL|2025-01|1|1|null|null',
                     'B0F1S7FC9Z|2025-01|1|1|null|null',
                     'B0FB3CGNWF|2025-01|1|1|null|null',
                     'B0F2SLP2JM|2025-01|1|1|null|null',
                     'B0FJ7YWTBC|2025-01|1|1|null|null',
                     'B0F1C95998|2025-01|1|1|null|null',
                     'B0FMRKGK1B|2025-01|1|1|null|null',
                     'B0F1NCNGCY|2025-01|1|1|null|null',
                     'B0FGHHZRDB|2025-01|1|1|null|null',
                     'B0FH6CRWJ3|2025-01|1|1|null|null',
                     'B0F4CGG71T|2025-01|1|1|null|null',
                     'B0F93LS2X4|2025-01|1|1|null|null',
                     'B0F8B343WJ|2025-01|1|1|null|null',
                     'B0F1CCJ6T8|2025-01|1|1|null|null',
                     'B0FPFKLV4W|2025-01|1|1|null|null',
                     'B0FB82RRNJ|2025-01|1|1|null|null',
                     'B0FBG8BNWR|2025-01|1|1|null|null',
                     'B0F1XD9PP4|2025-01|1|1|null|null',
                     'B0F1X9GPV4|2025-01|1|1|null|null',
                     'B0F4R1RKG7|2025-01|1|1|null|null',
                     'B0CM8VHPPG|2025-01|1|1|null|null',
                     'B0FPKC3VXL|2025-01|1|1|null|null',
                     'B0F9P17QZB|2025-01|1|1|null|null',
                     'B0FRLL5FRD|2025-01|1|1|null|null',
                     'B0FPX6QGC7|2025-01|1|1|null|null',
                     'B0FP97HMR6|2025-01|1|1|null|null',

                     ]
        if asin_list:
            for asin in asin_list:
                self.queries_asin_queue.put(asin)
            if self.cookies_queue.empty():
                cookies_dict = self.reuests_para_val.get_cookie()
                self.cookie_dict_delete_id = cookies_dict
                for ck in cookies_dict.values():
                    self.cookies_queue.put(ck)
            html_thread = []
            for i in range(2):
                thread2 = threading.Thread(target=self.get_asin)
                thread2.start()
                html_thread.append(thread2)
            for t2 in html_thread:
                t2.join()

            while True:
                try:
                    self.save_asin_detail.process_item(self.item_queue, self.requests_error_asin_list,
                                                       self.asin_list_update, self.asin_not_found_list,
                                                       self.asin_not_sure_list, self.asin_not_foot_list,
                                                       self.asin_not_foot2_list, self.asin_not_buyBox_list,
                                                       self.asin_not_response_list, self.asin_not_redirect_list,
                                                       self.asin_not_div_id_dp_list, self.star_list,
                                                       self.add_cart_asin_list,
                                                       self.bs_category_asin_list, self.month_)
                    break
                except FunctionTimedOut as e:
                    print('断网', e)


# if __name__ == '__main__':
#     async_asin_pg(month=9, spider_int=1, week=14, site_name='us').run()


#
from datetime import datetime

# 当前日期
today = datetime.today()
#
# # 起始日期
start_date = datetime(2025, 5, 7)
#
# # 相差天数
delta_days = (today - start_date).days
print('相差天数',delta_days)
# # 除以30
result = delta_days / 30
print('每天销售',result)
print('累计销量', result * 9) # 每天* bsr月销
# print('每天销售* 月销售数量',result*110) # 每天销售* 月销售数量
# # 输出结果
print(f"到今天相隔 {delta_days} 天")
# # print(1426*20.99)
