import time
import random
import pandas as pd

from amazon_spider.conf.db import selection_table_name
from amazon_spider.db.mysql_db import get_country_engine


class ReadDb(object):
    def __init__(self, site="us"):
        self.site_name = site
        self.db_syn = selection_table_name.get(f"{self.site_name}_asin_table")
        self.db_comment_num_table = selection_table_name.get(f"{self.site_name}_comment_num_table")
        self.read_size = "30"
        self.df_read = pd.DataFrame()
        self.index_tuple = tuple()
        self.engine_pg = get_country_engine(self.site_name)
        self.conn = self.engine_pg.connect()

    def read_db_data(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    sql_read = f'SELECT distinct(asin) FROM {self.db_syn} WHERE STATE=1 LIMIT {self.read_size} for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['asin'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.db_syn} a set state=2 where a.asin in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE {self.db_syn} a set state=2 where a.asin in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def read_db_variat(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    sql_read = 'SELECT distinct(parent_asin) FROM `%s_self_variat` WHERE STATE=1 LIMIT %s for update;' % (self.site_name, self.read_size)
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['parent_asin'])
                    self.df_read.drop_duplicates(['parent_asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['parent_asin'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE `{self.site_name}_self_variat` a set state=2 where a.parent_asin in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE `{self.site_name}_self_variat` a set state=2 where a.parent_asin in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['parent_asin'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def get_seeds(self):
        sql = f"select id, parent_asin as asin from {self.site_name}_self_variat where state=3;"
        df_self_asin = pd.read_sql(sql, con=self.conn)

        sql = f"SELECT parent_asin as asin, comment_num from {self.db_comment_num_table};"
        df_asin_comment_num = pd.read_sql(sql, con=self.conn)

        df_check_num = df_self_asin.merge(df_asin_comment_num, on='asin', how='left')

        df_check_num = df_check_num.fillna(0)

        return df_check_num

    def get_asin_seeds(self):
        sql = f"select bsrlink from category_bsr_data_templete;"
        df_self_asin = pd.read_sql(sql, con=self.conn)
        return df_self_asin

    def read_db_detail(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    sql_read = f'SELECT asin, id, `is_variat`, `week`, `data_type` FROM {self.site_name}_all_syn_st WHERE STATE=1 LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'is_variat', 'week', 'data_type'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_all_syn_st a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_all_syn_st a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'is_variat', 'week', 'data_type'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def read_db_mx_asin(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    sql_read = f'SELECT asin,id FROM mx_self_asin WHERE STATE=1 LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE mx_self_asin a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE mx_self_asin a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def read_db_feedback(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    sql_read = f"SELECT `id`, `account_name`, `url` FROM {self.site_name}_seller_account_syn where state=1 LIMIT 30 for update;;"
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['id', 'account_name', 'url'])
                    self.df_read.drop_duplicates(['account_name'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_seller_account_syn a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_seller_account_syn a set state=2 where a.id in {self.index_tuple}"""
                        print(sql_update)
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['id', 'account_name', 'url'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def read_db_keepa(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    # 测试
                    # sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site from {self.site_name}_self_all_syn WHERE STATE=1 and date_info is not null and data_type like "%4%" ORDER BY priority asc LIMIT 30 for update;'
                    sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site FROM {self.site_name}_self_all_syn WHERE STATE=1 ORDER BY priority asc LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_all_syn a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_all_syn a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def read_db_real_keepa(self):
        while True:
            try:
                with self.engine_pg.begin() as conn:
                    sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site, account_id FROM {self.site_name}_self_real_spider WHERE STATE=1 order by priority, updated_at asc LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'account_id'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'account_id'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg = get_country_engine()
                continue

    def read_db_serch_keyword(self):
        try:
            with self.engine_pg.begin() as conn:
                sql_read = f'SELECT id, new_title as search_term, asin, site from us_self_asin_amazon_syn where state=1 limit 10 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'search_term', 'asin', 'site'])
                self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE us_self_asin_amazon_syn a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE us_self_asin_amazon_syn a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'search_term', 'asin', 'site'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_pg = get_country_engine()
            # continue

    def read_db_temu_serch_keyword(self):
        try:
            with self.engine_pg.begin() as conn:
                sql_read = f'SELECT id, new_title as search_term, asin, site from us_self_asin_top_copy3 where state=1 limit 10 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'search_term', 'asin', 'site'])
                self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE us_self_asin_top_copy3 a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE us_self_asin_top_copy3 a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'search_term', 'asin', 'site'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_pg = get_country_engine()
            # continue

    # def update_db_temu_serch_state(self):
    #     # while True:
    #     try:
    #         self.engine_pg = get_country_engine(self.site_name)
    #         with self.engine_pg.begin() as conn:
    #             if len(self.index_tuple) == 1:
    #                 sql_update = f"""UPDATE us_self_asin_top a set state=2 where a.id in ({self.index_tuple[0]})"""
    #             else:
    #                 sql_update = f"""UPDATE us_self_asin_top a set state=2 where a.id in {self.index_tuple}"""
    #             conn.execute(sql_update)
    #     except Exception as e:
    #         # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
    #         time.sleep(random.uniform(3, 10.5))
    #         self.engine_pg = get_country_engine()


class ReadCookie(object):
    def __init__(self, site="us"):
        self.site_name = site
        self.db_syn = selection_table_name.get(f"{self.site_name}_comment_cookies_table")
        self.df_read = pd.DataFrame()
        self.index_tuple = tuple()
        self.engine_pg = get_country_engine(self.site_name)
        self.conn = self.engine_pg.connect()

    def get_cookie(self):
        # c = int(time.time()) - 345600
        c = int(time.time()) - (86400 * 6)
        if self.site_name == "mx":
            self.db_syn = "us_mx_cookies"
        elif self.site_name == "ca":
            self.db_syn = "us_ca_cookies"
        t = time.strftime("%Y-%m-%d", time.gmtime(c))
        sql = f'select cookies,id from {self.db_syn} where state=1 and created_time>"{t}"'
        # sql = f'-- select cookies,id from it_cookies where created_time>"{t}"'
        df_cookie = pd.read_sql(sql, con=self.conn)
        return df_cookie


# class ReadKeepa(object):
#     def __init__(self, site="us"):
#         # self.site_name = site
#         # self.db_syn = selection_table_name.get(f"{self.site_name}_comment_cookies_table")
#         self.df_read = pd.DataFrame()
#         self.index_tuple = tuple()
#         self.engine_pg = get_country_engine("keepa")
#         self.conn = self.engine_pg.connect()
#
#     def get_keepa_seeds(self):
#
#         sql = f"select asin from `product_publish` where `sales_90` > 0 and `salesChannel` = 'Amazon.com' and  (sale_status in ('正常销售', '精品打造阶段', '精品维护阶段', '发货限制安排跟卖', '已安排跟卖') or (sale_status = '清仓下架' and fulFillable > 1)) and asin not in (SELECT asin from  product_publish_keepa);"
#         # sql = f'-- select cookies,id from it_cookies where created_time>"{t}"'
#         df_seeds = pd.read_sql(sql, con=self.conn)
#
#         sql_keepa = f"SELECT * from  product_publish_keepa"
#         df_keepa = pd.read_sql(sql, con=self.conn)
#         return df_seeds


# print(list(ReadCookie("us").get_cookie().values))

# df = ReadDb("it").get_seeds()
# print(df)

# ReadKeepa("fr").get_keepa_seeds()


