Java.perform(function () {
    try {
        // 直接 Hook OkHttp 请求发送，读取完整表单
        const OkHttpClient = Java.use("okhttp3.OkHttpClient");
        OkHttpClient.newCall.implementation = function (request) {
            const url = request.url().toString();
            if (url.includes("/vsearch/2.0")) {
                const body = request.body();
                if (body && body.contentType().toString().includes("multipart/form-data")) {
                    try {
                        // 读取完整请求体
                        const buffer = Java.use("okio.Buffer").$new();
                        body.writeTo(buffer);
                        const formData = buffer.readUtf8();

                        // 提取 query_metadata（不做格式校验）
                        const qPos = formData.indexOf('name="query_metadata"');
                        if (qPos !== -1) {
                            // 从字段名位置向后取 2000 字符（覆盖大多数情况）
                            const qValue = formData.substring(qPos + 20, qPos + 2020).split("\r\n--")[0];
                            console.log("\nquery_metadata 值:\n" + decodeURIComponent(qValue.trim()));
                        }

                        // 提取 authtoken（不做格式校验）
                        const aPos = formData.indexOf('name="authtoken"');
                        if (aPos !== -1) {
                            // 从字段名位置向后取 500 字符
                            const aValue = formData.substring(aPos + 18, aPos + 518).split("\r\n--")[0];
                            console.log("\nauthtoken 值:\n" + decodeURIComponent(aValue.trim()));
                        }
                    } catch (e) {
                        console.log("提取失败: " + e.message);
                    }
                }
            }
            return this.newCall(request);
        };
        console.log("脚本已启动，触发操作后将打印参数");
    } catch (e) {
        console.log("Hook 失败: " + e.message);
    }
});