import json

from utils.datahub_util import build_column_lineages

to_tb = "dim_asin_label"
sources = [
    {
        "form": "ods_other_search_term_data",
        "mappings": [
            ("asin", "asin"),
            ("label", "asin_label_list"),
            ("label", "asin_label_type"),

        ]
    }
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
