import time
import sys, os
import logging
import requests
import pandas as pd
sys.path.append(os.path.dirname(sys.path[0]))
from db.mysql_db import get_country_engine, sql_insert, sql_insert_many, sql_connect, sql_delete


os.environ['NO_PROXY'] = 'stackoverflow.com'


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s', level=logging.INFO)


def get_1688_memberId(site):
    # BSR榜单每日1次、新品榜单每日1次
    engine = get_country_engine(site)
    sql = f"SELECT memberId from company_info_1688 ORDER BY  updated_at limit 100;"
    # 测试
    df_memberId = pd.read_sql(sql, con=engine)
    return df_memberId.to_dict(orient='records')


def del_memberId(site, sql, datas=None):
    with get_country_engine(site).connect() as conn:
        if data != None:
            if data:
                conn.execute(sql, data)
        else:
            conn.execute(sql)
        print("del memberId")


seeds = get_1688_memberId("us")
for i in seeds:
    url = "http://61.145.136.61:22223/get_module"
    data = {"memberId": i.get('memberId')}
    responses = requests.post(url=url, data=data, timeout=20)
    print(responses.text)
    try:
        resp_data = responses.json()
    except requests.exceptions.JSONDecodeError:
        print("memberId", i)
        # <!doctype html>
        del_sql = f"""DELETE from company_info_1688 where memberId='{i.get('memberId')}'"""
        del_memberId("us", del_sql)
        continue
    if data.get("url"):
        if resp_data.get('msg', {}):
            print("有 home_url")
            print(resp_data)
        else:
            print("没有 home_url")
            print(resp_data)
    else:
        if resp_data.get('msg', {}).get('home_url'):
            print("有 home_url")
            print(resp_data)
        else:
            print("没有 home_url")
            print(resp_data)
    print("耗时：", responses.elapsed.total_seconds())
    time.sleep(5)


print('---- ----1---- ----\n' '---- ----2---- ----\n' '---- ----3---- ----\n' '---- ----4---- ----\n')

