import os
import sys
from datetime import datetime, timedelta

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
import time, random
import multiprocessing
from amazon_spider.seller_account_feedback import async_account_feedback
from amazon_spider.products_asin import async_account_name_products
from amazon_spider.VPS_IP import pppoe_ip
from utils.secure_db_client import get_remote_engine


def db_engine(site_name, db_type):
    """
    "mysql": "mysql",  # 阿里云mysql
    "postgresql_14": "postgresql_14",  # pg14爬虫库-内网
    "postgresql_14_outer": "postgresql_14_outer",  # pg14爬虫库-外网
    "postgresql_15": "postgresql_15",  # pg15正式库-内网
    "postgresql_15_outer": "postgresql_15_outer",  # pg15正式库-外网
    "postgresql_cluster": "postgresql_cluster",  # pg集群-内网
    "postgresql_cluster_outer": "postgresql_cluster_outer",  # pg集群-外网
    "doris": "doris",  # doris集群-内网
    """
    engine_mysql = get_remote_engine(
        site_name=site_name,  # -> database "selection"
        db_type=db_type,  # -> 服务端 alias "mysql"
    )
    return engine_mysql


def select_sate_mysql(site, num=None, page=None, week=None, table_name=None):
    print('当前抓取周：：', week)
    if int(week) < 10:
        week = f'0{int(week)}'
    else:
        week = week
    if num == 2:
        print('查询店铺产品。 feedback 抓取状态')
        sql_read = f"SELECT status_val FROM workflow_progress where page='{page}' and date_info='2025-{week}' and site_name='{site}' and date_type='week'"
        print(sql_read)
        engine_pg = db_engine('us', 'mysql')
        df = engine_pg.read_sql(sql_read)
        print(df.status_val)
        if df.status_val[0] == 3:
            print(site, page, '已完成')
            return False
        else:
            print(f'开始 {page}')
            return True


def feedback_products(site, proxy_name, week):
    print('抓取店铺')
    state = select_sate_mysql(num=2, page='店铺Feedback', site=site, week=week)
    if state:
        account_asin_us = async_account_feedback(site, read_size=150, proxy_name=proxy_name, week=week)
        account_asin_us.run()
    else:
        state = select_sate_mysql(num=2, page='店铺产品', site=site, week=week)
        if state:
            products_asin_us = async_account_name_products(site, read_size=200, proxy_name=proxy_name, week=week)
            products_asin_us.run()


def long_time_task(site, proxy_name, week):
    feedback_products(site, proxy_name, week)


if __name__ == '__main__':
    pppoe_ip()
    site_list = ['us', 'de', 'uk', 'fr', 'es', 'it']
    week = int(sys.argv[1])
    proxy_name = None
    for site in site_list:
        while True:
            current_time = datetime.now()
            # 计算后五分钟的时间
            five_minutes_later = current_time + timedelta(minutes=1)
            print('后五分钟时间', five_minutes_later)
            processes = []
            for _ in range(6):
                process = multiprocessing.Process(target=long_time_task, args=(site, proxy_name, week))
                processes.append(process)
                process.start()
                time.sleep(2)
            # 等待所有子进程执行完毕
            for process in processes:
                process.join()
            print('所有进程运行完毕！开始切换ip')
            print('所有进程运行完毕！开始切换ip')
            print('所有进程运行完毕！开始切换ip')
            print('所有进程运行完毕！开始切换ip')
            current_time = datetime.now()
            if current_time > five_minutes_later:
                pppoe_ip()
            else:
                time.sleep(random.uniform(150, 220))
                pppoe_ip()
            if select_sate_mysql(site, page='店铺产品', num=2, week=week) == False:
                break
