import sys
import os
from datetime import datetime, timedelta

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
import time, random
import multiprocessing
from amazon_spider.asin_detail_mysql import async_asin_mysql
from amazon_spider.asin_detail_pg import async_asin_pg
from amazon_spider.VPS_IP import pppoe_ip
from threading_spider.update_spdier_state import select_sate_mysql


def long_time_task(site, proxy_name, week):
    print("当前 抓取 站点 ", site, proxy_name)
    if site == 'us':
        print("开始=============== us asin 抓取 =======================", proxy_name)
        async_asin_us = async_asin_pg(site, proxy_name=proxy_name, week=week)
        async_asin_us.run()
    else:
        print("开始=============== asin 抓取 =======================")
        async_asin_es = async_asin_mysql(site, proxy_name=proxy_name, week=week)
        async_asin_es.run()


def start_run(week):
    pppoe_ip()
    site_list = ['de', 'uk']
    proxy_name = None
    for site in site_list:
        if select_sate_mysql(site=site, week=week):
            while True:
                current_time = datetime.now()
                # 计算后五分钟的时间
                five_minutes_later = current_time + timedelta(minutes=2)
                print('后五分钟时间', five_minutes_later)
                processes = []
                for _ in range(4):
                    process = multiprocessing.Process(target=long_time_task, args=(site, proxy_name, week))
                    processes.append(process)
                    process.start()
                # 等待所有子进程执行完毕
                for process in processes:
                    process.join()
                print('所有进程运行完毕！开始切换ip')
                current_time = datetime.now()
                if current_time > five_minutes_later:
                    pppoe_ip()
                else:
                    time.sleep(random.uniform(150, 300))
                    pppoe_ip()
                if select_sate_mysql(site=site, num=3, week=week) == False:
                    break


if __name__ == '__main__':
    try:
        week = int(sys.argv[1])
    except:
        week = None
    start_run(week)
