import json
import time
import redis
import logging
import sys, os
import platform
from scrapy.utils.project import get_project_settings
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(sys.path[0]))))
from amazon_spider.utils.read_db_data import ReadDb


if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()

REDIS_CONF = get_project_settings().get('REDIS')


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                            level=logging.INFO)


def get_redis_client():
    client = redis.StrictRedis(**REDIS_CONF)
    return client


redis_client = get_redis_client()


def seeds(site="us"):
    seed = list(list(i) for i in ReadDb(site).read_db_tautology_keepa().values)
    pipe = redis_client.pipeline(transaction=False)
    for job in seed:
        meta = {
            "asin": job[0],
            "asin_type": job[2],
            "is_variation": job[3],
            "date_info": job[4],
            "site": job[5],
            "priority": job[6],
        }
        k = json.dumps(meta)
        pipe.zadd(f"{site}_day_seed", {k: job[6]})
        # pipe.sadd(f"{site}_day_seed", k)
    pipe.execute()


if __name__ == '__main__':
    # for i in ["us"]:
    for i in ["us", "uk", "fr", "de", "it", "es"]:
        logging.info(f"推送{i}任务——————")
        seeds(i)
        logging.info(f"推送{i}任务完成——————")
        time.sleep(5)




