import sys, os
import platform
import json
import logging
import time
import redis
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(sys.path[0]))))
if "Windows" == platform.system():
    print("windows")
    sys.path = [
        'C:\\Users\\Administrator\\Desktop\\Amazon-Selection\\amazon_spider\\amazon_spider\\amazon_spider\\spiders',
        'D:\\Program Files\\JetBrains\\PyCharm 2024.1.3\\plugins\\python\\helpers\\pycharm_display',
        'D:\\Users\\Administrator\\AppData\\Local\\Programs\\Python\\Python38\\python38.zip',
        'D:\\Users\\Administrator\\AppData\\Local\\Programs\\Python\\Python38\\DLLs',
        'D:\\Users\\Administrator\\AppData\\Local\\Programs\\Python\\Python38\\lib',
        'D:\\Users\\Administrator\\AppData\\Local\\Programs\\Python\\Python38',
        'D:\\Users\\Administrator\\AppData\Local\\Programs\\Python\\Python38',
        'D:\\Users\\Administrator\\AppData\Local\\Programs\\Python\\Python38\\Lib\\site-packages',
        'D:\\Program Files\\JetBrains\\PyCharm 2024.1.3\\plugins\\python\\helpers\\pycharm_matplotlib_backend',
        'C:\\Users\\Administrator\\Desktop\\Amazon-Selection\\amazon_spider\\amazon_spider']
else:
    time.tzset()
from amazon_spider.utils.read_db_data import ReadDb, ReadCookie
from scrapy.utils.project import get_project_settings

REDIS_CONF = get_project_settings().get('REDIS')


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                            level=logging.INFO)


def get_redis_client():
    client = redis.StrictRedis(**REDIS_CONF)
    return client


redis_client = get_redis_client()


def seeds(site="us"):
    r_db = ReadDb(site)

    seed = list(list(i) for i in r_db.read_db_keepa().values)
    pipe = redis_client.pipeline(transaction=False)
    for job in seed:
        meta = {
            "asin": job[0],
            "asin_type": job[2],
            "is_variation": job[3],
            "date_info": job[4],
            "site": job[5],
            "priority": job[6],
        }
        k = json.dumps(meta)
        pipe.zadd(f"{site}_day_seed", {k: job[6]})

        # pipe.sadd(f"{site}_day_seed", k)
    pipe.execute()


if __name__ == '__main__':
    for i in ["us"]:
    # for i in ["us", "uk", "fr", "de", "it", "es"]:
        logging.info(f"推送{i}任务——————")
        seeds(i)
        logging.info(f"推送{i}任务完成——————")
        time.sleep(5)


# spiders = {}
# module_content = import_module(f'amazon_spider.spiders.test_redis')
# # print(module_content)
# # print(vars(module_content))
# # obj = getattr(module_content, 'TestSpider')
# for block_name, block_type in vars(module_content).items():
#     if block_name == 'TestSpider':
#         print(block_name, block_type)
#         spiders.update({block_type.name: block_type})
# print("-----")
# print(spiders)
# spider = spiders['test']().custom_settings
# seeds_generate = seeds(spider)
# count = 0
# for seed in seeds_generate:
#     try:
#         spider.push_request(seed)
#         count += 1
#     except Exception as e:
#         logging.exception(f'error push')

