import os
import sys


sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.common_util import DateTypes
from utils.hdfs_utils import HdfsUtils


if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None).replace("month_week", "month")
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    hive_table = f"ods_st_quantity_being_sold"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info
    }

    # 落表路径校验
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)
    print(f"hdfs_path is {hdfs_path}")

    # 日期拆分
    d1, d2 = CommonUtil.split_month_week_date(date_type, date_info)

    if date_type == DateTypes.week.name:
        d2 = f'0{d2}' if int(d2) < 10 else f'{d2}'
        if site_name == 'us' and date_info >= '2023-18':
            db_type = 'postgresql'
            if date_info >= '2023-34':
                db_type = 'postgresql_14'
        else:
            db_type = 'postgresql_14'
        import_table = f"{site_name}_brand_analytics_{d1}_{d2}"

    if date_type == DateTypes.month.name or date_type == DateTypes.month_week.name:
        if site_name in ['us', 'uk', 'de']:
            db_type = 'postgresql_14'
            # pg的分区单位数是带0，如01、02、03
            d2 = f'0{d2}' if int(d2) < 10 else f'{d2}'
            import_table = f"{site_name}_brand_analytics_month_{d1}_{d2}"
        else :
            print(f"其他站点{date_type}数据暂未明确，请检查是否dateType传输有误")
            exit()

    sql_query = f"""
                                select 
                                 id,
                                 search_term,
                                 quantity_being_sold,
                                 date_info as date_flag,
                                 created_time,
                                 updated_time,
                                 quantity_being_sold_str,
                                 result_count,
                                 departments
                                from {import_table} 
                                where 1=1 
                                and \$CONDITIONS
                                """

    # 进行schema和数据校验
    if site_name not in ('fr', 'it', 'es'):
        CommonUtil.check_schema_before_import(db_type=db_type,
                                              site_name=site_name,
                                              query=sql_query,
                                              hive_tb_name=hive_table,
                                              msg_usr=['fangxingjun','chenyuanjie'])

    # 生成导出脚本
    import_sh = CommonUtil.build_import_sh(site_name=site_name,
                                           db_type=db_type,
                                           query=sql_query,
                                           hdfs_path=hdfs_path)
    # 导入前先删除原始hdfs数据
    HdfsUtils.delete_hdfs_file(hdfs_path)
    # 创建ssh Client对象--用于执行cmd命令
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, import_sh, ignore_err=False)
    # 创建lzo索引和修复元数据
    CommonUtil.after_import(hdfs_path=hdfs_path, hive_tb=hive_table)
    # 关闭链接
    client.close()
