import json
import time
import redis
import logging
import sys, os
import platform
from scrapy.utils.project import get_project_settings
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(sys.path[0]))))
from amazon_spider.utils.utils import send_mg
from amazon_spider.utils.read_db_data import ReadDb


if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()

REDIS_CONF = get_project_settings().get('REDIS')


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                            level=logging.INFO)


def get_redis_client():
    client = redis.StrictRedis(**REDIS_CONF)
    return client


redis_client = get_redis_client()


def seeds(site="us"):
    seed = list(list(i) for i in ReadDb(site).read_self_asin_seeds().values)
    logging.info(f"{site} 站点 数据量为 {len(seed)}")
    pipe = redis_client.pipeline(transaction=False)
    for job in seed:
        meta = {
            "asin": job[0],
        }
        k = json.dumps(meta)
        # pipe.sadd(f"{site}_variat_seed", k)
        pipe.zadd(f"{site}_variat_seed", {k: int(time.time())})

    pipe.execute()


if __name__ == '__main__':
    for i in ["us"]:
    # for i in ["us", "uk", "fr", "de", "it", "es"]:
        logging.info(f"推送{i}任务——————")
        for num in range(0, 3):
            try:
                seeds(i)
                logging.info(f"推送{i}任务完成——————")
                time.sleep(5)
                break
            except Exception as e:
                print(e)
                account = 'hezhe'
                title = f'{i} 站点 内部asin 调度 数据插入失败'
                content = f"{i} 站点 内部asin 调度 数据插入失败 时间：{time.strftime('%Y-%m-%d %H:%M:%S', time.localtime())}"
                send_mg(account, title, content)
                continue


