import json
import time
import redis
import logging
import sys, os
import platform
from scrapy.utils.project import get_project_settings
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(sys.path[0]))))
from amazon_spider.utils.read_db_data import ReadDb


if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()

REDIS_CONF = get_project_settings().get('REDIS')


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                            level=logging.INFO)


def get_redis_client():
    client = redis.StrictRedis(**REDIS_CONF)
    return client


redis_client = get_redis_client()


def seeds(site="us"):
    pipe_count = redis_client.scard(f"{site}_search_seed")
    if pipe_count:
        logging.info("队列内数据未消费完")
        return
    seed = list(list(i) for i in ReadDb(site).read_db_other_search_asin_spider().values)
    pipe = redis_client.pipeline(transaction=False)
    for job in seed:
        # id, asin, username, sku, site
        if job[1]:
            meta = {
                "asin": job[1],
                "sku": job[2],
                "site": 'us' if job[3].split('.')[-1] == 'com' else job[3].split('.')[-1],
            }
            k = json.dumps(meta)
            pipe.sadd(f"{site}_search_seed", k)
        else:
            continue
        # pipe.zadd(f"{site}_search_seed", {k: int(time.time())})
    pipe.execute()


if __name__ == '__main__':
    for i in ["us"]:
    # for i in ["us",  "fr", "de", "es"]:
        logging.info(f"推送{i}任务——————")
        seeds(i)
        logging.info(f"推送{i}任务完成——————")
        time.sleep(5)



