from queue import Queue
# useful for handling different item types with a single interface
from amazon_spider.db.mysql_db import get_con, sql_connect
from amazon_spider.db.pg_db import get_pg_country_engine, get_pg_con


class AmazonTextSpiderPipeline:
    def __init__(self, site):
        self.site = site
        self.conn = get_con(self.site)
        self.pg_engine = get_pg_country_engine(self.site)
        self.pg_conn = get_pg_con(self.site)
        self.s = sql_connect(self.site)
        self.q_dict = {
            "inner_item_queue": Queue(),
            # "self_asin_seller_queue": Queue(),
            # "collection_syn_queue": Queue(),
            # "asin_detail_product_2023_queue": Queue(),
            "error_queue": Queue()
        }
        self.num = 50
        # logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
        #                     level=logging.INFO)

    @classmethod
    def from_crawler(cls, crawler):
        return cls(
            site=crawler.spider.site
        )

    def process_item(self, item, spider):
        print(item)






# conn = get_con("us")
# s = sql_connect("us")
# dates = [('B09GM8Y8BN', 'amazon.com', '16707', '4.5', '167', 'Visit the AROEVE Store', 'Home & Kitchen', 'Heating, Cooling & Air Quality', 'Air Purifiers', 'HEPA Air Purifiers', '', '', '', '510192', '{"6474046": 804920, "6474270": 816090, "6476596": 576284, "6476866": 623361, "6478072": 712591}', '{"7141123011": 4860126}', '')]
#
# print(dates)
# # dates = list(set([tuple(v.get()) for i in range(0, self.num)]))
# # ['asin', 'salesChannel', 'reviews', 'rating', 'current_rank', 'brand_name', 'root_category', 'second_category', 'three_category', 'four_category', 'five_category', 'six_category', 'seven_category', 'cat_id', 'history_rank', 'history_category', 'current_rank_avg']
# # inset_sql = f"insert into `product_publish_keepa_text` (`asin`, `salesChannel`, `reviews`, `rating`, `current_rank`, `brand_name`, `root_category`, `second_category`, `three_category`, `four_category`, `five_category`, `six_category`, `seven_category`, `cat_id`, `history_rank`, `history_category`, `current_rank_avg`) values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) ON DUPLICATE KEY UPDATE `history_rank` = values(`history_rank`)"
# inset_sql = f"REPLACE into `product_publish_keepa_text` (`asin`, `salesChannel`, `reviews`, `rating`, `current_rank`, `brand_name`, `root_category`, `second_category`, `three_category`, `four_category`, `five_category`, `six_category`, `seven_category`, `cat_id`, `history_rank`, `history_category`, `current_rank_avg`) values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s);"
# if len(dates) == 1:
#     sql_insert(inset_sql, dates[0])
# else:
#     sql_insert_many(inset_sql, dates)
# logging.info(f"更新product_publish_keepa_text-----{len(dates)}---------{dates}")