# coding:utf-8
import os
import re
import sys
import json
import time
import queue
import random
import scrapy
import logging
import platform
sys.path.append(os.path.dirname(os.path.dirname(sys.path[0])))  # 上级目录
from pprint import pprint
from urllib.parse import urlparse
from scrapy import cmdline, signals
from amazon_spider.utils.common import field_length_dispose
from amazon_spider.spiders.yswg_spider import SourceSpider
from amazon_spider.extractor.amazon_detail_extractor import AmazonDetailExtractor
from amazon_spider.items import detail_inner_item, self_asin_seller_item, variat_item


if "Windows" == platform.system():
    print("windows")
else:
    time.tzset()


class TextDetail(SourceSpider):
    name = 'text_detail'
    SCHEDULER_DUPEFILTER_KEY = '%(spider)s:dupefilter'
    custom_settings = {
        'CONCURRENT_REQUESTS': 25,
        'DOWNLOAD_TIMEOUT': 20,
        'allowed_domains': ['amazon.com'],
        # # 设置重启爬虫时是否清空爬取队列
        # 'SCHEDULER_FLUSH_ON_START': False,
        # # 启用Redis调度存储请求队列
        # 'SCHEDULER': "amazon_spider.scrapy_redis.scheduler.Scheduler",
        # # 确保所有的爬虫通过Redis去重
        # 'DUPEFILTER_CLASS': "amazon_spider.scrapy_redis.dupefilter.RFPDupeFilter",
        # 'SCHEDULER_QUEUE_CLASS': 'amazon_spider.scrapy_redis.queue.SpiderPriorityQueue',
        # # 种子队列的信息
        # 'REDIS_URL': None,
        # 'REDIS_HOST': '192.168.10.224',
        # 'REDIS_PORT': 6379,
        # 'REDIS_PARAMS': {
        #     'password': 'HCL1zcUgQesaaXNLbL37O5KhpSAy0c',
        #     'db': 0
        # },
        # # # 6379
        # # 'FILTER_URL': None,
        # # 'FILTER_HOST': '127.0.0.1',
        # # 'FILTER_PORT': 6379,
        # # # 6379
        # # 'FILTER_DB': 0,
        # 'SCHEDULER_QUEUE_KEY': "detail_seed",
        # Retry settings
        'RETRY_ENABLED': True,
        'RETRY_TIMES': 2,  # 想重试几次就写几
        # 'COOKIES_ENABLED': True,
        # 'COOKIES_DEBUG': False,
        'RETRY_HTTP_CODES': [203, 301, 403, 408, 429, 500, 502, 503, 504, 522, 524, 404],
        # downloader middlewares for spider.
        'DOWNLOADER_MIDDLEWARES': {
            'scrapy.downloadermiddlewares.retry.RetryMiddleware': None,
            # 递增调用
            'amazon_spider.middlewares.RandomUserAgentMiddleware': 460,
            # 'amazon_spider.middlewares.ProxyMiddleware': 450,
            'amazon_spider.middlewares.CookiesZip': 480,
            # 'amazon_spider.middlewares.GetCookieMiddleware': 460,
            # 'amazon_spider.middleware.http2.HttpxMiddleware': 490,
            # 'amazon_spider.middleware.aiohttp.AiohttpMiddleware': 490,
            # 'amazon_spider.middleware.temu.CurlCffiRequests': 490,
            # 递减调用
            # 'scrapy.downloadermiddlewares.retry.RetryMiddleware': 500
        },
        'ITEM_PIPELINES': {
            # 'amazon_spider.pipeline.real_keepa_pipe.AmazonRealKeepaSpiderPipeline': 230,
            # 'amazon_spider.pipeline.cs_count.FidleMonitorPipeline': 200,
            # 'amazon_spider.pipeline.news_real_pipe.AmazonRealKeepaSpiderPipeline': 200,
        },
        'DOWNLOAD_HANDLERS': {
            'http': 'amazon_spider.downloadhandlers.ja3.MyHTTPDownloadHandler',
            'https': 'amazon_spider.downloadhandlers.ja3.MyHTTPDownloadHandler',
        }
    }

    def __init__(self, site='us'):
        super(TextDetail, self).__init__()
        self.site = site
        self.update_cookies()
        self.sleep_count = 0
        self.seller_work = {
            "us": "Sold by",
            "uk": "Sold by",
            "fr": "Vendu par",
            "de": "Verkäufer",
            "es": "Vendedor",
            "it": "Venditore",
            "mx": "Vendedor",
            "ca": "Sold by"
        }

        self.seller_type = {
            "us": "Ships from",
            "uk": "Dispatches from",
            "fr": "Expéditeur",
            "de": "Versand",
            "es": "Envía por",
            "it": "Spedito da",
            "mx": "Envío por",
            "ca": "Ships from"
        }
        logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s', level=logging.INFO)
        # self.utils_requests = [{"use_httpx": True}]
        # self.asins = ['B0DYVQ3V7M', 'B0CXTH5M41', 'B0DSW7WZ8H', 'B0D9BTL63S', 'B0F2PQZ16P', 'B0DD7L7Y2C', 'B0DD7MB6S5']
        self.asins = ['B0DZ6PXNQW']
        # self.asins = ['B005KDX0B8', 'B006PWFO9O', 'B007QJ761Y', 'B0091CD9A6', 'B0092KDSQW', 'B009YF1GIC', 'B00A7Q4LH0', 'B00AKC65UM', 'B00AT93GBM', 'B00C3LVYEU', 'B00CBLVVZE', 'B00DHEUBPA', 'B00E4FR6BS', 'B00E4G2DTM', 'B00E4L7EWI', 'B00E4L9M0K', 'B00E55BB8Q', 'B00E55CZA4', 'B00E55HL6W', 'B00E5YC884', 'B00E5YNHWA', 'B00E5Z8NHS', 'B00E6IPQSS', 'B00E6KIT1C', 'B00E6KRUDA', 'B00E6KVKEA', 'B00E6LTOEM', 'B00E6M2PT2', 'B00E6MA04O', 'B00E6NJ13O', 'B00EABDSEU', 'B00ED75D08', 'B00ED7R8A6', 'B00ED7VIS4', 'B00ED8VOKK', 'B00EU1969Q', 'B00EU3JQV2', 'B00EYXIBYG', 'B00F1B4UM2', 'B00F34XX84', 'B00F4OOMQ0', 'B00FDNSMG8', 'B00FF7GUQG', 'B00FXORQZ0', 'B00GE1THP8', 'B00GJH5M42', 'B00GJIIRMA', 'B00H1HIZ2A', 'B00HLVKWJU', 'B00HMX21UA', 'B00HMX98FG', 'B00HMXV32C', 'B00HN8RUMS', 'B00HNIBA0Q', 'B00HNISOVE', 'B00HNJEOL2', 'B00HNLGF6M', 'B00HNLLWVU', 'B00HNMMROK', 'B00HNNJBMK', 'B00HNP23BE', 'B00HQ9CKMO', 'B00HQA1B78', 'B00HQAXE6O', 'B00HQBCST2', 'B00HSWQGL0', 'B00HSX2MNK', 'B00HT1NC44', 'B00HTX69A6', 'B00HTXQSI4', 'B00HU08RRG', 'B00HU0CG6E', 'B00HUHKWDG', 'B00HUHP13M', 'B00HUMSDPK', 'B00HUMW9HI', 'B00HUO7TN0', 'B00HUOABIK', 'B00HUOK9TQ', 'B00HUOLYPE', 'B00HV62V08', 'B00HV6AF2Y', 'B00HV6PGIC', 'B00HV7NEGC', 'B00HV8865A', 'B00HV8EG22', 'B00HV8WAUW', 'B00HV9D82A', 'B00HVABZRO', 'B00HVAKPN4', 'B00HVAMICA', 'B00HX84X5A', 'B00HX8HPEG', 'B00HXAOY8E', 'B00HXBS6R8', 'B00HY7BCEA', 'B00HY89IR2', 'B00HYRJNU0', 'B00HYUWDMC', 'B00HZ9DGFA', 'B00HZALDLS', 'B00HZAZ9N6', 'B00ID4Y2OU', 'B00IEWJVOM', 'B00IEY7B92', 'B00IHWI6UE', 'B00IIJDJW6', 'B00IIJDJYO', 'B00IIJDK20', 'B00IIJDK4S', 'B00IIJDKFW', 'B00IJ0RENO', 'B00IJ0RENY', 'B00IJ6C6X6', 'B00IJ72XWY', 'B00IJP1T26', 'B00IJQZ7AU', 'B00IJS9AHY', 'B00IK9CLEQ', 'B00IKAMFVE', 'B00IL17T3G', 'B00IL17T5Y', 'B00IL32EQQ', 'B00IM33I5Q', 'B00IM33I6A', 'B00IM6KK6S', 'B00IM6KL4Y', 'B00IM6LCRE', 'B00IM6LEUE', 'B00IM6LFU8', 'B00IM6LGXE', 'B00IM6LHQK', 'B00IM6LIXM', 'B00IM6LK26', 'B00IM6LL9I', 'B00IM6LMK6', 'B00IM72OA2', 'B00IM72P6K', 'B00IM72PX8', 'B00IM72R0Y', 'B00IM72S5I', 'B00IN1BUAW', 'B00INI8F08', 'B00INMOXBO', 'B00IOBQ8AI', 'B00IR4VZ8C', 'B00IR561Y4', 'B00ITEF4C8', 'B00ITG9NF0', 'B00IV91EAW', 'B00IWFHS3W', 'B00IWG4VEA', 'B00IYGJVNY', 'B00IYGJVOI', 'B00IYGJVSY', 'B00J20YMVW', 'B00J2O524O', 'B00J2O525I', 'B00J5BH594', 'B00J7LARYW', 'B00J8JEVQ8', 'B00J8JO4OM', 'B00J97O4HA', 'B00JA5LEEM', 'B00JA5LEV0', 'B00JA5LF4G', 'B00JA6LJKA', 'B00JB2MDCG', 'B00JB3P9LC', 'B00JB3P9NA', 'B00JE67EUK', 'B00JE67EWI', 'B00JEWCEMC', 'B00JEWWI7I', 'B00JEYBVJC', 'B00JF0KH1I', 'B00JF0KH2M', 'B00JFLLHBG', 'B00JFLLHGQ', 'B00JFMLJ7M', 'B00JFMLJA4', 'B00JJK4VRA', 'B00JM41TVE', 'B00JM41TZU', 'B00JM41U1I', 'B00JMA4J4C', 'B00JOC7G4S', 'B00JOCO7UO', 'B00JP3NU6E', 'B00JQ5PBZ4', 'B00JQ5PC2Q', 'B00JUF4P48', 'B00JVM15AM', 'B00JVN62GS', 'B00JZK0UAG', 'B00JZK0UCY', 'B00JZK0UEM', 'B00K41XX8G', 'B00K71Z6TM', 'B00K71Z6UG', 'B00K71Z6WO', 'B00K71Z6XS', 'B00K71Z70A', 'B00K8S0HOS', 'B00K8SEROE', 'B00KAWVKSO', 'B00KCBUJTY', 'B00KFB9CAI', 'B00KFB9CB2', 'B00KFB9CBC', 'B00KFB9CBW', 'B00KFB9CM6', 'B00KG2F4YO', 'B00KGVS1VI', 'B00KGVS1WW', 'B00KHPV8ZE', 'B00KIKN7ZM', 'B00KIKN86K', 'B00KKBXM0Y', 'B00KKIPK1G', 'B00KKZVE4G', 'B00KLWTODG', 'B00KLZDRCC', 'B00KM0CGUA', 'B00KM0RQ64', 'B00KM1HTAQ', 'B00KMIVCHU', 'B00KMJSL6Y', 'B00KMKRDNK', 'B00KMO302O', 'B00KMQGR6S', 'B00KNIDPZ6', 'B00KQDULKU', 'B00KQGBAZM', 'B00KQGX6O0', 'B00KRT89RU', 'B00KS3GG5M', 'B00KSXXYGQ', 'B00KT4BEFM', 'B00KT4BEHK', 'B00KTYFGB0', 'B00KTYS41O', 'B00KV1HALU', 'B00KV3281K', 'B00KW4G4FO', 'B00KW4LU3U', 'B00KW50E0E', 'B00KW5UHUG', 'B00KW5UI0U', 'B00KW5UI1E', 'B00KW5UI28', 'B00KW5UI3C', 'B00KW5UIGY', 'B00KWRII5A', 'B00KWRWXAQ', 'B00KWS6JI2', 'B00KWUNWHQ', 'B00KWUSQAY', 'B00KWYNF8S', 'B00KWYZFW2', 'B00KWZT5TU', 'B00KX0BLFA', 'B00KX0OH8S', 'B00KX18DSW', 'B00KX1O764', 'B00KX1UU42', 'B00KYK2BSA', 'B00L1UYGRG', 'B00L1VNWQG', 'B00L234EM4', 'B00L27VFQS', 'B00L2Z89KA', 'B00L3UH752', 'B00L3V5YCO', 'B00L7JOZ2M', 'B00L7JOZBI', 'B00L7JOZK4', 'B00L7O2AGA', 'B00L7OAMKQ', 'B00L7ORLHS', 'B00L7QFVB4', 'B00L7QW5SG', 'B00L7RE7SQ', 'B00L8F3EKO', 'B00L8FYFFW', 'B00L8GMF9Y', 'B00L8HBTVS', 'B00L8IJ8DI', 'B00L8JEM74', 'B00L8KKWLS', 'B00L8NL94E', 'B00LA1OIRE', 'B00LAOW1MU', 'B00LAQBA7K', 'B00LAQBBFG', 'B00LASIDGY', 'B00LASOXEU', 'B00LATQWLG', 'B00LAU1HGU', 'B00LBPSSR0', 'B00LF3ZCGI', 'B00LFIJ9N0', 'B00LFJ3VV0', 'B00LGBAUVG', 'B00LGBMZ8C', 'B00LGCCTLO', 'B00LGCCTNM', 'B00LHR1C0W', 'B00LIISJI8', 'B00LIK1K6Y', 'B00LIKRAU4', 'B00LLZG57U', 'B00LMWXOO4', 'B00LN095C0', 'B00LNTOAV2', 'B00LNTZUSE', 'B00LO3G9PW', 'B00LO62YT4', 'B00LP31AHI', 'B00LP917Q6', 'B00LP917WU', 'B00LS6TKOM', 'B00LULP594', 'B00LWVWPEK', 'B00LXOIWCU', 'B00LXUUCRC', 'B00LXXN0AA', 'B00LXXN18G', 'B00LZLSLIQ', 'B00M0F8VAO', 'B00M1I1QUC', 'B00M2GIBYW', 'B00M2P9RNC', 'B00M6INHGI', 'B00M6JPO72', 'B00M6QWFF4', 'B00M7SKD64', 'B00M8QS042', 'B00M8YB5QO', 'B00M92AYGC', 'B00M9XP7TU', 'B00MA0R5KQ', 'B00MA0R5LK', 'B00MA5Z3FA', 'B00MAZJEV4', 'B00MAZJFM2', 'B00MBAVCCC', 'B00MBB37AG', 'B00MCE8TWS', 'B00MCE8U0E', 'B00MCELKVU', 'B00MCHSCNQ', 'B00MCHSD2Q', 'B00ME7WH6M', 'B00MF9FIHE', 'B00MFBPEV2', 'B00MFJ5O4G', 'B00MFJ5OA0', 'B00MGHM08K', 'B00MHGXYH6', 'B00MHKE3MC', 'B00MHLKHJO', 'B00MIMIWVW', 'B00MLPEWGK', 'B00MLXUFSQ', 'B00MLYWUWY', 'B00MMZHCFW', 'B00MMZHCS4', 'B00MN7EOSC', 'B00MN7EQMG', 'B00MN9S7FQ', 'B00MO8VRCG', 'B00MOAZAEA', 'B00MOCS92I', 'B00MP3ZCFI', 'B00MP4E622', 'B00MQK73F2', 'B00MQMAOVA', 'B00MQMAOZQ', 'B00MQMAP5K', 'B00MQMAPN2', 'B00MQMAQ7C', 'B00MQP1LRS', 'B00MQP1LYG', 'B00MQRWNKK', 'B00MRM9Y9W', 'B00MRMQM06', 'B00MRVE3H6', 'B00MRVE3HQ', 'B00MRVE3IA', 'B00MRVE3Z8', 'B00MTA9PL4', 'B00MTG7N3U', 'B00MTHY3TQ', 'B00MVFLIZS', 'B00MVG1KFA', 'B00MVGRS24', 'B00MVGRSGK', 'B00MVHBVH6', 'B00MVHBVS0', 'B00MVMLWTS', 'B00MVNR37W', 'B00MWMQ7JM', 'B00MWSEAFO', 'B00MWSEB30', 'B00MXIQ7FE', 'B00MXIQ84O', 'B00MXOG3Y8', 'B00N2NLWBS', 'B00N3NXFT4', 'B00N4ET0C8', 'B00N4MK90M', 'B00N4NW6LQ', 'B00N4OKIPG', 'B00N4QRIJ8', 'B00N4R89K4', 'B00N8MWWQ2', 'B00N9S7UJO', 'B00N9UT9GE', 'B00NAQ8H38', 'B00NAQD3QO', 'B00NAQNW8S', 'B00NAQY7MS', 'B00NAR588E', 'B00NF8OZI2', 'B00NGIYKS6', 'B00NH85ZN4', 'B00NM6VM1U', 'B00NM7K4FO', 'B00NM8BRWW', 'B00NMB83RG', 'B00NMB83X0', 'B00NSE2LFC', 'B00NSJPTTW', 'B00NSJPTXS', 'B00NSJPU7S', 'B00NSJPU9G', 'B00NTMCZKE', 'B00NTP3OM4', 'B00NTWSCI8', 'B00NTWSCJC', 'B00NTWSCJM', 'B00NTWSCKG', 'B00NV0UG3M', 'B00NV3OSO2', 'B00NV4HLIG', 'B00NV4OVT8', 'B00NW4NP9E', 'B00NW51IFG', 'B00NZKMHLW', 'B00NZLXAU8', 'B00O8PK5C6', 'B00OB9MAYA', 'B00OBAXYFS', 'B00OIH36CA', 'B00OIHUZQU', 'B00OIICO40', 'B00OIIKQ40', 'B00OIITYZC', 'B00OIOIVKA', 'B00OIP2U60', 'B00OOMPFC8', 'B00OONESYI', 'B00OOO6VA6', 'B00OOOO0WC', 'B00ORKM56Q', 'B00ORKM5FW', 'B00ORLZPIU', 'B00ORMIK8G', 'B00ORP00JK', 'B00OT3W70A', 'B00OT3W71Y', 'B00OTGQ93I', 'B00OUS7KOC', 'B00OUS7KP6', 'B00OXP2NWQ', 'B00OYS76T2', 'B00OYSFB76', 'B00OZ5GV5O', 'B00OZ5GVAO', 'B00OZ73OLQ', 'B00OZ8887U', 'B00OZC3PE2', 'B00OZEC5DM', 'B00P0G9SOS', 'B00P0NHB4U', 'B00P0QEI9S', 'B00P0QSELQ', 'B00P78W0Z8', 'B00P7GSDOC', 'B00P7QQTPW', 'B00P8N5U1S', 'B00P8NIZFQ', 'B00P8Q7YSC', 'B00P8SORJO', 'B00P8SORK8', 'B00P8SORLC', 'B00P8SORMQ', 'B00P8SUWP2', 'B00P8VCUGS', 'B00P8WJYTS', 'B00PC017AU', 'B00PC1H2N0', 'B00PC2MPOA', 'B00PFDKX9U', 'B00PFDKXC2', 'B00PFDKXEU', 'B00PFE5J6G', 'B00PFH4SFQ', 'B00PI17G2G', 'B00PI3B83M', 'B00PIC6EG4', 'B00PIDS0LK', 'B00PJDNOQK', 'B00PJI6CPA', 'B00PJXG3VI', 'B00PK0DMVY', 'B00PLENHCS', 'B00PRVPUTI', 'B00PTGS93A', 'B00PTGS9YE', 'B00PVRMM58', 'B00Q2LN382', 'B00Q3TJ27E', 'B00Q3USG34', 'B00Q3WGKE4', 'B00Q7SL6B6', 'B00Q7SZTZ0', 'B00Q7UW9BA', 'B00Q9OSOZY', 'B00QG7U7FY', 'B00QG9RVUG', 'B00QHV9BF6', 'B00QLCSQAC', 'B00QNKRS8S', 'B00QPY8HWS', 'B00QQ4SQR8', 'B00QRB5V82', 'B00QUROZHG', 'B00QW9B4SU', 'B00QW9B53E', 'B00R160MYU', 'B00R180VP8', 'B00R2LYKM4', 'B00R432XC4', 'B00R5MSGZ2', 'B00R5O6E7C', 'B00R742DLQ', 'B00R75CNS8', 'B00R7GAHSK', 'B00R7GAHT4', 'B00R8WSPZ0', 'B00R939SHC', 'B00R950Y82', 'B00RB6OEPS', 'B00RE8V7LM', 'B00RFFV4XK', 'B00RFGWSES', 'B00RJZN7S6', 'B00RR51TMO', 'B00RTB5LWU', 'B00RYST0D4', 'B00RYW7BDG', 'B00RYZXM6I', 'B00S0L9VBK', 'B00S0L9VEM', 'B00S0LR13U', 'B00S0MRQSO', 'B00S232ITS', 'B00S232IXY', 'B00S28M7EO', 'B00S29J1FG', 'B00S9039VA', 'B00SAIZWKC', 'B00SF64I54', 'B00SIRZXUO', 'B00SMN3068', 'B00SO23G3E', 'B00SOFP4RM', 'B00SOJEJTM', 'B00SSKPD42', 'B00SSLMWHW', 'B00SSLQDRM', 'B00SUVOWLY', 'B00SWLZ3G0', 'B00T2IZTTI', 'B00T8QND3I', 'B00T8QNDBA', 'B00T9EL0TS', 'B00TAKJ69W', 'B00TD2DYS6', 'B00TD54FLI', 'B00TD54FN6', 'B00TDJFMUC', 'B00TF1S3UY', 'B00TI5YXOM', 'B00U8PA1SS', 'B00U8QH1CQ', 'B00UAHBSSG', 'B00UGW3WAW', 'B00UIVEJJY', 'B00UJ0S1C0', 'B00UJ3ORMU', 'B00UJ3TRHK', 'B00UKNS1JE', 'B00UMIWUTE', 'B00UV3YI6I', 'B00UVAG5T4', 'B00UWEEHFS', 'B00UYHLXJG', 'B00UYHLXNW', 'B00V02KNI6', 'B00V336UR0', 'B00V336USE', 'B00V336USO', 'B00V4FGLHG', 'B00V5PJPDC', 'B00V5Z7JV2', 'B00V67PONY', 'B00V9ICTKQ', 'B00V9JVOZ6', 'B00V9O23G0', 'B00V9O23L0', 'B00V9U9VEQ', 'B00VA2BFFG', 'B00VFL9QDU', 'B00VFT7KOY', 'B00VPSPBFU', 'B00W2ZYQN8', 'B00W3IMCS0', 'B00W3J1KIM', 'B00W4UK3H4', 'B00W6H2FJE', 'B00W8SDOJ6', 'B00W95UAOK', 'B00W95UATK', 'B00W9GXMNA', 'B00WATQP94', 'B00WAUW4MK', 'B00WBCJAA6', 'B00WBF6S6W', 'B00WDW61YC', 'B00WE21HAO', 'B00WE83S7S', 'B00WHB8QL0', 'B00WHNHBVO', 'B00WLGW5U4', 'B00WQCK8QQ', 'B00WQEF2FQ', 'B00WQVVJ5Q', 'B00WU7SSSC', 'B00WVUT72E', 'B00WWDQCVY', 'B00X3I1QGI', 'B00X3LM33K', 'B00X53MP3O', 'B00X9LVVQ4', 'B00XDOOVIW', 'B00XDQ0WR4', 'B00XE56JDK', 'B00XHDWJ1K', 'B00XHGGLCU', 'B00XHOO6TM', 'B00XIZWO08', 'B00XKLYKT8', 'B00XKTUQNO', 'B00XKWSBR4', 'B00XL4FV5G', 'B00XL4FV7O', 'B00XMB4RHG', 'B00XMB4RP8', 'B00XMDBFJM', 'B00XMDBFXI', 'B00XMFK3HK', 'B00XMR2ENY', 'B00XMRZ8HS', 'B00XMT5YPM', 'B00XMVXIYY', 'B00XMXTG9S', 'B00XN0E4GK', 'B00XORCZFE', 'B00XP9F1KM', 'B00XTZHU5Q', 'B00XTZI5QO', 'B00XVEZNXQ', 'B00XVEZO0S', 'B00XVEZO3A', 'B00XVEZOD0', 'B00XVEZOMQ', 'B00XVPVS9I', 'B00XVPVSAM', 'B00XVPVSCK', 'B00XVPVSCU', 'B00XVPVSD4', 'B00XVPVSHA', 'B00XVPVSIE', 'B00XVPVSJ8', 'B00XVPVSKC', 'B00XVPVSL6', 'B00XVPVSLG', 'B00XVPVSNY', 'B00XVPVSP2', 'B00XVPVSRK', 'B00XVPVSZC', 'B00XXO7IZ0', 'B00Y0BTYO8', 'B00Y0BTYV6', 'B00Y0BTYVG', 'B00Y0BTYXE', 'B00Y0BTZ1A', 'B00Y0BTZ1U', 'B00Y0BTZBK', 'B00Y0F7C9I', 'B00Y0F7CKW', 'B00Y0F7CMA', 'B00Y0F7CTS', 'B00Y0F7CVQ', 'B00Y0F7DJM', 'B00Y20WSLI', 'B00Y20WSRC', 'B00Y2J5HFI', 'B00Y2MQV4G', 'B00Y7R7KWI', 'B00Y7RJXQY', 'B00Y9RK1ZE', 'B00YA7KBO4', 'B00YBS0H6E', 'B00YBS0H8M', 'B00YBWXE8I', 'B00YBZZQMC', 'B00YEGG68G', 'B00YOCQD9C', 'B00YP12UM6', 'B00YRBTLMG', 'B00YTNSWJA', 'B00YU4GEKW', 'B00YU4GFLA', 'B00Z5PH20Q', 'B00Z645LWC', 'B00Z8QX5SA', 'B00Z9RR2B4', 'B00Z9RR2E6', 'B00Z9RR2EQ', 'B00ZCGEAQ2', 'B00ZCGZSDG', 'B00ZCHFU9W', 'B00ZEDL78C', 'B00ZEYK2IC', 'B00ZF0281Y', 'B00ZFBUJIM', 'B00ZFE0QT6', 'B00ZFHIQ6I', 'B00ZOMPRBQ', 'B00ZOMPRI4', 'B00ZOPOE9E', 'B00ZOPOEJE', 'B00ZR7YU9I', 'B00ZR8BU6I', 'B0105RO53A', 'B0106YD4ZC', 'B01070L6Q4', 'B01071CLE4', 'B0107PN3RO', 'B010AAPWOI', 'B010DA0VZU', 'B010L6JK80', 'B010N25GTY', 'B010N38ZOQ', 'B010P63INE', 'B010P9OCW2', 'B010PSBVM2', 'B010PZOY60', 'B010RRL9YG', 'B010SFQQCM', 'B010SHXDKS', 'B010WLYBZQ', 'B010WLYC2S', 'B010WLYC82', 'B010X0ACFE', 'B01112QA2C', 'B01112QA4A', 'B01112QA86', 'B0111HEXDU', 'B0111HEXH6', 'B0116Q2LJE', 'B0116V6RGM', 'B0117117NE', 'B0118MNE56', 'B011BL5UP6', 'B011HU3JAO', 'B011NFG8WY', 'B011NJHD4W', 'B011NLQZ7Q', 'B011NYCPRM', 'B011O0FJIC', 'B011U8RS3M', 'B011U8SHXW', 'B012704HFE', 'B0129UHWQS', 'B012A40QPC', 'B012S1D3Y8', 'B01306OIIK', 'B0130A3HSS', 'B0132VYJLE', 'B013BHLWG4', 'B013BHLWP0', 'B013BHLX68', 'B013EA4LUM', 'B013EB5ZLK', 'B013EB651O', 'B013P1F5IC', 'B013QX1G2I', 'B014F82ND4', 'B014IQLU6O', 'B014MHG5AK', 'B014W668VW', 'B014W6CTRO', 'B014W9J87U', 'B0154VJO9W', 'B015840IG8', 'B0158GSAWU', 'B015E44Q0Q', 'B015ISVGZ6', 'B015ME6Y76', 'B015MFGZBU', 'B015MU53QI', 'B015MU549O', 'B015N2LPTY', 'B015O1YQPO', 'B015Q1IQXA', 'B016F2UFGU', 'B016IAQ6DU', 'B016OCG02E', 'B016OG2KMO', 'B0178XL0FA', 'B0178YMUM6', 'B017IAG4M2', 'B017INPQU0', 'B017IOHWR4', 'B017K5T73I', 'B017NCLS3A', 'B017OVUY30', 'B017OZJTAA', 'B017P2UG04', 'B017SIN576', 'B017TZLX2M', 'B01820P8YW', 'B0188TDLX2', 'B0188U92J8', 'B018DPZW0G', 'B018K4DT96', 'B018VLIBSM', 'B0192SM5OO', 'B019JY2QJK', 'B019K0ISTA', 'B019MQ2GTK', 'B019RIN8ZO', 'B019ZC5G9I', 'B01A41ODNE', 'B01A5DTKD4', 'B01A6RNHSS', 'B01A6TKIVU', 'B01A6U4HXY', 'B01AJS597Q', 'B01AP7X95U', 'B01ARNBVG6', 'B01ARQLIGQ', 'B01AU5R3HC', 'B01AU8X4VS', 'B01AW8RQT2', 'B01AXIP918', 'B01AXV22H4', 'B01AXW7HDM', 'B01B2OPK48', 'B01B2TGWD6', 'B01B2VD5B6', 'B01B2WCUW0', 'B01B4CKWNM', 'B01B4CKWP0', 'B01B4HS7DO', 'B01B5HSYPO', 'B01B5HSYQS', 'B01B5Z1J08', 'B01B7DNY7Y', 'B01BBK0XTA', 'B01BBLE1PQ', 'B01BDB3XSA', 'B01BERO6FW', 'B01BEXVW3K', 'B01C002NDE', 'B01C3N1D66', 'B01C3OJB7I', 'B01C3VYCXY', 'B01C6X5CHY', 'B01C8FOOEC', 'B01C9WG1L8', 'B01C9XQ3W4', 'B01CFK1628', 'B01CFWWPDU', 'B01CG1KGEK', 'B01CHL9PQO', 'B01CHVC3TA', 'B01CHVC4GM', 'B01CJ44IN4', 'B01CJEOPH8', 'B01CJGOT4K', 'B01COQHVJ0', 'B01CQQ1LIA', 'B01CTU6BKQ', 'B01CU5Y8KU', 'B01CV7G33M', 'B01CY5LI2C', 'B01CY5ZJKY', 'B01CY7R2UM', 'B01CZQHZZY', 'B01CZQI256', 'B01CZUHK8W', 'B01D159XY4', 'B01D18UULQ', 'B01D1BN4KM', 'B01D1HBR6O', 'B01D2O4YJI', 'B01D30CFT2', 'B01D30S244', 'B01D4L0B00', 'B01D9OFFK8', 'B01D9SNXUI', 'B01DCYKKB4', 'B01DD8EEYI', 'B01DGL8GQY', 'B01DIVV4WU', 'B01DJZ5UIY', 'B01DK4BJD4', 'B01DKIA7OC', 'B01DKJGMUY', 'B01DKJX89W', 'B01DLW8OT2', 'B01DM0H7RI', 'B01DNIUKUA', 'B01DNLDRVQ', 'B01DOWFBP4', 'B01DTZ6K3S', 'B01DUA82N8', 'B01DVTUNCG', 'B01DZNYXZG', 'B01E10NJXO', 'B01E35J8PA', 'B01E36WR84', 'B01E3LUFZ6', 'B01E8QG0GO', 'B01EHGZXK4', 'B01EJ5L8ZM', 'B01EJ5VQO0', 'B01EJCWWQY', 'B01EONUTEU', 'B01ESU8VIA', 'B01EXWGYKK', 'B01EXXQSW8', 'B01EXY3KXC', 'B01EY0E7Y6', 'B01EY64JKM', 'B01F35BVSG', 'B01F4PM9GI', 'B01F56KRCY', 'B01F59EV6E', 'B01F59I7LE', 'B01F8B64K0', 'B01F8RK4J6', 'B01FFE5UXW', 'B01FFSI48G', 'B01FJ6DN4E', 'B01FVV6JGG', 'B01FXB78LO', 'B01G1BN8ZU', 'B01G1SIKKQ', 'B01G58ICC8', 'B01G8IW4XI', 'B01GCI85EG', 'B01GDLH1LU', 'B01GHFY1RO', 'B01GHQT3WG', 'B01GRSRNYE', 'B01GYMFQPG', 'B01GZEOAFA', 'B01H13K98Q', 'B01H345W26', 'B01H34TBPK', 'B01H4VRIMK', 'B01H6QJW7C', 'B01H8ROB7K', 'B01HB7II8K', 'B01HO41V7A', 'B01HRJMTRS', 'B01HSXIOPY', 'B01HZ6ENTA', 'B01I39YYHY', 'B01I3A71B4', 'B01I54MDK2', 'B01I9C54HE', 'B01ICVEZLI', 'B01JG2IF1S', 'B01JG8XHTM', 'B01JLJ8WLY', 'B01JLJTQVE', 'B01JO7GDPU', 'B01L6OVNHM', 'B01LW8ANHZ', 'B01LYGVXHT', 'B01M8KST0I', 'B01M9BBOA9', 'B01MA69E71', 'B01MRUOIJ4', 'B01MS8K91O', 'B01N5JDTC4', 'B01N9UCCTK', 'B01NADRYSU', 'B06WWPSJCH', 'B06XJH28GR', 'B06XNMD13L', 'B06XSTLC4K', 'B0719MYMLW', 'B072BBXF8Q', 'B073GGBQXC', 'B073RCR576', 'B077V8HFX9', 'B078PD49TY', 'B078Y3YDC9', 'B07BGWG6B7', 'B07BK2C5K5', 'B07DLWB7GQ', 'B07DXMXL52', 'B07DXQTGQN', 'B07DXVCBZS', 'B07FF34BHW', 'B07FVLFYCJ', 'B07FVT7R6C', 'B07GZ3JF6D', 'B07H4QDTSC', 'B07HD81CWL', 'B07HKF5P2F', 'B07HMN72C5', 'B07HMWCH7T', 'B07HMWCJ8M', 'B07JN1P4KH', 'B07KK1V5C3', 'B07KMZ9BRV', 'B07KWX7VQX', 'B07LCDXHH2', 'B07LCJMQHR', 'B07LFSZLLY', 'B07MPSLKY6', 'B07PM2PK96', 'B07PYDNVCZ', 'B07QLVY5K5', 'B07QLWM26N', 'B07QW7DJT4', 'B07QX6LJ67', 'B07QZKVL8D', 'B07T9HKGVV', 'B07TB6HHBZ', 'B07TBHPW1X', 'B07TBKVSZY', 'B07TCLF45S', 'B07VLS3X1D', 'B07VQ16SQ7', 'B07VQ19F1P', 'B07W9316KH', 'B07WD476J7', 'B07XJVNV1M', 'B07Y4YGBJH', 'B07Y9FVNZD', 'B07YKCHY63', 'B07Z1T6ZWK', 'B07ZGPT1FR', 'B07ZVLDFZD', 'B081N5SC92', 'B082HJKDCR', 'B0836C3GLG', 'B083HZT4G2', 'B084QGPSQB', 'B085NF79WK', 'B0882V8QYF', 'B088ZX1BTF', 'B08BLHFZDQ', 'B08CV8NGRH', 'B08FC53GGQ', 'B08FCC1H5M', 'B08GCM51ZZ', 'B08HLZFWL4', 'B08HQ6JBG3', 'B08J686J49', 'B08J6W26W7', 'B08J6YW86R', 'B08J71Y72Z', 'B08JV6MLYT', 'B08JV986R9', 'B08K928G78', 'B08L15VLGS', 'B08LBLPWRN', 'B08LMQFK5C', 'B08LVPQ1TX', 'B08LYH7T4K', 'B08M3L4ZKN', 'B08M3NWJ1N', 'B08MFJ6QMJ', 'B08N4QP1L8', 'B08NVVC8TH', 'B08PBK96SJ', 'B08PCMBX9T', 'B08PPGRB6T', 'B08PY454T5', 'B08R5XYMCC', 'B08R9JFHJD', 'B08RN9KB5R', 'B08RSFM74N', 'B08S7M33JZ', 'B08SVN5HWX', 'B08SW5QKDC', 'B08TLY5XT5', 'B08TR97XWB', 'B08VN1RVW3', 'B08VNLDWXV', 'B08VP239KQ', 'B08VWJ12M4', 'B08W21SLJ4', 'B08W2K5MRG', 'B08W4W8P3W', 'B08W54ZQXY', 'B08WWM11R7', 'B08X2PPD83', 'B08X6DFDHX', 'B08XH6FKV5', 'B08XM73R3R', 'B08XXCX4B1', 'B08XZJ5PYB', 'B08Y1NS3HM', 'B08Y5QVWPT', 'B08Y6S3L8F', 'B08Y8VTVM5', 'B0919SB8VB', 'B091B5PCMC', 'B091FGPY3H', 'B091FQKR5V', 'B091TTTDKX', 'B0925F1JJM', 'B0925TBSWC', 'B09267P8KR', 'B092MBQ9SB', 'B092Q8MZMM', 'B092VX5P3M', 'B093DT6BSX', 'B093DV8MBD', 'B093F7D17N', 'B093L7NF3W', 'B093LJ8HQV', 'B093VPGLX7', 'B093WHLYNZ', 'B0946FZSN3', 'B0946G1W36', 'B0948X3VT6', 'B094CTLPFF', 'B094FQQ4X2', 'B094MN7SLR', 'B094MNHS17', 'B094TYLCNX', 'B094V435PV', 'B0957LYNJG', 'B095C39MD6', 'B095JNFVSD', 'B095K9M9ML', 'B095NSYK2D', 'B095P176FN', 'B0963D4JH4', 'B0964QRR5Q', 'B096FKSBBG', 'B096SC9GNK', 'B096X44Q9Z', 'B096ZG2QS3', 'B0972P5TXC', 'B097349KSJ', 'B09734HBF9', 'B097BD11K3', 'B097BDGLXR', 'B097BFMRY3', 'B097BNWTLW', 'B097BRH9TQ', 'B097DFZ88Z', 'B097HFLTQK', 'B097JQVL7H', 'B097MC3JXX', 'B097MQJ6T9', 'B097R2ZH28', 'B097Y5H1PT', 'B09836NMJW', 'B09837MKJN', 'B09839TGT8', 'B0983BJJ6D', 'B0983J2HL3', 'B0983PKV6J', 'B098DJSXGD', 'B098F16GKR', 'B098F9PLYN', 'B098K6DB8Y', 'B098NXJJTH', 'B098X3FJNC', 'B09929LSCZ', 'B09936HJH6', 'B099DXYJ5D', 'B099HYSXPW', 'B099K29WQX', 'B099NPZ424', 'B09B3ZD9M8', 'B09B9VL8TN', 'B09BD29RYD', 'B09C7ZBHML', 'B09CH1MM49', 'B09CH32NTG', 'B09CPWKDG2', 'B09CPWXX91', 'B09CPYXCDF', 'B09D3GDZ9R', 'B09D7F1TRJ', 'B09D7VBP6G', 'B09DCB2XWD', 'B09DPJ8J9W', 'B09DPL2CP6', 'B09DSGSJ9G', 'B09DSTGVC6', 'B09DSTLLMC', 'B09F5D2QVC', 'B09F6DZFC5', 'B09FDYMZLQ', 'B09FPJ9755', 'B09FPNT6TK', 'B09FXBJNDM', 'B09FXXZR5F', 'B09FZBSKGW', 'B09FZC16F5', 'B09G6B21MW', 'B09G9TVRHH', 'B09GB3LHBX', 'B09GF9R9DZ', 'B09GKCCWXJ', 'B09GLMFFMH', 'B09GVVF5GZ', 'B09H2MKMKH', 'B09H41TTVY', 'B09H423P4F', 'B09H42L7BX', 'B09H4PYFQ4', 'B09H6TZC63', 'B09HCJH3D3', 'B09HWXS4V6', 'B09HZTRYK4', 'B09HZWTLLY', 'B09HZZ1M2C', 'B09J11CZFV', 'B09J1829VC', 'B09J2RVHSD', 'B09J8G2J64', 'B09J8MC7JZ', 'B09JBHTPKL', 'B09JF8HNVP', 'B09JFRL17B', 'B09JFZCHFY', 'B09JKB7VQ2', 'B09JNZTRJY', 'B09JS6J5MR', 'B09JSC91L7', 'B09JYGHTRK', 'B09K43GNGP', 'B09KLBP4B6', 'B09KLSZRS3', 'B09KNLZLJ7', 'B09KRKSXL5', 'B09KTLY89H', 'B09KXHK48P', 'B09L44BK7B', 'B09L4655YV', 'B09L4WWRZT', 'B09LCJ5JMN', 'B09LQPY76L', 'B09MF8TM34', 'B09MHF4HPL', 'B09MHH27DX', 'B09MHSJZHR', 'B09MHVG6WC', 'B09MJ1BVPW', 'B09MJ5HBZJ', 'B09MRMKMH9', 'B09MVTDF76', 'B09MW4KGCQ', 'B09MYHPCVS', 'B09N8PPPHK', 'B09N99XYZ8', 'B09ND1KNT7', 'B09NKNK2JN', 'B09NKVGQTS', 'B09NKYK1L3', 'B09NNBRY31', 'B09NNKHTDL', 'B09NRDG6J5', 'B09NVMLBXJ', 'B09P379NMK', 'B09PD4T96W', 'B09PDKRHRC', 'B09PH7BJG3', 'B09PQT6J8Y', 'B09PZRGPPY', 'B09Q17X1R3', 'B09Q8G22T5', 'B09QCQ7CRG', 'B09QLZNX56', 'B09QPZPCJ1', 'B09QSKZ9DQ', 'B09QSP25MH', 'B09QXB32Q9', 'B09QYP7BLH', 'B09RF4TSV8', 'B09RHX21F6', 'B09SFXX8X6', 'B09SFYVVMN', 'B09SFZ1PM6', 'B09SFZ25DN', 'B09SFZ895W', 'B09SFZ93SX', 'B09SFZCQY7', 'B09SFZG9QV', 'B09SFZGV1H', 'B09SFZJP8V', 'B09SFZL72B', 'B09SFZPZ9C', 'B09SFZRL4V', 'B09SFZSDZS', 'B09SFZT7R7', 'B09SFZTF85', 'B09SG14NVT', 'B09SHLZBJ1', 'B09SLKK6LW', 'B09T66D6BP', 'B09TB5T5XX', 'B09TDKDRHV', 'B09TKY5BMF', 'B09TP83BM1', 'B09TR3GJWJ', 'B09TSFPLSD', 'B09TT6D7Y9', 'B09TZKNDSD', 'B09V2G3ZX6', 'B09V2QK5VB', 'B09VC12NLG', 'B09VC2VPPL', 'B09VGCFTTN', 'B09VGHT7SH', 'B09VGK1LPT', 'B09VKF2H5B', 'B09VP7F6M6', 'B09VPRMW28', 'B09W43597R', 'B09W9HLSWH', 'B09WMPFCJW', 'B09WYQ1NGN', 'B09XDTVD5T', 'B09XHL245W', 'B09Y1CP2F7', 'B09Y1TDK5D', 'B09YD37C18', 'B09YD67SPK', 'B09YGHVPSL', 'B09YH6RH93', 'B09YL6K5Q7', 'B09YL88WTN', 'B09YLSZ2GZ', 'B09YYFM13S', 'B09Z29GHLD', 'B09Z2K8474', 'B09ZP9LBMH', 'B09ZPGGXW7', 'B09ZV1SSVZ', 'B09ZV6PMF5', 'B09ZY7WCC4', 'B0B1DG6G5J', 'B0B1LPKHGR', 'B0B1ZMJGWC', 'B0B2DPTY36', 'B0B2NS1LJ1', 'B0B2P96RBW', 'B0B2S2H2D4', 'B0B3DG99BQ', 'B0B3RVRQ4Z', 'B0B3XHDJCS', 'B0B42J7HJR', 'B0B46F92DN', 'B0B46G1CKT', 'B0B4NT8FG2', 'B0B4RNGBJ2', 'B0B4XFY9J2', 'B0B51MJLBG', 'B0B58QZ6VJ', 'B0B5TX2DKV', 'B0B68J9VRP', 'B0B6BTQ7VG', 'B0B6HXKZYS', 'B0B6P9R64W', 'B0B74W4GQF', 'B0B772F59X', 'B0B79ZFDSB', 'B0B7HCDYBZ', 'B0B7HL2VQR', 'B0B86XH8DT', 'B0B8C213SV', 'B0B8D4JLRN', 'B0B8GD54Z7', 'B0B8HH6DH1', 'B0B8NRYRZQ', 'B0B8NZJF6C', 'B0B8NZKCNX', 'B0B8YHZW9F', 'B0B8Z7XQY9', 'B0B8ZHHRX6', 'B0B99Z38M8', 'B0B9BNNL2N', 'B0B9GVZWK9', 'B0B9H2MWDG', 'B0B9H4RV5X', 'B0B9NHXQXL', 'B0B9NJHBMX', 'B0B9SDMXZ3', 'B0B9SPVYCH', 'B0B9X8442M', 'B0B9XKTBYN', 'B0BB2R35VS', 'B0BB6F8TJC', 'B0BB7QB678', 'B0BBRGQLL6', 'B0BC1897P1', 'B0BC1NPT24', 'B0BCJBQRNX', 'B0BCJSH1JJ', 'B0BCP3FT6G', 'B0BCVDVVBY', 'B0BCWP7XWX', 'B0BD3SLP2Q', 'B0BD4Y79FS', 'B0BD5LK9L2', 'B0BDFNB1X5', 'B0BDFTZVWN', 'B0BDJW3YJG', 'B0BF47GC7B', 'B0BF8YH91F', 'B0BF9LDG59', 'B0BF9Q82JF', 'B0BFB8FY6Q', 'B0BFCNZS3Q', 'B0BFD62S6J', 'B0BFDGJFJX', 'B0BFF4N6FG', 'B0BFF7SV3B', 'B0BFF9TJBF', 'B0BFHW13B7', 'B0BFJ3MC4B', 'B0BFPN61JD', 'B0BFQ38BS9', 'B0BFR8BKCX', 'B0BFR9RFKV', 'B0BFVFS9JH', 'B0BFW11SWP', 'B0BFW329KR', 'B0BFWCDTD9', 'B0BFX816D1', 'B0BFZTZQ2Y', 'B0BG2FGGVF', 'B0BG2LFVZ3', 'B0BG2LJKKN', 'B0BG2QQ6K7', 'B0BG38W8QJ', 'B0BG417GH3', 'B0BG48Y3YL', 'B0BG4C99J7', 'B0BG4N396J', 'B0BGGWXSKJ', 'B0BGJZDMPK', 'B0BGKB57DR', 'B0BGL139MW', 'B0BGLHBCVN', 'B0BGM62JBP', 'B0BGRW5647', 'B0BGS82F6Y', 'B0BGSKY3Q6', 'B0BGSLCJFC', 'B0BGSXPP9G', 'B0BGWW17VH', 'B0BGXBM7Z7', 'B0BGXSK4PK', 'B0BGXXWTX6', 'B0BHMZ81NL', 'B0BHP6Q3BT', 'B0BHQ98SFZ', 'B0BHQTK956', 'B0BHRG6PJW', 'B0BHSL6WQF', 'B0BHVKCX89', 'B0BHZ7Y7QB', 'B0BJ1SBFC1', 'B0BJ2TDNPZ', 'B0BJ78D2LT', 'B0BJDX3V3D', 'B0BJK23MFG', 'B0BJK3GFGB', 'B0BJKPQ8G6', 'B0BJPYR17Z', 'B0BJSYFN4F', 'B0BJTHVVFF', 'B0BJTY39TN', 'B0BJV82CVZ', 'B0BJZXLR78', 'B0BK11M67Q', 'B0BK1NG7YF', 'B0BK7X7DN1', 'B0BK92Y3W7', 'B0BK96V4JM', 'B0BK9CF25R', 'B0BKFCG2XQ', 'B0BKGCLZ1V', 'B0BKGG8YVM', 'B0BKJH16K1', 'B0BKKS2RHR', 'B0BKP33JG5', 'B0BKP9HMRD', 'B0BKT64XR5', 'B0BKZ46WL7', 'B0BKZ52FQ4', 'B0BKZJMQ5V', 'B0BKZK8WXW', 'B0BKZLPZ3N', 'B0BKZP64TR', 'B0BKZR8WMW', 'B0BKZS2C79', 'B0BKZW78DB', 'B0BL18F8VD', 'B0BL1CJ93G', 'B0BLCB9LTH', 'B0BLD68FYP', 'B0BLRWXY53', 'B0BLSH589B', 'B0BLSTQBTJ', 'B0BLVFQW88', 'B0BLYX43YZ', 'B0BLZ4JWV1', 'B0BM4GWD4D', 'B0BM4H3CNQ', 'B0BM589T6X', 'B0BM8Y2SK9', 'B0BM97WP3G', 'B0BM98S5R9', 'B0BMFMXQ9V', 'B0BMG3CM8J', 'B0BMG96399', 'B0BMKSC5PK', 'B0BML214LP', 'B0BMQ24GLQ', 'B0BMV284L6', 'B0BMZVPXNM', 'B0BN131ZLG', 'B0BN2SKFKK', 'B0BN2Z2BBV', 'B0BN53GBDB', 'B0BN5KZYJ7', 'B0BN67PFB4', 'B0BN77Y513', 'B0BN7BM6WS', 'B0BNB22CM4', 'B0BNH87B4Z', 'B0BNH8NQHQ', 'B0BNH9KNP8', 'B0BNJ1YRLF', 'B0BNKDHMPG', 'B0BNL5JNW8', 'B0BNL6Q6QX', 'B0BNMDTP3V', 'B0BNN5JJFF', 'B0BNPDYC71', 'B0BNQ84S4S', 'B0BNQG7S88', 'B0BNT54VBN', 'B0BNT5D6Z7', 'B0BNTV2TC5', 'B0BNTYSNF8', 'B0BNVSK84Z', 'B0BNVSZVP3', 'B0BNZWCXTW', 'B0BP1NF6YN', 'B0BP1PLKY1', 'B0BP1WKNF1', 'B0BP2BPS7R', 'B0BP6QRBT4', 'B0BP76DVRZ', 'B0BPBT42V9', 'B0BPBXR8TS', 'B0BPCLK6FW', 'B0BPD2NFL1', 'B0BPFN8W6Y', 'B0BPLCFHCC', 'B0BPM9BKJL', 'B0BPWZYWVC', 'B0BPXQ6ML1', 'B0BPY3BXMB', 'B0BQ287PJD', 'B0BQ2DCSCG', 'B0BQ2GQL98', 'B0BQ3BPXTZ', 'B0BQ3F3C8R', 'B0BQ6R5L32', 'B0BQBZNCZX', 'B0BQHRZHBK', 'B0BQJ4CQ9J', 'B0BQJ5NF8Y', 'B0BQMG511K', 'B0BQMH1VRD', 'B0BQMRTMRY', 'B0BQXDB36S', 'B0BQYLQQYG', 'B0BQYVYC35', 'B0BR3M9VDX', 'B0BR3ZZ2JW', 'B0BR6D42HC', 'B0BR6H6Z48', 'B0BR6LGV56', 'B0BR6X6LTX', 'B0BR7KJZVH', 'B0BR9YSXBB', 'B0BRB55TBJ', 'B0BRCQH48Q', 'B0BRKJZD8V', 'B0BRMYVLLJ', 'B0BRN5F6JS', 'B0BRQ39GX7', 'B0BRQ5129D', 'B0BRQFQ9W5', 'B0BRR6Q4NK', 'B0BRS415M1', 'B0BRSL8RHY', 'B0BRSMV3KB', 'B0BRXFBTYY', 'B0BRXN7BWZ', 'B0BRXX68ND', 'B0BRYYGWNY', 'B0BRZWNC8Q', 'B0BRZYHFG2', 'B0BRZZ8GZZ', 'B0BS197QLD', 'B0BS2ZLBL7', 'B0BS5FFZNX', 'B0BS6F3X8S', 'B0BS6LBL8W', 'B0BS9CL7FN', 'B0BSKVC5GY', 'B0BSMHQ311', 'B0BSMK9JNW', 'B0BSMR2YJP', 'B0BSMVPM27', 'B0BSMX4D52', 'B0BSMZB2KJ', 'B0BSN6C145', 'B0BSNKB4R6', 'B0BT92DVTJ', 'B0BT95MXHY', 'B0BTBCTV4C', 'B0BTBFKY7J', 'B0BTHJYTX1', 'B0BTHMM4BW', 'B0BTHS986Z', 'B0BTM3Z5SS', 'B0BTN72WB2', 'B0BTPDHRQS', 'B0BTPF4PVR', 'B0BTRPZ7VB', 'B0BTRR41W3', 'B0BTS78DXP', 'B0BTT7HC11', 'B0BTYLGZ18', 'B0BTYNFT48', 'B0BTYNKRWY', 'B0BTYVL41W', 'B0BTYWFTV1', 'B0BV28C26H', 'B0BV2PQ97R', 'B0BV378D5K', 'B0BV5PXL1Z', 'B0BV6FR9LG', 'B0BV6JMWZ9', 'B0BV6V62RN', 'B0BVB2KYFN', 'B0BVB6ZR6P', 'B0BVG13LRJ', 'B0BVQWYQ77', 'B0BVR9GX18', 'B0BVT7NXSY', 'B0BVTGB1QB', 'B0BVTT7V9P', 'B0BVV4Z6FP', 'B0BVVYMW8B', 'B0BVW27JJ5', 'B0BVZCVBB8', 'B0BVZGTN97', 'B0BWGZWSRX', 'B0BWH7YYCS', 'B0BWHG3ZH1', 'B0BWJ8TJKD', 'B0BWJCYK93', 'B0BWJD3978', 'B0BWJFBTXM', 'B0BWXVT5KT', 'B0BWXXFYGK', 'B0BX2KSRVT', 'B0BX33K86Z', 'B0BX37T6LJ', 'B0BX3XZZVZ', 'B0BX44JK38', 'B0BX8Z81WM', 'B0BXL1Q8RF', 'B0BXL97CMH', 'B0BXLFXS1L', 'B0BXP32Q6W', 'B0BXRSMFV1', 'B0BXSVBY3R', 'B0BXWYD13X', 'B0BXX9VB5Z', 'B0BY1MFWTQ', 'B0BY8L6XGR', 'B0BY8PGSKG', 'B0BYCWK3CN', 'B0BYHJ4NTR', 'B0BYHNJHXQ', 'B0BYHP1ZC3', 'B0BYHPTH1K', 'B0BYHRKGNJ', 'B0BYHRW94C', 'B0BYJ37DS1', 'B0BYJ5KX1S', 'B0BYJ9L2CV', 'B0BYMXZVCC', 'B0BYNL2VJ4', 'B0BYNQD2VB', 'B0BYP1P94C', 'B0BYRKY8NH', 'B0BYSJQDSK', 'B0BYSTKR75', 'B0BYYPBVRV', 'B0BYZCVB75', 'B0BYZJLF4V', 'B0BZ3CSKT1', 'B0BZ3CZ776', 'B0BZ3DZPH6', 'B0BZ3HPV8V', 'B0BZ3J3YLJ', 'B0BZ41PVPB', 'B0BZ4L96CT', 'B0BZ7CP95P', 'B0BZ8LTJDX', 'B0BZBFJ13H', 'B0BZCDCCF9', 'B0BZCDRY4V', 'B0BZCNZSQG', 'B0BZCPQ9M8', 'B0BZCZXNNK', 'B0BZD3JTGM', 'B0BZDD1D78', 'B0BZGXBSRD', 'B0BZP99R52', 'B0BZPCPYPL', 'B0BZPCTKJS', 'B0BZPFXFRB', 'B0BZPGQR5C', 'B0BZPM4HYP', 'B0BZR9YVHG', 'B0BZRBD36H', 'B0BZSLZRGR', 'B0BZYJF1SN', 'B0BZYSSJPD', 'B0BZZ58KKB', 'B0C12NL2Y7', 'B0C136RTS6', 'B0C1BPFD6Q', 'B0C1CBL4H7', 'B0C1GBGKRH', 'B0C1GWZ41M', 'B0C1GYFKWY', 'B0C1GZX84T', 'B0C1H2S765', 'B0C1SCT2TK', 'B0C1SDNG6G', 'B0C1SFL1ZS', 'B0C1SGQP7Q', 'B0C1SHWD69', 'B0C1SN9GKC', 'B0C1SW1MZS', 'B0C1Z54VXT', 'B0C1Z7C6N1', 'B0C2314ZRF', 'B0C233425V', 'B0C23C7LT7', 'B0C2437SGL', 'B0C245FKZV', 'B0C2BJ5YZJ', 'B0C2BM5KZX', 'B0C2BVSY5R', 'B0C2C9PX7S', 'B0C2GP5K7J', 'B0C2H2KT3P', 'B0C2HHY9TD', 'B0C2HP13GD', 'B0C2HWBQNG', 'B0C2J3F879', 'B0C2PZX8BF', 'B0C2Q4DG1H', 'B0C2Q7KRV6', 'B0C2QB7FLD', 'B0C2T4474H', 'B0C2TH1HR2', 'B0C2TJ4CFQ', 'B0C2TLXT7N', 'B0C2TZ1BYL', 'B0C2VGMFG7', 'B0C2XW7JSC', 'B0C2XY1Z23', 'B0C2XYMWZQ', 'B0C2Y4H785', 'B0C2YTS1ML', 'B0C2Z5MXK4', 'B0C36TTHG7', 'B0C379ZKC9', 'B0C39TQC2M', 'B0C3B46WJV', 'B0C3B47FW3', 'B0C3B4W1VZ', 'B0C3B6TGKJ', 'B0C3HS7TYF', 'B0C3HT5G2V', 'B0C3M9DCF5', 'B0C3V17V5H', 'B0C3VNCT73', 'B0C3VPFXBX', 'B0C48K2LKW', 'B0C48K5PZZ', 'B0C48L93B7', 'B0C48MDFYR', 'B0C495F8L8', 'B0C4B2RYYF', 'B0C4B6M13P', 'B0C4D3FZ6Z', 'B0C4DBMBSS', 'B0C4G92K2X', 'B0C4GRKBYP', 'B0C4N34RWZ', 'B0C4N96TJC', 'B0C4TS41TF', 'B0C52W8ZXM', 'B0C58XNQJ3', 'B0C5CBQ89F', 'B0C5D1N7M8', 'B0C5DL4VTS', 'B0C5H5KGNT', 'B0C5ML86BB', 'B0C5RJ54P5', 'B0C5X3QSPD', 'B0C5X54PVB', 'B0C613SBJ7', 'B0C61CC9DX', 'B0C61WZRVC', 'B0C6247S18', 'B0C64XMNKB', 'B0C653SRN2', 'B0C65DB5FF', 'B0C65MPY7C', 'B0C65XJXTV', 'B0C6925F9L', 'B0C6DWSQGH', 'B0C6JV3Y73', 'B0C6K7G2KT', 'B0C6KPMF6F', 'B0C6ML2HSN', 'B0C6PQZQDD', 'B0C6PSBDZ7', 'B0C6QPNMXQ', 'B0C6QS1D7T', 'B0C6SGGXVF', 'B0C6SGJ8JJ', 'B0C6T54FTR', 'B0C6XD27SR', 'B0C6XPCRFP', 'B0C74LPBY4', 'B0C77T3QLK', 'B0C7C16WZD', 'B0C7C2FCBW', 'B0C7C3GWBD', 'B0C7C6RZCL', 'B0C7G46KX9', 'B0C7GM3XYM', 'B0C7GTYBSH', 'B0C7KC74Z2', 'B0C7KNH2TH', 'B0C7L6HFJJ', 'B0C7QKY5GF', 'B0C7R6YWL6', 'B0C7TRKX5W', 'B0C7VDRTHY', 'B0C7W8BVQH', 'B0C7W8TCZX', 'B0C7WB6Y88', 'B0C7ZR6BYZ', 'B0C85W89BW', 'B0C862NWHZ', 'B0C8647R5L', 'B0C865THHC', 'B0C893L2P7', 'B0C89CYSYY', 'B0C89HS178', 'B0C89W3DT8', 'B0C8HFYHS1', 'B0C8HYHYC6', 'B0C8J21RYL', 'B0C8LYJSXT', 'B0C8MLJS8J', 'B0C8SG85X5', 'B0C8TJG4QX', 'B0C98N58PC', 'B0C9968YSD', 'B0C9CJG4RG', 'B0C9CN5QMJ', 'B0C9D1KR6J', 'B0C9DF22NZ', 'B0C9DF4Z8W', 'B0C9DSN8GF', 'B0C9LNHN9N', 'B0C9LZKF2W', 'B0C9M3558H', 'B0C9M86CKV', 'B0C9MHBW2J', 'B0C9MPP16D', 'B0C9PSYFHM', 'B0C9Q84PN9', 'B0C9TH1J7Q', 'B0C9TN1ZBH', 'B0C9TNFXXT', 'B0C9TTSKFS', 'B0C9Z7FBX6', 'B0C9Z9RH1F', 'B0CB13RBT2', 'B0CB17TQ3P', 'B0CB1DVX1Z', 'B0CB27ML3P', 'B0CB365X7N', 'B0CB3GJL8L', 'B0CB7KVZ6Y', 'B0CB7LMVGW', 'B0CB8JXLM7', 'B0CB8MBQQD', 'B0CB9V2JZS', 'B0CB9V83NL', 'B0CB9VFV68', 'B0CBB1XF2J', 'B0CBBD5D1V', 'B0CBBG8KYY', 'B0CBBGLBKL', 'B0CBBJ3P5N', 'B0CBBN2JH5', 'B0CBCC4RK3', 'B0CBJN4Z7D', 'B0CBJVSSFB', 'B0CBK76ZRQ', 'B0CBK8T7BZ', 'B0CBKGV6N2', 'B0CBLMB971', 'B0CBLQ2WFQ', 'B0CBM41PCJ', 'B0CBM7QDFJ', 'B0CBMPMJKR', 'B0CBNZCW8N', 'B0CBP2B1PX', 'B0CBP4S718', 'B0CBP7CTSB', 'B0CBPS1SGY', 'B0CBR4Y33P', 'B0CBRV7X4K', 'B0CBTM3LSP', 'B0CC223Q7X', 'B0CC28QRZY', 'B0CC28Y45C', 'B0CC295J6C', 'B0CC29SYHY', 'B0CC2BF4F8', 'B0CC2D7QX7', 'B0CC2FJ9MF', 'B0CC2K9KCR', 'B0CC2NK2VM', 'B0CC4PV7Y4', 'B0CC53YB5S', 'B0CC5J816J', 'B0CC5KWQDM', 'B0CC5P4BJ4', 'B0CC99CP8T', 'B0CC9HPGJM', 'B0CCDM4SRR', 'B0CCDMP2JW', 'B0CCDMXJF3', 'B0CCGVXBR9', 'B0CCHWRQW8', 'B0CCJB81K9', 'B0CCNXRJ5D', 'B0CCP566RS', 'B0CCQGSRZK', 'B0CCR9Z2ZF', 'B0CCRG2SLW', 'B0CCRP5MLT', 'B0CCRQM7PZ', 'B0CCRRVPVS', 'B0CCRRW5D8', 'B0CCRVL47L', 'B0CCRYYG56', 'B0CCS1QDHS', 'B0CCT8Q2LM', 'B0CCT9XJ2V', 'B0CCTG3LZD', 'B0CCTX3DSN', 'B0CCTXQKMJ', 'B0CCVHWC3B', 'B0CCXP9LP3', 'B0CCXVLCCN', 'B0CCY43G19', 'B0CCY8T62V', 'B0CCYLLVKF', 'B0CCZX4TK7', 'B0CD1H88LX', 'B0CD1VFNM3', 'B0CD1XCP8J', 'B0CD2F2VVM', 'B0CD6YJYSH', 'B0CD72N3BG', 'B0CD7QJ4TR', 'B0CD7T5VZB', 'B0CDBDRRQG', 'B0CDC315Z6', 'B0CDFQZ243', 'B0CDG58JRV', 'B0CDGRYV3T', 'B0CDGS47HJ', 'B0CDGVT976', 'B0CDGZ7KWY', 'B0CDGZCJRL', 'B0CDGZCRZJ', 'B0CDH27GF2', 'B0CDH44F6N', 'B0CDJZ6V1Y', 'B0CDL8HQ7N', 'B0CDLBXFCC', 'B0CDLHTKYZ', 'B0CDNCS97T', 'B0CDNL4QBB', 'B0CDP33XPJ', 'B0CDPQ1YX1', 'B0CDPT51ZS', 'B0CDQ1NNG9', 'B0CDQ2YMKF', 'B0CDVXPSFD', 'B0CDWS4F1H', 'B0CDWW7RT4', 'B0CDX9KCHY', 'B0CDZM5QBR', 'B0CF1PV47F', 'B0CF2F6ZZM', 'B0CF2HXK88', 'B0CF2JZGJZ', 'B0CF8964F6', 'B0CF8M4XT6', 'B0CF8PC4HX', 'B0CF8QK6R5', 'B0CF8RDCYX', 'B0CFDQRD63', 'B0CFFKFDQ7', 'B0CFKGS3GJ', 'B0CFKRW2NL', 'B0CFL6F9Q1', 'B0CFLL7DD2', 'B0CFPGQ8M4', 'B0CFPSXSGM', 'B0CFTKBF8D', 'B0CFTMZHZ8', 'B0CFTZ2GX7', 'B0CFV4L9RS', 'B0CFXGTL9L', 'B0CFXJB5Y2', 'B0CFY35YYC', 'B0CFZ9KB96', 'B0CFZHFSG7', 'B0CFZTW4ND', 'B0CFZTY5RC', 'B0CFZYJHVC', 'B0CFZYQXXB', 'B0CFZZ7DRP', 'B0CG189P4Y', 'B0CG1BKCSD', 'B0CG1C2NQN', 'B0CG1CXVPY', 'B0CG1D28FJ', 'B0CG1D7N4N', 'B0CG1DBZDW', 'B0CG1HNGK6', 'B0CG1S845G', 'B0CG5C9GRS', 'B0CG5CTVCL', 'B0CG5KF9X5', 'B0CG69GGP9', 'B0CG6DKC9X', 'B0CG6GYJV3', 'B0CG82L4YK', 'B0CG8BXXNN', 'B0CG9543GL', 'B0CG98R5SG', 'B0CG9DLCQS', 'B0CGDJ9HLP', 'B0CGDVWY9S', 'B0CGDW1VWB', 'B0CGHD8MQ2', 'B0CGJ4K8VK', 'B0CGKYJCXH', 'B0CGQPB47G', 'B0CGQZGXG1', 'B0CGR8FB7X', 'B0CGR9DDLL', 'B0CGRCLG8Y', 'B0CGRL8DTL', 'B0CGRMN33Z', 'B0CGRQRSRF', 'B0CGT6V1MK', 'B0CGTR1BL4', 'B0CGTTQDCH', 'B0CGWSW4PN', 'B0CGWTGVTQ', 'B0CGWV6V6F', 'B0CGWVNX34', 'B0CGXHHTQG', 'B0CGXJBHWG', 'B0CGXKH5ZZ', 'B0CGZ9HW65', 'B0CGZWZFWH', 'B0CGZZB8FB', 'B0CH16TGVH', 'B0CH18SX57', 'B0CH34B19T', 'B0CH385CD2', 'B0CH7RVP3B', 'B0CH9MZ2X1', 'B0CH9WB8H3', 'B0CH9YFTKJ', 'B0CHB8FMJT', 'B0CHF6BHXL', 'B0CHF79J48', 'B0CHF7M8QP', 'B0CHFF97D9', 'B0CHJBBXSX', 'B0CHJF3SZT', 'B0CHLCXQN7', 'B0CHMQG5VF', 'B0CHRW954J', 'B0CHS7YT8L', 'B0CHS9TKCX', 'B0CHVF5DV3', 'B0CHVYH9H8', 'B0CHW7G73W', 'B0CHW9DBV4', 'B0CHYJGM69', 'B0CHYJSFXC', 'B0CHYPV2Z4', 'B0CJ2B311N', 'B0CJ2B9691', 'B0CJ2LMZV5', 'B0CJ4MWHD8', 'B0CJ55M9Z1', 'B0CJ59RCHJ', 'B0CJ95RPVX', 'B0CJ9KG32L', 'B0CJ9VLP8Q', 'B0CJDH1CYD', 'B0CJDHVMPD', 'B0CJDQCF3J', 'B0CJJKCBKT', 'B0CJMBH4QX', 'B0CJMFMHCH', 'B0CJQX4DBV', 'B0CJR64PRF', 'B0CJR77RXL', 'B0CJRB5HSD', 'B0CJRBVKNZ', 'B0CJRCZM11', 'B0CJRJ7N38', 'B0CJTQ7RPS', 'B0CJTZG331', 'B0CJTZNTXQ', 'B0CJV2ZRMV', 'B0CJVLTV9D', 'B0CJVM8WVJ', 'B0CJVMPX31', 'B0CJVN312X', 'B0CJVN3ZM3', 'B0CJVNP66K', 'B0CJVPZRDS', 'B0CJVQ8DPW', 'B0CJX4XYHH', 'B0CJX5Y84F', 'B0CJY9N9BD', 'B0CK13N8FP', 'B0CK18D4M2', 'B0CK1LNWXK', 'B0CK25L2FT', 'B0CK26BZY5', 'B0CK2758DG', 'B0CK2K81G3', 'B0CKN3XH5R', 'B0CKN96YF6', 'B0CKNDRQCT', 'B0CKNLLHLW', 'B0CKNLSFLM', 'B0CKPGBJWM', 'B0CKPGPYRY', 'B0CKPR88HR', 'B0CKRXVVQZ', 'B0CKSVBZQG', 'B0CKT68GPT', 'B0CKT6GX13', 'B0CKT8G8WZ', 'B0CKVDK9J9', 'B0CKVF9N7S', 'B0CKVWBY3C', 'B0CKX3PT81', 'B0CKX4B27L', 'B0CKX4HLKR', 'B0CKXH6FHZ', 'B0CKXMB37B', 'B0CKXMMQV4', 'B0CKXXG5NY', 'B0CL46H7R5', 'B0CL4FYY2P', 'B0CL5YRTJW', 'B0CL5YXCS5', 'B0CL6JQBDV', 'B0CL6TXT93', 'B0CL73FQ44', 'B0CL79K5CQ', 'B0CL8YC1MK', 'B0CL931GZR', 'B0CL9YKNTQ', 'B0CLBJQKYG', 'B0CLCFZ979', 'B0CLDDV9XF', 'B0CLDXJ1PC', 'B0CLGG9XRK', 'B0CLGTYPGT', 'B0CLGYWV21', 'B0CLH7W6ZG', 'B0CLKHZZMQ', 'B0CLL3DBP5', 'B0CLL8Q72W', 'B0CLLJHPMP', 'B0CLLR7SS6', 'B0CLLSQ5S7', 'B0CLLZ345Z', 'B0CLNL81ZC', 'B0CLPC6GS3', 'B0CLS1WP62', 'B0CLTYXMW4', 'B0CLV1XV4P', 'B0CLVC8KJY', 'B0CLVDM6DN', 'B0CLVFHBP8', 'B0CLVFQ2S5', 'B0CLVFRZHZ', 'B0CLVHHVZL', 'B0CLXX2PTY', 'B0CLY51KDQ', 'B0CLYCWL34', 'B0CLYH1V83', 'B0CM2TZMX7', 'B0CM3L6X76', 'B0CM6MZHNY', 'B0CM983SPS', 'B0CM99HBYJ', 'B0CM99K3JJ', 'B0CM9HTN3D', 'B0CM9JSKPL', 'B0CM9L9N2J', 'B0CMCP9DJC', 'B0CMCVB7HY', 'B0CMCXWYSG', 'B0CMQBGQ92', 'B0CMQFHWF3', 'B0CMQG7WJ9', 'B0CMQGCRW6', 'B0CMQGWWH2', 'B0CMQL3MTR', 'B0CMQMQVR5', 'B0CMQQR1MW', 'B0CMT1NS2F', 'B0CMWMCM62', 'B0CMX62FPT', 'B0CMX962Y1', 'B0CMZN9MZ9', 'B0CN15G64K', 'B0CN6MWVP6', 'B0CN6QFVKF', 'B0CN6VB3D5', 'B0CN6ZSJ9F', 'B0CN8J92HS', 'B0CN8T7J1M', 'B0CN8ZZ38Z', 'B0CN91GR59', 'B0CN921MPM', 'B0CN922CDW', 'B0CN924FY9', 'B0CN92C5ZK', 'B0CN92KWP3', 'B0CN93GV25', 'B0CN93MBN4', 'B0CN93MK1F', 'B0CN94318X', 'B0CN98Z38B', 'B0CN9DXLBB', 'B0CN9FHW76', 'B0CN9FJ8MK', 'B0CN9G5TJD', 'B0CN9GB2PK', 'B0CN9GYCL9', 'B0CN9H63PV', 'B0CN9HTBCV', 'B0CNCVYFH9', 'B0CNCZNCHR', 'B0CND6RCHM', 'B0CNG5KLP1', 'B0CNG6C1V7', 'B0CNGMWQDG', 'B0CNJB2LZP', 'B0CNJZW6ZB', 'B0CNK15YKV', 'B0CNK17LRK', 'B0CNK1VGRT', 'B0CNK1VXYY', 'B0CNP5SYJB', 'B0CNPJFRWC', 'B0CNPRBST6', 'B0CNPVNSX8', 'B0CNW2Q7TP', 'B0CNW6QB9F', 'B0CNX6VJ8Q', 'B0CNY1P8L2', 'B0CP1SMHVY', 'B0CP1SZC58', 'B0CP242Z5Y', 'B0CP292DJB', 'B0CP2B4C7F', 'B0CP2C1Q49', 'B0CP2CBNRV', 'B0CP37GJZ1', 'B0CP3YSWF3', 'B0CP5CC6VC', 'B0CP5V2GV3', 'B0CP5VJ69V', 'B0CP62YMFR', 'B0CP7NTDW3', 'B0CP7QLRB1', 'B0CP7QSNG2', 'B0CP8WMZT2', 'B0CP8XL2ZW', 'B0CP9267RC', 'B0CP97J989', 'B0CPFGLCWZ', 'B0CPFH6FQF', 'B0CPH65WLF', 'B0CPHL7NNP', 'B0CPHX5LJ2', 'B0CPHZN26K', 'B0CPJ1GTDL', 'B0CPLD5325', 'B0CPLMJV93', 'B0CPM1YNPS', 'B0CPP1SS36', 'B0CPPJT4JW', 'B0CPPMQH61', 'B0CPPT6XFX', 'B0CPXXMVMJ', 'B0CPY9NXFP', 'B0CQ43QFDJ', 'B0CQ46GK42', 'B0CQ48CC85', 'B0CQ4X27NB', 'B0CQ7MM3CX', 'B0CQ7MR8K9', 'B0CQ85LHSQ', 'B0CQBPKZLC', 'B0CQBYWH79', 'B0CQCXMFK7', 'B0CQD4QHWW', 'B0CQJKSCFL', 'B0CQJLYKWP', 'B0CQJR3NCQ', 'B0CQK4SZ1S', 'B0CQK5S5LD', 'B0CQM7N6KY', 'B0CQNXC6JY', 'B0CQNYG8NC', 'B0CQNZCTH4', 'B0CQQKHLSM', 'B0CQQSPLGR', 'B0CQRK73WM', 'B0CQS3ZVZC', 'B0CQY2S12X', 'B0CQYRJVBP', 'B0CR1CMJGB', 'B0CR1G18MB', 'B0CR3L9HHW', 'B0CR6JHHWG', 'B0CR9P2XC2', 'B0CR9XZZKK', 'B0CRD788NP', 'B0CRDRRM46', 'B0CRDY4DS2', 'B0CRF4R67B', 'B0CRHBTQHB', 'B0CRHD737B', 'B0CRHLY5V5', 'B0CRKJKL4J', 'B0CRL1FCZZ', 'B0CRL5L7NJ', 'B0CRRGVPTG', 'B0CRRMVGV2', 'B0CRTXCB18', 'B0CRV3QWDD', 'B0CRV7S7WN', 'B0CRVCF6WF', 'B0CRVMY1NQ', 'B0CRYRBG3G', 'B0CRYT4K1Q', 'B0CRYXYXNY', 'B0CRYZ6R7N', 'B0CRZ1HXDZ', 'B0CRZ1JTWP', 'B0CRZ1KN94', 'B0CRZ4G9RJ', 'B0CSCVSCB2', 'B0CSD7YZ71', 'B0CSFR7K5Z', 'B0CSFXSZBG', 'B0CSK1ZJHR', 'B0CSN6HMWB', 'B0CSSGCLPL', 'B0CSSPJGTT', 'B0CSYY4411', 'B0CT2DX7PD', 'B0CT39JBYM', 'B0CT39M1BL', 'B0CT3J8JVX', 'B0CT3LYBX7', 'B0CT4Q7HPX', 'B0CT5GXT3C', 'B0CT5HCR91', 'B0CT5L19FZ', 'B0CT7LDKCG', 'B0CTCFRM44', 'B0CTH2VTFS', 'B0CTH5WCHB', 'B0CTK5QJ6X', 'B0CTKGMB1K', 'B0CTLRDMM8', 'B0CTM7QQKJ', 'B0CTM9Q7C4', 'B0CTQ8MC7Y', 'B0CV3P97TN', 'B0CV4TVZGP', 'B0CV516HD6', 'B0CV55K2X5', 'B0CV57DPFW', 'B0CV5CZKC2', 'B0CV7LZ5T2', 'B0CVVV39FP', 'B0CVVVJTQB', 'B0CVVXCP98', 'B0CVVY7NPW', 'B0CVXL5DMX', 'B0CVZDV15S', 'B0CVZJH8Y5', 'B0CVZM9XH5', 'B0CW2T6H9X', 'B0CW2X3DNV', 'B0CW2ZPFWX', 'B0CW328G3R', 'B0CW33BR5W', 'B0CW34YDVJ', 'B0CW37D6S3', 'B0CWGF1HVB', 'B0CWKSJJN9', 'B0CWP9XXLR', 'B0CWQCN9YP', 'B0CWRC7S7R', 'B0CWTC5Q2T', 'B0CWTVCKLG', 'B0CWTVCQ7G', 'B0CWTZNZT9', 'B0CWV4ZTW9', 'B0CWV8PR9V', 'B0CX18GXJ7', 'B0CX5CKFR7', 'B0CX8MYHW5', 'B0CXDG25S1', 'B0CXDYWBNH', 'B0CXHTH7B4', 'B0CXPYQBT3', 'B0CXWXNYDR', 'B0CY1N9MVY', 'B0CY2B22BJ', 'B0CY2MSPJX', 'B0CY4B5M87', 'B0CY5FDKBQ', 'B0CY5G1P1R', 'B0CY5KPJ2W', 'B0CY5N886K', 'B0CYBWJZ54', 'B0CYBXS3NN', 'B0CYC7KXFC', 'B0CYQ6G3MQ', 'B0CYZTR77P', 'B0CYZVKCV2', 'B0CZ3VV2SY', 'B0CZ44ZYMJ', 'B0CZ6Z66XF', 'B0CZ713YLG', 'B0CZ71DBW8', 'B0CZ742MMG', 'B0CZ74SYL7', 'B0CZ76VGRS', 'B0CZ8TN416', 'B0CZDJBQNG', 'B0CZDWH4LT', 'B0CZKYH9R8', 'B0CZLMFZ61', 'B0CZP1JZQL', 'B0CZQ32QK1', 'B0CZR9P3QL', 'B0CZRCK3CB', 'B0CZRGRQJ9', 'B0CZRHPDRS', 'B0CZRPRYDM', 'B0CZRW6PXP', 'B0D13N2CVB', 'B0D1B8CRDD', 'B0D1KLFCJR', 'B0D1V272VD', 'B0D1XMTTT9', 'B0D2293BL6', 'B0D231323R', 'B0D25TTZHS', 'B0D25XPZX9', 'B0D2CV4J2Z', 'B0D2GTYSVN', 'B0D2GVRHRX', 'B0D2GZ2V1Z', 'B0D2H7BN5S', 'B0D2HRMBMM', 'B0D2LC727C', 'B0D2LC8L3Q', 'B0D2PBGSM4', 'B0D2RB7QML', 'B0D2RDP26K', 'B0D2RH3Q9H', 'B0D2RHRCB2', 'B0D2RLX262', 'B0D2VJLRXP', 'B0D2VK9ZH9', 'B0D2VKNQB3', 'B0D2VKQZ6K', 'B0D2VRR3M8', 'B0D2VYYHK6', 'B0D2W86CKT', 'B0D2Y2HRPR', 'B0D2ZW39H2', 'B0D314B1FT', 'B0D31DC4P8', 'B0D31HQHSR', 'B0D31HRCBM', 'B0D31M2SZZ', 'B0D31PH1QQ', 'B0D3KHZDVF', 'B0D3LFWH6F', 'B0D3PF5LLN', 'B0D3Q1T3YM', 'B0D3TCYRJV', 'B0D3TGXRVD', 'B0D3WTGF37', 'B0D3XB3VS8', 'B0D3XWRDDQ', 'B0D41VH8PP', 'B0D458NF7W', 'B0D45JYTK4', 'B0D45VBXTS', 'B0D48JWFPH', 'B0D498SZGB', 'B0D499ZPXF', 'B0D49GXBB9', 'B0D49P86ZW', 'B0D4DS5RZ5', 'B0D4DY727G', 'B0D4KTWC9V', 'B0D4TBP9TP', 'B0D4TQBFQV', 'B0D4TTGNPF', 'B0D4VDFBYR', 'B0D4Y4S6TM', 'B0D4YTZQ91', 'B0D4Z94K7Z', 'B0D4ZBZR9D', 'B0D533MMX1', 'B0D537NZVQ', 'B0D53VH5FY', 'B0D5465647', 'B0D59BLWLX', 'B0D59JQ861', 'B0D59K6T9L', 'B0D59ZG8P3', 'B0D5BFZ788', 'B0D5CS88R7', 'B0D5H3B75K', 'B0D5HWC1BZ', 'B0D5M9QCRY', 'B0D5MB6SCK', 'B0D5QHD16R', 'B0D5R671D6', 'B0D5YDSH58', 'B0D62LCNYL', 'B0D62RWJ22', 'B0D66L5NTB', 'B0D6BBLW1S', 'B0D6BJ34DK', 'B0D6G33VW3', 'B0D6GGFZT8', 'B0D6R8Y54J', 'B0D6WBQNVB', 'B0D73HLC47', 'B0D7CJ8TDQ', 'B0D7CP77RF', 'B0D7CPVM53', 'B0D7CQ3CTJ', 'B0D7LXH648', 'B0D7LXJRZL', 'B0D7M12GKT', 'B0D7MBYDKQ', 'B0D7PBQ72Q', 'B0D7PY5D2Q', 'B0D7PZ873D', 'B0D7Q2F4YV', 'B0D7VYJJ86', 'B0D7W2G5DM', 'B0D7Z3FGPX', 'B0D8119DN8', 'B0D81414R1', 'B0D86XLG9G', 'B0D873P5C4', 'B0D876ZTKG', 'B0D878V7TD', 'B0D8BHSL56', 'B0D8J95WLT', 'B0D8JCJ9K1', 'B0D8KB94YS', 'B0D8KH7Z75', 'B0D8KHS3W8', 'B0D8KHTN7P', 'B0D8KJMDP1', 'B0D8KKT151', 'B0D8KPD9GK', 'B0D8KQ7VN9', 'B0D8KR15S9', 'B0D8KRH759', 'B0D8KRPC7G', 'B0D8KRT595', 'B0D8KRWNNY', 'B0D8KVY4VF', 'B0D8KWXG97', 'B0D8KX2HMD', 'B0D8KXMV6V', 'B0D8KXPY6C', 'B0D8KYGNTY', 'B0D8PLCDSP', 'B0D8PSSBN4', 'B0D8PZ71J2', 'B0D8Q3744X', 'B0D8QLH4WH', 'B0D8RXQ3XN', 'B0D8S61QT2', 'B0D8SFX13R', 'B0D8TB673D', 'B0D8TGHV7Y', 'B0D8TGJ3HK', 'B0D8TGLD3Z', 'B0D8VCF922', 'B0D8VZL8JF', 'B0D8W35M7G', 'B0D8W4PVG2', 'B0D8W4RFJ5', 'B0D8W5RRK9', 'B0D8W664CQ', 'B0D93LHDGZ', 'B0D94294L8', 'B0D945N59R', 'B0D95JV94S', 'B0D95QD6C5', 'B0D95Z7QPL', 'B0D9814D5S', 'B0D98BQZRW', 'B0D9JYVYT8', 'B0D9JZQJXD', 'B0D9K1QR49', 'B0D9K2P8ZP', 'B0D9K6FCPP', 'B0D9L94GS3', 'B0D9M54ZZ8', 'B0D9MBBN8Z', 'B0D9N8VSYJ', 'B0D9PRXZKR', 'B0D9PSG7Z2', 'B0D9Q2CMC4', 'B0D9VGYL2Y', 'B0D9VSM8XT', 'B0D9VXPMN8', 'B0D9WYNZFR', 'B0D9XMJQ8M', 'B0D9YD7HZN', 'B0DB173G5D', 'B0DB59H8Q5', 'B0DB5JCFX2', 'B0DB8G15BB', 'B0DBL7QJD9', 'B0DBLFF54P', 'B0DBLK57JP', 'B0DBR18FYM', 'B0DBRB2M62', 'B0DBSGG7NC', 'B0DBSGLZLV', 'B0DBSSFSSD', 'B0DBVQQL7Q', 'B0DBZLYL4J', 'B0DC5ZWJZR', 'B0DC9CT2NH', 'B0DC9XZ41N', 'B0DCBC7LTG', 'B0DCBVTF9B', 'B0DCBZB5KV', 'B0DCBZBPXV', 'B0DCBZWXQ4', 'B0DCBZXH58', 'B0DCBZXTDT', 'B0DCC17JDB', 'B0DCC1LFQ2', 'B0DCDL8GJ7', 'B0DCDSKPB6', 'B0DCG3X3ZC', 'B0DCG5H5VN', 'B0DCHVSXFK', 'B0DCJLL8LG', 'B0DCJLNTZ9', 'B0DD31R1N3', 'B0DD38WHCN', 'B0DD3HTY81', 'B0DD6CYCDZ', 'B0DD6P897M', 'B0DD784L8L', 'B0DD7DPJ23', 'B0DD7K15VX', 'B0DDCGFLZB', 'B0DDCKNHTK', 'B0DDK6Y94Q', 'B0DDK6ZV7W', 'B0DDKHNT28', 'B0DDNQTR7T', 'B0DDQ61GNS', 'B0DDQ7G9K8', 'B0DDSJ69MJ', 'B0DDSWBLVW', 'B0DDT1P524', 'B0DDT1VHRR', 'B0DDT2GQ8H', 'B0DDTDRQ1G', 'B0DDTLNR28', 'B0DDXKKZG3', 'B0DDXN78L3', 'B0DDXVQS19', 'B0DF2GGRLW', 'B0DF2J8KSY', 'B0DF2JJXXC', 'B0DF7K2ZWV', 'B0DF7TQ78Z', 'B0DFBPBHG2', 'B0DFCBR9R9', 'B0DFCL5S6C', 'B0DFFD9DNF', 'B0DFGXF224', 'B0DFH55668', 'B0DFLHNN99', 'B0DFLRQGCW', 'B0DFLSFWPV', 'B0DFM5D6S8', 'B0DFM977N1', 'B0DFPZL4LH', 'B0DFWDGF1Z', 'B0DFWQPT83', 'B0DFY73JY8', 'B0DG2YZ4K4', 'B0DG58JTJY', 'B0DG826WG8', 'B0DG87B577', 'B0DG8JWDPX', 'B0DG8PZ6MB', 'B0DG8RZH3W', 'B0DG8Z51XH', 'B0DGGBTDQT', 'B0DGGQH1PB', 'B0DGKSJ28C', 'B0DGNYZBCP', 'B0DGQF49C8', 'B0DGQFH6DB', 'B0DGQH5M9F', 'B0DGQHNZ15', 'B0DGQHQFW1', 'B0DGTDW26G', 'B0DGTGST5T', 'B0DGTHNHNJ', 'B0DGTJL52C', 'B0DGTKW9XQ', 'B0DGX4JT67', 'B0DGXN3BQF', 'B0DGXQNB4R', 'B0DGXTLPN1', 'B0DGY1XQ75', 'B0DH1MQZX7', 'B0DH2855ZV', 'B0DHBR7DQX', 'B0DHFS4B5L', 'B0DHG1PVCY', 'B0DHGJT85P', 'B0DHGMFRJG', 'B0DHH2D65J', 'B0DHJZ9VZK', 'B0DHVGN4BT', 'B0DHVMWGF7', 'B0DHVR3XQ5', 'B0DHVSVT7C', 'B0DHVV578W', 'B0DHWQ85X2', 'B0DHZBTTSL', 'B0DHZMZ971', 'B0DJ6ZNY6M', 'B0DJ77R7F5', 'B0DJ78JSR3', 'B0DJ79HQ5S', 'B0DJ8D2DGF', 'B0DJ8JM5HH', 'B0DJ8P5WQM', 'B0DJ8RCZ8X', 'B0DJ8YK4QC', 'B0DJ8YMWZP', 'B0DJ91Q31Z', 'B0DJNBJQS6', 'B0DJNDDRPD', 'B0DJP6VGMF', 'B0DJPBKH9F', 'B0DJPBM16Z', 'B0DJQG7VBK', 'B0DJQV817G', 'B0DJQVN7FY', 'B0DJQVQ42P', 'B0DJS82MFQ', 'B0DJS8DLGP', 'B0DJSBMLHF', 'B0DJSBS73Q', 'B0DJSC3K5Y', 'B0DJSC6KTW', 'B0DJSCMXFS', 'B0DJSCNW8W', 'B0DJSCST47', 'B0DJSD5Q49', 'B0DJSDF2R9', 'B0DJSKRXBT', 'B0DJSLFXPM', 'B0DJSN5JW8', 'B0DJSPJ7KZ', 'B0DJSZBHMK', 'B0DJSZMJ3X', 'B0DJSZMKR5', 'B0DJT25YKX', 'B0DJV42Z2P', 'B0DJV8BP99', 'B0DJW1ZZP9', 'B0DJX8WKHQ', 'B0DJX91VBX', 'B0DJX9TRT8', 'B0DJXSNNZD', 'B0DJXV75ML', 'B0DJY5X9GR', 'B0DK1S4YTK', 'B0DK2TXHNB', 'B0DK2WYGTK', 'B0DK2X672F', 'B0DK2Y5YSP', 'B0DK2YJ9MV', 'B0DK2YK9G2', 'B0DK2YL7H5', 'B0DK3LVQH3', 'B0DK3N2687', 'B0DK3ST7Y3', 'B0DK55SKQX', 'B0DK5G4829', 'B0DK5GV73F', 'B0DK5J6T99', 'B0DK5JK53Z', 'B0DK5JYJ62', 'B0DK5KS4C9', 'B0DK5LKP8S', 'B0DK5LKXMZ', 'B0DK5LMXXZ', 'B0DK5LPYJB', 'B0DK5LYNWC', 'B0DK5MTQQK', 'B0DK5MVN4B', 'B0DK5MW7HX', 'B0DK5MY88X', 'B0DK5N1JWQ', 'B0DK5N7WNK', 'B0DK5P78G8', 'B0DK5PNCM2', 'B0DK6N32P4', 'B0DK97B84H', 'B0DKDX9NNY', 'B0DKF8KZ4G', 'B0DKFNLJN6', 'B0DKFPP8VL', 'B0DKHDDXRK', 'B0DKHMFXKD', 'B0DKHN87KF', 'B0DKHN87KG', 'B0DKHNRY2C', 'B0DKHPW2M3', 'B0DKHQDVDM', 'B0DKHQFMCB', 'B0DKHRQMCM', 'B0DKHRV1RL', 'B0DKHVKVRK', 'B0DKHZN5NR', 'B0DKJ22WPG', 'B0DKJ4SX8Y', 'B0DKJ53CZN', 'B0DKJ57KNX', 'B0DKJ58SWX', 'B0DKJ5FBJP', 'B0DKJ696CL', 'B0DKJFD85T', 'B0DKJJH4Z8', 'B0DKJK5V8Q', 'B0DKJKNSQK', 'B0DKJLHYH1', 'B0DKJM4GQT', 'B0DKJMZDDT', 'B0DKJN8LF2', 'B0DKJNX7XC', 'B0DKJP3B3H', 'B0DKJPYS8R', 'B0DKJQVBRR', 'B0DKJR1399', 'B0DKJR35ZL', 'B0DKJSWWMS', 'B0DKJT2XFL', 'B0DKJT7G5V', 'B0DKJTX3K8', 'B0DKJW7PFV', 'B0DKM5N997', 'B0DKMC8X42', 'B0DKMYXVM7', 'B0DKN4CF34', 'B0DKN4K4L6', 'B0DKN5D436', 'B0DKN5D53Z', 'B0DKN7R1T6', 'B0DKN8C7ZG', 'B0DKNM6CM4', 'B0DKNS1XHJ', 'B0DKNYV8L6', 'B0DKP17SQT', 'B0DKP22VTS', 'B0DKP3D83H', 'B0DKS8WWPB', 'B0DKS9TVHN', 'B0DKSB4DXD', 'B0DKSMKJ9L', 'B0DKT5NXBN', 'B0DKT6N9HM', 'B0DKT7YFJ1', 'B0DKT9HM3B', 'B0DKTKHSCC', 'B0DKX2PYM9', 'B0DKXGLFL9', 'B0DKXJDM24', 'B0DKXJRXNM', 'B0DKXK6R65', 'B0DKXM8RW1', 'B0DKXQBJ4W', 'B0DKXR2JHH', 'B0DKXR77K5', 'B0DKXTWLQF', 'B0DKXVXGB4', 'B0DKY5S8XS', 'B0DL55SPCC', 'B0DL5CYDR7', 'B0DL5M9G6P', 'B0DL8RMQ5P', 'B0DL8TMSLH', 'B0DL8V4TYN', 'B0DL8Z3PBQ', 'B0DL92TH1F', 'B0DL943MDH', 'B0DL9569SS', 'B0DL9G5YVZ', 'B0DLB7955F', 'B0DLGJ4YHW', 'B0DLGJBBTP', 'B0DLGKYH82', 'B0DLH2XT1X', 'B0DLJYW38V', 'B0DLK15L1K', 'B0DLKMTH22', 'B0DLMMDW1R', 'B0DLMRX4QT', 'B0DLNV83XS', 'B0DLNWXKBJ', 'B0DLW72VV9', 'B0DLW8GKSG', 'B0DLWLSKL5', 'B0DLWM3B98', 'B0DLX22B8K', 'B0DM1LY6WH', 'B0DM5FDTC8', 'B0DM5FX7ND', 'B0DM5HFZSG', 'B0DM62GBH1', 'B0DM63J84T', 'B0DM63MQD8', 'B0DMDTQZQV', 'B0DMF46FCX', 'B0DMFBJKJB', 'B0DMFBWNSQ', 'B0DMFBZWVX', 'B0DMFCPKF1', 'B0DMFFF7S2', 'B0DMSSFYRT', 'B0DMT5DGLX', 'B0DMV6Q9SQ', 'B0DMVZKKPR', 'B0DMW38N21', 'B0DMW5MYZM', 'B0DMZHMNHY', 'B0DN13X58F', 'B0DNDWGYX9', 'B0DNFD9WCV', 'B0DNFDGVPC', 'B0DNFKP5QV', 'B0DNFNCCWR', 'B0DNJGXZ3Z', 'B0DNK3KZ7Y', 'B0DNPJKRZG', 'B0DNQ3GRFG', 'B0DNQ3Y73X', 'B0DNQ4YMBF', 'B0DNQ674TM', 'B0DNQ6K6MH', 'B0DNQ6VW2F', 'B0DNQ6XFGY', 'B0DNQGGWJP', 'B0DNQLLTS5', 'B0DNQVN9Z1', 'B0DNR17DMJ', 'B0DNS26R96', 'B0DNSKT1YM', 'B0DNSM6RK4', 'B0DNSMNP6W', 'B0DNSND7K2', 'B0DNSNX2YN', 'B0DNSPV425', 'B0DNSQ8XBM', 'B0DNSQPNR5', 'B0DNSRJVDM', 'B0DNSS3DM8', 'B0DNSTP992', 'B0DNSV9NPC', 'B0DNSVJWHL', 'B0DNSVWT1Q', 'B0DNSW2P8L', 'B0DNSX7LRG', 'B0DNSZSP8G', 'B0DNT28DP9', 'B0DNYFX5Q9', 'B0DNYL1QL5', 'B0DNZ1CXJK', 'B0DNZ85VS3', 'B0DNZ9S3ZM', 'B0DP1Z3CSB', 'B0DP2D76BD', 'B0DP2K351N', 'B0DP2KKTMY', 'B0DP2KLXLW', 'B0DP2KMW56', 'B0DP2KRWRS', 'B0DP2KTC6V', 'B0DP2KVHVY', 'B0DP2KW73J', 'B0DP2L13HP', 'B0DP2L1TPP', 'B0DP2L2R7F', 'B0DP2L7WC7', 'B0DP2L98MJ', 'B0DP2LDV57', 'B0DP2LG2V4', 'B0DP2LHBBX', 'B0DP2LKJW4', 'B0DP2LNBF8', 'B0DP2LPFTT', 'B0DP2LPTDT', 'B0DP2LT8Y5', 'B0DP41LYKB', 'B0DP47JBKM', 'B0DP48FPYH', 'B0DP4FLRSR', 'B0DP4KJ7GP', 'B0DP4VJHXG', 'B0DP4VKW6R', 'B0DP4WS57Q', 'B0DP4YZ47C', 'B0DP6PG3LS', 'B0DP6TY8W7', 'B0DP6W39JX', 'B0DP6W4P78', 'B0DP6W9CMT', 'B0DP6XLGQH', 'B0DP6Y24W4', 'B0DP724Q7Y', 'B0DP77362M', 'B0DP7JJ9KS', 'B0DP8F5JTF', 'B0DP8HKMQG', 'B0DP9DKGQT', 'B0DP9DSJM9', 'B0DP9FS78H', 'B0DP9QTL4F', 'B0DP9WJJ23', 'B0DP9YQJDT', 'B0DPFV949Q', 'B0DPFVY871', 'B0DPG72C4V', 'B0DPG9PXXK', 'B0DPH7GP5K', 'B0DPH81Z1M', 'B0DPH82PZD', 'B0DPH8JVF7', 'B0DPHPVHPX', 'B0DPJ2SXNZ', 'B0DPJTF5D6', 'B0DPK1CP4M', 'B0DPK2J61S', 'B0DPKMJKBS', 'B0DPKMXXVN', 'B0DPKN2MFG', 'B0DPKNS82J', 'B0DPKQHKC1', 'B0DPKQYRZT', 'B0DPKR7YZF', 'B0DPKTD878', 'B0DPKV462V', 'B0DPKYV8WF', 'B0DPKZ2Z13', 'B0DPL5RDKS', 'B0DPM6YHDH', 'B0DPMSFB8L', 'B0DPQ8B4VX', 'B0DPQD81PK', 'B0DPQKCZ7J', 'B0DPQVPZT2', 'B0DPW59KF7', 'B0DPWXDV15', 'B0DPX5SVBG', 'B0DPYB7SXY', 'B0DPYP5DM4', 'B0DPZZY4SN', 'B0DQ4N3TK2', 'B0DQ4ZGLYQ', 'B0DQ56GLVS', 'B0DQ7NRMW8', 'B0DQ7XZQY1', 'B0DQ82P6XP', 'B0DQ83Z5WR', 'B0DQ87BXGY', 'B0DQ8WNRLN', 'B0DQKR3D2Z', 'B0DQKVKDTK', 'B0DQLDD7QM', 'B0DQP369WB', 'B0DQP6QCJT', 'B0DQP8ZFDF', 'B0DQPVR8CF', 'B0DQQ2W1B6', 'B0DQS8FQ2Q', 'B0DQT9JQSD', 'B0DQTCCVRF', 'B0DQTR4QRF', 'B0DQV3JT6F', 'B0DQV3LLWM', 'B0DQX762YG', 'B0DQXZ1138', 'B0DQY3C9YZ', 'B0DQY48DCR', 'B0DQY59JPW', 'B0DQY7JH7R', 'B0DQZM9LFZ', 'B0DR12STG1', 'B0DR1CZC89', 'B0DR1DFS9X', 'B0DR1RV7LW', 'B0DR25BD2L', 'B0DR26HC3K', 'B0DR286C8W', 'B0DR2BNQ1J', 'B0DR2KLP84', 'B0DR2RCDQZ', 'B0DR8MQTPX', 'B0DRB9ZYMR', 'B0DRBCWJLR', 'B0DRBDFF9X', 'B0DRC5CL4F', 'B0DRCBTH9J', 'B0DRCSXTN6', 'B0DRD3DPTH', 'B0DRD3N5CK', 'B0DRD5VB94', 'B0DRFDDQ37', 'B0DRHRZHFK', 'B0DRHT2TXB', 'B0DRJHB6Q8', 'B0DRNSM8X5', 'B0DRNTF36Q', 'B0DRNWBGP2', 'B0DRNXNWQP', 'B0DRNZMWV7', 'B0DRNZQZ64', 'B0DRNZSNTL', 'B0DRP192MR', 'B0DRP1J8TR', 'B0DRP1N16X', 'B0DRP3T18Y', 'B0DRP8YG67', 'B0DRPDQX2R', 'B0DRV8P598', 'B0DRV9P2CN', 'B0DRVFND8K', 'B0DRWP47SJ', 'B0DRWVWN3N', 'B0DRX4F484', 'B0DRY9L8Q6', 'B0DRY9P954', 'B0DRYJBVDX', 'B0DRYKFZL1', 'B0DRYM9RFD', 'B0DRYMPQPZ', 'B0DRYNJSVM', 'B0DRYNTYMS', 'B0DRYNW5G3', 'B0DRYRG2ZX', 'B0DRYSVFMZ', 'B0DS1NMXLD', 'B0DS2BBKJM', 'B0DS3V21MC', 'B0DS3XGJQF', 'B0DS44HT5C', 'B0DS5DL8WB', 'B0DS5M3NH7', 'B0DS5NHK92', 'B0DS5NTQGP', 'B0DS5YWSWV', 'B0DS5ZCG16', 'B0DS612C4N', 'B0DS61T4RT', 'B0DS61W74R', 'B0DS62STS1', 'B0DS6389W2', 'B0DS63N9SK', 'B0DS6DWCS6', 'B0DSBWRQ83', 'B0DSBXLW7F', 'B0DSC1YPWN', 'B0DSFSHH6R', 'B0DSFZD9MX', 'B0DSJ3XWBK', 'B0DSJ4RF8X', 'B0DSJ5F33T', 'B0DSJ8XRRW', 'B0DSJJKGSH', 'B0DSK5XK29', 'B0DSKHDC33', 'B0DSL8SDCP', 'B0DSLH7J53', 'B0DSM7HJQV', 'B0DSM7WJT7', 'B0DSMPLCDH', 'B0DSMQG5BR', 'B0DSNLMMRX', 'B0DSP5KBDV', 'B0DSPKVB2Z', 'B0DSPLHT78', 'B0DSPN7GQD', 'B0DSPNTMS1', 'B0DSPQ7H8Q', 'B0DSPQZLYR', 'B0DSPR5D6T', 'B0DSPRTQ6D', 'B0DSPSHT41', 'B0DSPTTT48', 'B0DSPVBG7X', 'B0DSPWT8QJ', 'B0DSPX7RBT', 'B0DSPXSXWS', 'B0DSPY9DPM', 'B0DSVNVXHD', 'B0DSVP7MHM', 'B0DSVSLNWN', 'B0DSVSNP8Z', 'B0DSVWBRLX', 'B0DSVXMZS7', 'B0DSVYQVZ1', 'B0DSVYYGGN', 'B0DSZCWK9N', 'B0DSZHZQF6', 'B0DSZJQRNH', 'B0DSZLJPSG', 'B0DSZQ2TZ7', 'B0DSZQ6FCY', 'B0DT138T5Y', 'B0DT13FYHK', 'B0DT1576JM', 'B0DT18537M', 'B0DT18YCMK', 'B0DT1BB1PW', 'B0DT3MD8QY', 'B0DT3WD8Q7', 'B0DT3XR3N8', 'B0DT42QRJQ', 'B0DT5XGJNF', 'B0DT6B8RRC', 'B0DT6P97QZ', 'B0DT6PY9L1', 'B0DT6QTKQK', 'B0DT6SH6BF', 'B0DT6T2DB4', 'B0DT6TN3QC', 'B0DT6VFV13', 'B0DT6W4M46', 'B0DT6WPK4L', 'B0DT6Z476W', 'B0DT71DHBY', 'B0DT71G2LY', 'B0DT71R5GH', 'B0DT72T6LJ', 'B0DT72W8FG', 'B0DT7416TX', 'B0DT74B6W5', 'B0DT8Y97RC', 'B0DT93CPRS', 'B0DT944QSK', 'B0DT96FS36', 'B0DT99ZPDD', 'B0DT9BWYNQ', 'B0DT9C8FP2', 'B0DT9D1V8J', 'B0DT9FNFYW', 'B0DT9JTZ25', 'B0DT9Q33X4', 'B0DT9R9JXY', 'B0DT9RNRJM', 'B0DTB3FY36', 'B0DTHD8TM3', 'B0DTHDCQ66', 'B0DTJ23GHJ', 'B0DTJWXFS9', 'B0DTK4KYLL', 'B0DTK7CF4R', 'B0DTK7MR9V', 'B0DTKC6G2T', 'B0DTKDKYF8', 'B0DTKGSH7B', 'B0DTNT8GKS', 'B0DTP1FBYF', 'B0DTP5YQLH', 'B0DTPD4WZS', 'B0DTPGHRZN', 'B0DTSRLFVX', 'B0DTTTL7T4', 'B0DTY4CXC1', 'B0DTY7BZLR', 'B0DTYD29TG', 'B0DTYD3FB3', 'B0DTYF36H2', 'B0DTYSYZS6', 'B0DTYVKX1N', 'B0DTYW5HN9', 'B0DTYXJ4NR', 'B0DTYXMJWM', 'B0DTYYSF2C', 'B0DTYZ1JY4', 'B0DTYZHP5L', 'B0DV3F4J45', 'B0DV3K2V9W', 'B0DV3TYV1M', 'B0DV3V6PFV', 'B0DV49VY51', 'B0DV4BX5JF', 'B0DW445NC9', 'B0DW467T4L', 'B0DW46Y18J', 'B0DW8YVSBT', 'B0DWFJQRFS', 'B0DWFTDZMY', 'B0DWFWK5JK', 'B0DWFX2L55', 'B0DWJF1TGR', 'B0DWJG3H3J', 'B0DWJQZNV7', 'B0DWJX15MX', 'B0DWK39CXB', 'B0DWK3SP9S', 'B0DWK3YFPY', 'B0DWK5GW8T', 'B0DWK5GWC3', 'B0DWMLQFRK', 'B0DWMNJFV7', 'B0DWMPJ8SR', 'B0DWMPQ5D3', 'B0DWMQJB72', 'B0DWMQW46C', 'B0DWMSF251', 'B0DWMTRTCK', 'B0DWMV47W4', 'B0DWMV4L7N', 'B0DWN2RX3T', 'B0DWN3BN2K', 'B0DWSJG689', 'B0DWSN7TYD', 'B0DWSQDQR5', 'B0DWSWRG51', 'B0DWSWTJ3H', 'B0DWSX46FS', 'B0DWSXVQ94', 'B0DWWXG11K', 'B0DWXFQ2J5', 'B0DWXFZ34Z', 'B0DWXG436Q', 'B0DWXGBWWC', 'B0DWXGCDHX', 'B0DWXK8DMJ', 'B0DWXKCB3H', 'B0DWXKRD4X', 'B0DWXKTHX8', 'B0DWXKYDGH', 'B0DWXLBTQW', 'B0DWXLJ23K', 'B0DWXLV5S3', 'B0DWXMHBSV', 'B0DWXPL4VT', 'B0DWXQHBXR', 'B0DWXR44DC', 'B0DWXR4T7B', 'B0DWZZXPS2', 'B0DX141WP9', 'B0DX15N51Z', 'B0DX16LW65', 'B0DX1K6WKW', 'B0DX1LG8MD', 'B0DX1M1P99', 'B0DX1X26NB', 'B0DX1YRKQS', 'B0DX24QHVK', 'B0DX25FNK8', 'B0DX25K4T6', 'B0DX25KFS2', 'B0DX26Y11G', 'B0DX2786MH', 'B0DX5HCYFJ', 'B0DX5K6TRP', 'B0DX5PGKVV', 'B0DX5THW7X', 'B0DX6672MK', 'B0DX6F6TRL', 'B0DX6HVW5Z', 'B0DX6P7LR7', 'B0DX6PPF5W', 'B0DX6RLRP1', 'B0DX6T1VSW', 'B0DX6XN3JM', 'B0DX6Z1G3Q', 'B0DX719ZH8', 'B0DX71VPM7', 'B0DX76HNMH', 'B0DX76M2BJ', 'B0DX78M436', 'B0DX78X7R1', 'B0DX79Q1CD', 'B0DX7BJ3WW', 'B0DXDQ4G8Y', 'B0DXDQP29C', 'B0DXDRWXL7', 'B0DXDS9RHM', 'B0DXDSJGZS', 'B0DXDX5G8B', 'B0DXF2PSC2', 'B0DXF3KZVJ', 'B0DXF481GQ', 'B0DXF56G9L', 'B0DXF8FMYY', 'B0DXF8XBQ1', 'B0DXFF37WY', 'B0DXFFHRGL', 'B0DXFK3CQW', 'B0DXFPYM84', 'B0DXFQZW62', 'B0DXFR1XD8', 'B0DXFR336R', 'B0DXKJ5JND', 'B0DXKWX4XS', 'B0DXKYHPY4', 'B0DXKYKHWG', 'B0DXKYNG98', 'B0DXL17FDS', 'B0DXL2416R', 'B0DXL4H8FG', 'B0DXN4JFBF', 'B0DXN8DQ5T', 'B0DXNBQ7PL', 'B0DXNTNCZX', 'B0DXP2C4P5', 'B0DXPQP358', 'B0DXQ2VXHV', 'B0DXQ4CRJ1', 'B0DXQ4CWR9', 'B0DXQ8MLC2', 'B0DXTHWR5L', 'B0DXV6HWHV', 'B0DXV8D9F6', 'B0DXV91G1D', 'B0DXVF4GDV', 'B0DXVH3DT8', 'B0DXVHCP1G', 'B0DY11RFCN', 'B0DY1BDTWB', 'B0DY1BPZ18', 'B0DY1GD4WQ', 'B0DY1KM1FT', 'B0DY1KWMT8', 'B0DY1N15F2', 'B0DY1PSTQD', 'B0DY1SBFWX', 'B0DY75MNK1', 'B0DY7CXQ7M', 'B0DY7D6653', 'B0DY7F86F9', 'B0DY7G5NH8', 'B0DY7GLRKW', 'B0DY7J8W1D', 'B0DY7P1W5V', 'B0DY7S81BH', 'B0DY7V3ZRS', 'B0DY7VMMFV', 'B0DY7VQSL3', 'B0DY81YRTT', 'B0DYC79CS9', 'B0DYCJ3HFS', 'B0DYCPGTYY', 'B0DYCPJQ1B', 'B0DYD22PQZ', 'B0DYD4LS5B', 'B0DYD51M6P', 'B0DYD56NQ3', 'B0DYD58BGB', 'B0DYD8F4HB', 'B0DYDG1H9H', 'B0DYDHBH76', 'B0DYDJ1TPH', 'B0DYDLGC5M', 'B0DYDNJKK8', 'B0DYDP2V82', 'B0DYDPNNJN', 'B0DYDQK1LL', 'B0DYDTZW62', 'B0DYDVBSS8', 'B0DYDVCMRR', 'B0DYDVWK7Q', 'B0DYDZHCQ2', 'B0DYHBZ556', 'B0DYJ68YMM', 'B0DYJ71QP4', 'B0DYJD6NB7', 'B0DYJD6S5W', 'B0DYJF6Q6G', 'B0DYJQ5HRX', 'B0DYJT2SLW', 'B0DYJT72NW', 'B0DYJTGRFP', 'B0DYJTTRHX', 'B0DYJVMHZ2', 'B0DYJVQ2D4', 'B0DYJW4D7X', 'B0DYJWGLWP', 'B0DYJWMGV6', 'B0DYJWP5T6', 'B0DYJXB98X', 'B0DYJZTZNP', 'B0DYMPTKRX', 'B0DYNVD8JV', 'B0DYNZ741W', 'B0DYP16PSD', 'B0DYP2XTZX', 'B0DYP43NLW', 'B0DYP54HKQ', 'B0DYP5J829', 'B0DYP63B26', 'B0DYP791T9', 'B0DYP84PXH', 'B0DYT3BDN3', 'B0DYT7V894', 'B0DYT8PGVD', 'B0DYTJGJJR', 'B0DYTJS2K6', 'B0DYV247BT', 'B0DYV3JKJ2', 'B0DYV5X9NV', 'B0DYV7KD39', 'B0DYV8D4NZ', 'B0DYV8QCG1', 'B0DYVD8JWN', 'B0DYVFK2D1', 'B0DYVKHC53', 'B0DYYWZZSG', 'B0DYZXQV36', 'B0DZ1MTPM6', 'B0DZ215KZY', 'B0DZ21YV4Z', 'B0DZ226MRN', 'B0DZ238N3R', 'B0DZ238PHK', 'B0DZ2673BD', 'B0DZ2DTMKD', 'B0DZ2N9V85', 'B0DZ2P6KX5', 'B0DZ56FPFD', 'B0DZ5KPXFZ', 'B0DZ67PZRJ', 'B0DZ689D16', 'B0DZ6B57N9', 'B0DZ6C1FRF', 'B0DZ6CZ4WS', 'B0DZ6DV35F', 'B0DZ6GL8BM', 'B0DZ6K57R8', 'B0DZ6N3SND', 'B0DZ6NM3PH', 'B0DZ6PDR65', 'B0DZ6Q983S', 'B0DZ6QHV59', 'B0DZ6QRQPM', 'B0DZ6R42LC', 'B0DZ6S11VK', 'B0DZ6S79SX', 'B0DZ6SFBB7', 'B0DZ6SLNWR', 'B0DZ6THN9V', 'B0DZ6TW7XF', 'B0DZBP6VDV', 'B0DZC835Y9', 'B0DZC875DP', 'B0DZC9Q48G', 'B0DZC9Z37M', 'B0DZCB8QFK', 'B0DZCCDMTV', 'B0DZCGJB83', 'B0DZCGL5JC', 'B0DZCNBNNK', 'B0DZCNCC7C', 'B0DZCR25R9', 'B0DZCRW6PR', 'B0DZCRWGZW', 'B0DZCS9R6G', 'B0DZCSHGM9', 'B0DZCTMGDH', 'B0DZCV3D8Z', 'B0DZCV8MXL', 'B0DZCVXMYM', 'B0DZGFQDXZ', 'B0DZGS1TNZ', 'B0DZGWPP7D', 'B0DZH39DB2', 'B0DZH48ZZF', 'B0DZH6VKW2', 'B0DZHBPD8X', 'B0DZHDM5TT', 'B0DZHDY4K4', 'B0DZHHKJWJ', 'B0DZHJ16VP', 'B0DZHM6YS3', 'B0DZHMNGXW', 'B0DZHP67GB', 'B0DZLZ2HTJ', 'B0DZMCK1WS', 'B0DZMD9B5K', 'B0DZMFBGKX', 'B0DZMM6WP7', 'B0DZMNHGTN', 'B0DZMT4FFS', 'B0DZMWCW6N', 'B0DZMXJFZJ', 'B0DZMYW44L', 'B0DZMZZL2H', 'B0DZN21359', 'B0DZNB25LC', 'B0DZNBH6Z1', 'B0DZND71TX', 'B0DZNFBN2P', 'B0DZNHXT8T', 'B0DZNRHRX4', 'B0DZNRNRBF', 'B0DZNS143Z', 'B0DZNWJS8R', 'B0DZNXXXLP', 'B0DZNYZQ2J', 'B0DZNZFN3Y', 'B0DZNZVTN9', 'B0DZP59K33', 'B0DZWKLT6C', 'B0DZWKWQ7F', 'B0DZWMTWYR', 'B0DZWVBPZS', 'B0DZWXYS1G', 'B0DZWYZXV6', 'B0DZX44SSX', 'B0DZX4JXLM', 'B0DZX59RLY', 'B0DZX6CNVD', 'B0DZX6YQ9L', 'B0DZX7D55F', 'B0DZX7X938', 'B0DZXBNHSC', 'B0DZXCLCVD', 'B0DZXFBTTK', 'B0DZXH6T1N', 'B0DZXHF2QD', 'B0DZXSSRCD', 'B0F127NCMD', 'B0F12GM1L9', 'B0F12JQP43', 'B0F12QQ8ZN', 'B0F12R2VRZ', 'B0F12TPN5T', 'B0F134V2NV', 'B0F138NB35', 'B0F1395F9N', 'B0F139KVP7', 'B0F13CV9W9', 'B0F13J2VDP', 'B0F13LMVB4', 'B0F13MN61J', 'B0F13NPN6K', 'B0F13Q855M', 'B0F13QJCGD', 'B0F13QVTQT', 'B0F13R7JSD', 'B0F13S89JQ', 'B0F13SDB48', 'B0F13SFBBC', 'B0F13SGCL6', 'B0F13TM423', 'B0F13WK961', 'B0F13WRPZP', 'B0F1774KWL', 'B0F1774L59', 'B0F17DPBN9', 'B0F17JWWTT', 'B0F17MCQG4', 'B0F17PBXL1', 'B0F17Q28JH', 'B0F181RK5M', 'B0F183TT8L', 'B0F184DY2Z', 'B0F189K9PQ', 'B0F18GKKJB', 'B0F18K1V1Y', 'B0F18MKHC6', 'B0F18NMJ9H', 'B0F18NR2QV', 'B0F18PM191', 'B0F18PP1CT', 'B0F18PQFDZ', 'B0F18RYGZB', 'B0F18S29PH', 'B0F18T4Q84', 'B0F18TSP45', 'B0F18WHGPB', 'B0F18WWL8Q', 'B0F191NY4G', 'B0F192QFS7', 'B0F192QY93', 'B0F193PXGM', 'B0F1BSB5WL', 'B0F1BSXBP5', 'B0F1C1R8GB', 'B0F1C2587M', 'B0F1C4VXWL', 'B0F1C785BT', 'B0F1C97FW4', 'B0F1CCFLVS', 'B0F1CDNMK5', 'B0F1CJCKR5', 'B0F1CQ3TDG', 'B0F1CRWDV6', 'B0F1CRZQW4', 'B0F1CSNVV7', 'B0F1CT67HS', 'B0F1CTFLKP', 'B0F1CTK94J', 'B0F1CV4J39', 'B0F1CV76C8', 'B0F1CVDFYK', 'B0F1CVXFYM', 'B0F1CVYDTC', 'B0F1CWHHCT', 'B0F1CX5RGR', 'B0F1CXGH3Q', 'B0F1CXLJQD', 'B0F1CXTX5H', 'B0F1CYFLWD', 'B0F1CYFT2D', 'B0F1CYSTY3', 'B0F1CZGZ5C', 'B0F1D12K1J', 'B0F1D1KXKH', 'B0F1D1LVT2', 'B0F1D3GPHR', 'B0F1D3T5PF', 'B0F1D43YP4', 'B0F1D44LDY', 'B0F1D46YF6', 'B0F1D5WHFC', 'B0F1D6HXVZ', 'B0F1D6XN5H', 'B0F1D91W8Q', 'B0F1D9NKJC', 'B0F1DBB963', 'B0F1F65KT7', 'B0F1F8N765', 'B0F1F8YDX5', 'B0F1FB1CQF', 'B0F1FC4HBQ', 'B0F1FC6XZ2', 'B0F1FCJ6N6', 'B0F1FGJ2GK', 'B0F1FGPBQ8', 'B0F1FHNFKL', 'B0F1FJ4ZSC', 'B0F1FJKC1W', 'B0F1FMWJXB', 'B0F1FPJ1Q6', 'B0F1FSJW48', 'B0F1FT5G7X', 'B0F1FV2TR6', 'B0F1FVDWWR', 'B0F1FZ27SM', 'B0F1LR79KQ', 'B0F1LSDDTF', 'B0F1MBXM4X', 'B0F1MCNMTP', 'B0F1MCV83C', 'B0F1MLNB3L', 'B0F1MWZQC3', 'B0F1MY6P4F', 'B0F1MYB1MG', 'B0F1MYL1DW', 'B0F1MYT7HG', 'B0F1MZ7125', 'B0F1MZ999H', 'B0F1MZMN66', 'B0F1MZRFNL', 'B0F1N377H6', 'B0F1N5BCQR', 'B0F1NB19JX', 'B0F1RW6V5V', 'B0F1SRW479', 'B0F1SZBXB7', 'B0F1SZY8BK', 'B0F1T94QQ4', 'B0F1TD525Q', 'B0F1TFCVDR', 'B0F1TH6X72', 'B0F1TJLKHY', 'B0F1TP1C56', 'B0F1TPHXHS', 'B0F1TPLS9B', 'B0F1TPTBVD', 'B0F1TRSCJ8', 'B0F1TSHFNQ', 'B0F1TVDQ32', 'B0F1TVY4PZ', 'B0F1V8WK6N', 'B0F1X6HHB4', 'B0F1X6K87H', 'B0F1XBDHCN', 'B0F1XDQWZC', 'B0F1XDVHD7', 'B0F1XFQ57N', 'B0F1XHNP3B', 'B0F1XL4KH8', 'B0F1XW6JNJ', 'B0F1Y1GRLJ', 'B0F1Y558NQ', 'B0F1Y5L7T7', 'B0F1Y6KJDJ', 'B0F1Y85GLC', 'B0F1Y8MRJ2', 'B0F1Y8QK2Y', 'B0F1Y8Z74D', 'B0F1YC1RRR', 'B0F1YCH9KR', 'B0F1YCZBQ5', 'B0F1YD4SQP', 'B0F1YDPX85', 'B0F1YF8YZ7', 'B0F1YFBGY7', 'B0F1YFTMV5', 'B0F1YFW5FM', 'B0F1YH8P8J', 'B0F1YHL6Q6', 'B0F1YJD72P', 'B0F1YJY3S1', 'B0F1YK1R3Q', 'B0F1YM6S33', 'B0F1YNMGDY', 'B0F1YPFPR9', 'B0F1ZRQ4B1', 'B0F1ZSWG3Y', 'B0F1ZTTHHY', 'B0F1ZV6XQY', 'B0F1ZW4GQH', 'B0F1ZW4S6P', 'B0F211YGFX', 'B0F213M5BZ', 'B0F215XZF1', 'B0F216S8NY', 'B0F216T9DJ', 'B0F2188Q9M', 'B0F21F7TNS', 'B0F21FF1BR', 'B0F21G28KB', 'B0F21G8JL4', 'B0F21GCC5G', 'B0F21GKR23', 'B0F21GSFPX', 'B0F21GWQ7B', 'B0F21H1RD3', 'B0F21H1ZQ4', 'B0F21H6WTK', 'B0F21H8Q58', 'B0F21HNJSJ', 'B0F21HPFSY', 'B0F21JC53V', 'B0F21K62GJ', 'B0F21K8V9G', 'B0F21L6T5T', 'B0F21LNM92', 'B0F21MRRK9', 'B0F21N5B2B', 'B0F21N8CTP', 'B0F21NKGZL', 'B0F21Q7GTB', 'B0F21R3Q7P', 'B0F21WCDY2', 'B0F21XJ3WR', 'B0F21Z62C3', 'B0F2213JM6', 'B0F22272GW', 'B0F222DTKX', 'B0F226LYTR', 'B0F23B5M9S', 'B0F23G7TTJ', 'B0F23GBY9Q', 'B0F23GTZ3X', 'B0F23KFFXC', 'B0F23KRRGD', 'B0F23RS8G6', 'B0F23W7T48', 'B0F23X87NG', 'B0F23ZLLQ1', 'B0F244QCR5', 'B0F244TQFW', 'B0F246GH1S', 'B0F246R6BF', 'B0F246XBS2', 'B0F2476YLJ', 'B0F2477QNC', 'B0F247VK64', 'B0F2487267', 'B0F248N9B2', 'B0F2495BN9', 'B0F249FGRZ', 'B0F249WV3Z', 'B0F249YRCZ', 'B0F24BJW3S', 'B0F24BKXC3', 'B0F24BYDQ5', 'B0F24BZRCK', 'B0F24C4139', 'B0F24CCW14', 'B0F24F7K3R', 'B0F24FMQX7', 'B0F24GRBLM', 'B0F24H32ZZ', 'B0F24H9JH6', 'B0F24HPDPR', 'B0F24KGDLB', 'B0F24LLV51', 'B0F24LW28T', 'B0F24MB361', 'B0F24MDCY7']

        self.datas = []
        self.seeds = [{"asin": f"{asin}", "site": "us", "asin_type": "3,7", "is_variation": 1, "date_info": "", "account_id": None, "priority": "1", "updated_at": "2024-05-21 08:52:44", "other_sellers_id": "", "other_seller_name": "", "other_seller_buy_boy_type": ""} for asin in self.asins]
        self.variat_list = []

    @classmethod
    def from_crawler(cls, crawler, *args, **kwargs):
        spider = super(TextDetail, cls).from_crawler(crawler, *args, **kwargs)
        crawler.signals.connect(spider.close, signals.spider_closed)
        crawler.signals.connect(spider.spider_idle, signals.spider_idle)
        return spider

    def get_seeds(self):
        return [self.seeds.pop()]

    def spider_idle(self, spider):
        # read database again and send new requests
        logging.debug(f'IDLE------------------{self.site} {time.time()} {len(self.seeds)}')
        stats = self.crawler.stats
        stats.clear_stats()
        seeds = self.get_seeds()
        if seeds:
            for i in seeds:
                # # text
                job = i
                # job = json.loads(i)
                if not self.site_url.get(job['site']):
                    logging.info(f"过滤 未知站点 {job['site']}")
                    continue
                if job["is_variation"] == 2:
                    url = f"{self.site_url.get(job['site'])}/dp/{job['asin']}"
                else:
                    url = f"{self.site_url.get(job['site'])}/dp/{job['asin']}" + "?th=1&psc=1"
                headers = {
                    'Connection': 'close',
                    'authority': urlparse(url).hostname,
                    'accept': 'text/html,*/*',
                    'accept-language':  'zh-CN,zh;q=0.9',
                    'cache-control': 'no-cache',
                    'content-type': 'application/x-www-form-urlencoded;charset=UTF-8',
                    'origin': url,
                    'referer': f'{url}/Bosch-ROS20VSK-Palm-Sander-Collector/product-reviews/B0018Z8D64/ref=cm_cr_arp_d_paging_btm_next_3?ie=UTF8&reviewerType=all_reviews&pageNumber=3',
                }
                try:
                    account_id = str(job["account_id"]) if job["account_id"] and job["account_id"] != "nan" else None
                except:
                    account_id = ""
                if account_id:
                    url = f"{self.site_url.get(job['site'])}/dp/{job['asin']}?m={account_id}"
                meta = {
                    # "use_aiohttp": True,
                    "asin": job["asin"],
                    # "amazon_proxy": True,
                    "choice_header": True,
                    "cookiejar": int(time.time()),
                    "asin_type": job["asin_type"],
                    "date_info": job["date_info"],
                    "site": job["site"] or self.site,
                    "account_id": account_id,
                    "is_variation": job["is_variation"],
                    "priority": job["priority"],
                    "updated_at": job.get("updated_at", ""),
                    "other_sellers_id": job.get("other_sellers_id", ""),
                    "other_seller_name": job.get("other_seller_name", ""),
                    "other_seller_buy_boy_type": job.get("other_seller_buy_boy_type", ""),
                    # 'proxy': "http://106.122.192.154:3389",
                }
                meta = self.random_r(meta)
                h_key = random.choice(list(self.h_dict))
                headers[h_key] = self.h_dict.get(h_key)
                logging.info(f'随机添加headers： {meta["site"]} {h_key}')
                cookies = self.json_cookies(meta["site"])
                if meta['site'] in ['au', 'tr', 'nl']:
                    del headers['referer']
                self.crawler.engine.crawl(scrapy.Request(url=url, cookies=cookies, headers=headers,
                                     callback=self.parse, errback=self.err_parse,
                                     dont_filter=True, meta=meta), self)
        else:
            raise
            # meta = {
            #     'handle_httpstatus_all': True
            # }
            # request = scrapy.Request(url="https://www.baidu.com/", callback=self.parse_news_page, errback=self.err_, dont_filter=True, meta=meta)
            # self.crawler.engine.crawl(request, spider=self)
            # logging.info('no task sleep 30s')
            # time.sleep(30)
            # raise DontCloseSpider()

    def seller_history_msg_add(self, response, self_asin_seller):
        # 判断更新时间是否在  24小时内  在24小时内则  将历史 更买和最新更买  去重合并
        if response.meta["other_seller_name"]:
            history_other_sellers_id = response.meta["other_sellers_id"].split("|-|")
            history_other_sellers_name = response.meta["other_seller_name"].split("|-|")
            history_other_seller_buy_boy_type = response.meta["other_seller_buy_boy_type"].split("|-|")
            name = self_asin_seller["other_seller_name"].split("|-|") if self_asin_seller["other_seller_name"] else ""
            id = self_asin_seller["other_sellers_id"].split("|-|") if self_asin_seller["other_sellers_id"] else ""
            seller_buy_boy_type = self_asin_seller["other_seller_buy_boy_type"].split("|-|") if self_asin_seller["other_seller_buy_boy_type"] else ""

            for i in range(0, len(name)):
                if name[i] in history_other_sellers_name:
                    continue
                else:
                    history_other_sellers_name.append(name[i].strip())
                    history_other_sellers_id.append(id[i].strip())
                    history_other_seller_buy_boy_type.append(seller_buy_boy_type[i].strip())
            if len(history_other_sellers_id) == len(history_other_sellers_name) == len(history_other_seller_buy_boy_type):
                self_asin_seller["other_sellers_id"] = "|-|".join(history_other_sellers_id)
                self_asin_seller["other_seller_name"] = "|-|".join(history_other_sellers_name)
                self_asin_seller["other_seller_buy_boy_type"] = "|-|".join(history_other_seller_buy_boy_type)
                return self_asin_seller
            else:
                logging.info(f'history_other_sellers {response.meta["other_sellers_id"]} {response.meta["other_seller_name"]} {response.meta["other_seller_buy_boy_type"]}')
                logging.info(f"self_asin_seller: {self_asin_seller}")
                self_asin_seller["other_sellers_id"] = ""
                self_asin_seller["other_seller_name"] = ""
                self_asin_seller["other_seller_buy_boy_type"] = ""
                return self_asin_seller
        else:
            return self_asin_seller

    def seller_old(self, self_asin_seller):
        name = self_asin_seller.get("other_seller_name").split("|-|") if self_asin_seller.get(
            "other_seller_name") else []
        s_id = self_asin_seller.get("other_sellers_id").split("|-|") if self_asin_seller.get("other_sellers_id") else []
        s_type = self_asin_seller.get("other_seller_buy_boy_type").split("|-|") if self_asin_seller.get(
            "other_seller_buy_boy_type") else []
        seller_old = [{"asin": self_asin_seller.get("asin"), "seller_id": s_id[i].strip(), "seller_name": name[i].strip(),
                       "buy_boy_type": s_type[i].strip(), "site": self_asin_seller.get("site")} for i in range(len(name))]
        logging.info(f"seller old --> {seller_old}")
        return seller_old

    def parse(self, response, **kwargs):
        meta = response.meta
        print("-" * 20)
        with open(f"{response.meta.get('asin')}.html", "w", encoding="utf-8")as f:
            f.write(response.text)
        if item := self.page_state(response):
            yield item
        else:
            start_time = time.time()
            amazon_detail_extractor = AmazonDetailExtractor(meta.get("site"))
            items = amazon_detail_extractor.run(response)
            inner_item = detail_inner_item(items)
            inner_item = {k: v or None for k, v in inner_item.items()}
            pprint(items)

            # if inner_item['sp_delivery_initial_seen_asins_json']:
            #     with open(f"{response.meta.get('asin')}.html", "w", encoding="utf-8")as f:
            #         f.write(response.text)
            #         print("sp_delivery_initial_seen_asins_json ---------------------")
            inner_item["is_coupon"] = inner_item["is_coupon"] if inner_item["is_coupon"] else "0"

            dddd_test = {
                'asin': response.meta.get('asin'),
                'site': response.meta.get('site'),
                'title': inner_item['title'],
                'launch_time': inner_item['launch_time'],
                'buy_sales': inner_item['buy_sales'],
                'price': inner_item['price'],
                'rank': inner_item['rank'],
            }
            self.datas.append(dddd_test)
            # logging.info(f"解析耗时{time.time() - start_time}")
            # print(list(inner_item.keys()))
            # 添加字段长度限制
            inner_item = field_length_dispose(inner_item)
            self_asin_seller = self_asin_seller_item(items)
            print(self_asin_seller)
            # if (not self_asin_seller.get("seller_id")) and (not self_asin_seller.get("seller_name")):
            #     with open(f"{response.meta.get('asin')}.html", "w", encoding="utf-8")as f:
            #         f.write(response.text)
            #         logging.info(f"write html {response.meta.get('asin')}")
            # 变体数据
            variat_list = []
            parent_asin = None
            for i in amazon_detail_extractor.variat_msgs(response):
                logging.info(f'变体数据为：{list(variat_item(i).values())}')
                variat_list.append(list(variat_item(i).values()))
            if variat_list:
                parent_asin = variat_list[0][2]
            # inner_item["parent_asin"] = parent_asin
            print(json.dumps(variat_list))
            if "7" in inner_item.get("asin_type", ""):
                # 更买数据 获取逻辑处理
                self_asin_seller = {k: v or None for k, v in self_asin_seller.items()}
                logging.info(f"""每3小时数据""")
                if buy := response.xpath("//a[@id='aod-ingress-link']/span[@class='a-color-base']/text()").get():
                    if buy_num := re.findall(".*?(\d+).*?", buy):
                        if int(buy_num[0]) >= 2:
                            page_count = self.get_page_num(int(buy_num[0]), 10)
                            buy_q = queue.Queue()
                            for i in range(1, page_count+1):
                                url = f"{self.site_url.get(meta['site']) or self.url_}/gp/product/ajax/ref=dp_aod_NEW_mbc?asin={meta['asin']}&pc=dp&experienceId=aodAjaxMain&isonlyrenderofferlist=true&pageno={i}"
                                headers = {
                                    'Connection': 'close',
                                    'authority': urlparse(url).hostname,
                                    'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
                                    'accept-language': '*',
                                    'content-type': 'application/x-www-form-urlencoded;charset=UTF-8',
                                    'origin': url,
                                    'Cache-Control': 'no-cache',
                                    'referer': f'{url}/{meta["asin"]}/ref=cm_cr_arp_d_paging_btm_next_3?ie=UTF8&reviewerType=all_reviews&pageNumber=3',
                                }

                                meta = {
                                    # "use_aiohttp": True,
                                    # "curlcffi": True,
                                    "asin": meta["asin"],
                                    # "amazon_proxy": True,
                                    "cookiejar": int(time.time()),
                                    "asin_type": meta["asin_type"],
                                    "date_info": meta["date_info"],
                                    "site": meta["site"],
                                    "account_id": meta["account_id"],
                                    "is_variation": meta["is_variation"],
                                    "priority": meta["priority"],
                                    "updated_at": meta["updated_at"],
                                    "other_sellers_id": meta["other_sellers_id"],
                                    "other_seller_name": meta["other_seller_name"],
                                    "other_seller_buy_boy_type": meta["other_seller_buy_boy_type"],
                                    "buy_num": int(buy_num[0]),
                                    "buy_q": buy_q,
                                    "buy_page": page_count,
                                    "page": i,
                                    "sellers_data": {'inner_item': [inner_item], 'self_asin_seller': [self_asin_seller]},
                                }
                                meta = self.random_r(meta)
                                # cookies = {"i18n-prefs": "EUR", "session-id": "258-1590528-7416067", "session-id-time": "2082787201l", "sp-cdn": "\"L5Z9:HK\"", "ubid-acbnl": "260-0449045-0070351"}
                                cookies = self.json_cookies(meta['site'])
                                yield scrapy.Request(url=url, cookies=cookies, headers=headers,
                                                   callback=self.parse_buy, errback=self.err_parse,
                                                   dont_filter=True, meta=meta)
                        else:
                            if response.meta.get("other_seller_name"):
                                self_asin_seller = self.seller_history_msg_add(response, self_asin_seller)
                            pprint(inner_item)
                            pprint(self_asin_seller)
                            seller_old_data = self.seller_old(self_asin_seller)
                            yield {'inner_item': [inner_item], 'self_asin_seller': [self_asin_seller], "seller_old": seller_old_data}
                    else:
                        if response.meta.get("other_seller_name"):
                            self_asin_seller = self.seller_history_msg_add(response, self_asin_seller)
                        pprint(inner_item)
                        pprint(self_asin_seller)
                        seller_old_data = self.seller_old(self_asin_seller)
                        yield {'inner_item': [inner_item], 'self_asin_seller': [self_asin_seller], "seller_old": seller_old_data}
                else:
                    if response.meta.get("other_seller_name"):
                        self_asin_seller = self.seller_history_msg_add(response, self_asin_seller)
                    pprint(inner_item)
                    pprint(self_asin_seller)
                    seller_old_data = self.seller_old(self_asin_seller)
                    yield {'inner_item': [inner_item], 'self_asin_seller': [self_asin_seller], "seller_old": seller_old_data}
            if ("9" in inner_item.get("asin_type", "")) or ("8" in inner_item.get("asin_type", "")):
                logging.info("用户收藏数据")
                inner_item["parent_asin"] = parent_asin
                bsr_datas = amazon_detail_extractor.asin_bs_category_asin_detail(response)
                if bsr_datas:
                    best_sellers_rank = re.sub(r"(\(.*?\))", "", bsr_datas.get("best_sellers_rank") or "")
                    best_sellers_rank = '&&&&#'.join(best_sellers_rank.split(" #"))
                    all_best_sellers_href = "&&&&".join(bsr_datas.get("last_herf") or "")
                    # last_herf = all_best_sellers_href[-1]
                    inner_item["best_sellers_rank"] = best_sellers_rank or None
                    inner_item["all_best_sellers_href"] = all_best_sellers_href or None
                    inner_item["data_type"] = inner_item.get("asin_type", "")
                    yield {
                        'inner_item': [inner_item],
                        "self_asin_seller": None,
                        "seller_old": None,
                    }
                else:
                    inner_item["best_sellers_rank"] = None
                    inner_item["all_best_sellers_href"] = None
                    inner_item["data_type"] = inner_item.get("asin_type", "")
                    yield {
                        'inner_item': [inner_item],
                        "self_asin_seller": None,
                        "seller_old": None
                    }

            if response.meta.get("site") in ["us", "es", "fr", "it", "uk", "de"]:
                # <span class="a-size-base a-color-secondary">
                if "Item Package" in response.xpath(".//span[@class='a-size-base a-color-secondary']//text()").get(''):
                    print(response.xpath(".//span[@class='a-size-base a-color-secondary']//text()").get())
                    self.variat_list.append(response.meta.get("asin"))
                if variat_list:
                    print(json.dumps(variat_list))
                    yield {"variat_item": variat_list, "site": response.meta["site"]}
            else:
                logging.info("非6大站点变体信息 ")

            print("类似新品推荐", response.xpath(".//div[@class='a-fixed-left-grid-inner']//a[@class='a-size-base a-link-normal']/@href").get())
            # asin_image = amazon_detail_extractor.asin_image(response)
            # if asin_image:
            #     logging.info(f"img data --> {asin_image[0:5]}")
            #     # 入库
            #     yield {"asin_img": asin_image, "site": response.meta["site"]}


    def parse_buy(self, response, **kwargs):
        meta = response.meta
        logging.info(f"{meta['asin']} get `New ({meta['buy_num']}) from` > 2 to buy more page {meta['page']}")
        s_work = self.seller_work.get(meta["site"])
        s_ = self.seller_type.get(meta["site"])
        seller = response.xpath(f"//span[contains(text(), '{s_work}')]/parent::div/parent::div[@class='a-fixed-left-grid-inner']")
        seller_type = response.xpath(f"//span[contains(text(), '{s_}')]/parent::div/parent::div[@class='a-fixed-left-grid-inner']//span[@class='a-size-small a-color-base']//text()").getall()
        other_sellers_id = []
        other_sellers_name = []
        other_seller_buy_boy_type = []
        for x, i in enumerate(seller):
            s_name = i.xpath(".//*[(@class='a-size-small a-color-base') or (@aria-label and @class='a-size-small a-link-normal' and @role)]//text()").get().strip()
            s_id = i.xpath(".//*[(@class='a-size-small a-color-base') or (@aria-label and @class='a-size-small a-link-normal' and @role)]/@href").get() or None
            s_type = seller_type[x] or None
            if s_name in other_sellers_name:
                continue
            if "seller" not in [s_id or ""][0]:
                continue
            other_sellers_name.append(s_name.strip())
            other_sellers_id.append(s_id.strip())
            other_seller_buy_boy_type.append(s_type.strip())
        meta["buy_q"].put({
            'other_seller_name': other_sellers_name,
            'other_sellers_id': other_sellers_id,
            'other_seller_buy_boy_type': other_seller_buy_boy_type
        })
        if meta["buy_q"].qsize() == meta["buy_page"]:
            other_sellers_name = []
            other_sellers_id = []
            other_sellers_type = []
            for i in range(meta["buy_q"].qsize()):
                sellers = meta["buy_q"].get()
                other_sellers_id += sellers["other_sellers_id"]
                other_sellers_name += sellers["other_seller_name"]
                other_sellers_type += sellers["other_seller_buy_boy_type"]
            logging.info(f"{meta['asin']} seller len {len(other_sellers_name)}   {len(other_sellers_id)} {len(other_sellers_type)}")
            other_sellers_name = AmazonDetailExtractor(self.site).extract_other_seller_name(other_sellers_name,
                                                                                            meta["site"])
            other_sellers_id = AmazonDetailExtractor(self.site).extract_other_sellers_id(other_sellers_id,
                                                                                         meta["site"])
            other_sellers_type = AmazonDetailExtractor(self.site).extract_other_seller_name(other_sellers_type,
                                                                                         meta["site"])
            meta["sellers_data"]["self_asin_seller"][0]["other_seller_name"] = other_sellers_name or None
            meta["sellers_data"]["self_asin_seller"][0]["other_sellers_id"] = other_sellers_id or None
            meta["sellers_data"]["self_asin_seller"][0]["other_seller_buy_boy_type"] = other_sellers_type or None
            if response.meta.get("other_seller_name"):
                self_asin_seller = self.seller_history_msg_add(response, meta["sellers_data"]["self_asin_seller"][0])
                meta["sellers_data"]["self_asin_seller"][0] = self_asin_seller
            logging.info(f"sellers data -->{meta['sellers_data']['self_asin_seller']}")
            pprint(meta['sellers_data'])

            seller_old_data = self.seller_old(meta['sellers_data']['self_asin_seller'][0])
            meta['sellers_data']["seller_old"] = seller_old_data
            # seller_old_data = self.seller_old(self_asin_seller)

            yield meta['sellers_data']

    def err_parse(self, failure, **kwargs):
        logging.info(f"error______ {failure.getErrorMessage()}, {failure.request.meta.get('asin')}")
        # item = {
        #     "error_asin": True,
        #     "asin": (1, response.request.meta.get("asin"), response.request.meta.get("site")),
        # }
        # logging.info(f"爬取失败asin:{item.get('asin')}")
        # yield item
        # 处理失败请求并将其重新发送到 Redis
        # 获取原始请求对象
        request = failure.request
        meta = {
            "asin": request.meta.get("asin"),
            "asin_type": request.meta.get("asin_type"),
            "is_variation": request.meta.get("is_variation"),
            "date_info": request.meta.get("date_info"),
            "site": request.meta.get("site"),
            "account_id": request.meta.get("account_id"),
            "priority": request.meta.get("priority"),
            "updated_at": request.meta.get("updated_at"),
            "other_sellers_id": request.meta.get("other_sellers_id"),
            "other_seller_name": request.meta.get("other_seller_name"),
            "other_seller_buy_boy_type": request.meta.get("other_seller_buy_boy_type"),
        }
        k = json.dumps(meta)
        # while True:
        #     try:
        #         # sadd(f"{self.site}_real_seed", k, use_md5=False)
        #         zadd(f"{self.site}_real_zset_seed", {k: meta.get("priority")})
        #         logging.info(f"push {self.site}_real_zset_seed succeed")
        #         break
        #     except redis.exceptions.ConnectionError as e:
        #         logging.info(f"push {self.site}_real_zset_seed ConnectionError，afresh push --> T_T {e}")
        #         time.sleep(5)
        #         continue
        #     except FunctionTimedOut as e:
        #         logging.info(f"push {self.site}_real_zset_seed time out --> T_T {e}")
        #         continue

    def close(self, spider, reason):
        logging.info("spider finish")
        print(self.datas)
        # df = pd.DataFrame(self.datas)
        # df.to_excel(f'datas.xlsx')


if __name__ == '__main__':
    args = 'scrapy crawl text_detail -a site=us'.split()
    cmdline.execute(args)

# us, uk, fr, de, es, it, mx
# nohup cd /mnt/hezhe/amazon_spider/amazon_spider scrapy crawl real_new_detail  > real_redis_amazon1.log 2>&1 &
# nohup scrapy crawl real_new_detail -a site=us  > real_redis_amazon1.log 2>&1 &
# source activate pyspark
# for i in `ps -ef|grep "scrapy crawl real_new_detail" |awk '{print $2}' `; do kill -9 $i ; done;
# C:\Users\Administrator\AppData\Local\Programs\Python\Python38\scrapy crawl real_redis_detail
# 0 21 * * *  cd /mnt/hezhe/amazon_spider/amazon_spider && /opt/module/anaconda3/envs/pyspark/bin/scrapy crawl real_redis_detail -a site=uk > real_redis_amazon1.log 2>&1 &
