import time
import sys, os
import logging
from tools.seed_oa import send_mg
sys.path.append(os.path.dirname(sys.path[0]))
from db.mysql_db import get_country_engine, sql_insert, sql_insert_many, sql_connect, sql_delete, sql_update

logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                    level=logging.INFO)


class AsinStateUpdate:
    """
    每三个小时修改_self_real_spider状态
    """
    def __init__(self, site):
        self.site = site
        self.conn = None
        self.engine = get_country_engine(self.site)
        self.sites = {
            "us": "Amazon.com",
            "uk": "Amazon.co.uk",
            "de": "Amazon.de",
            "es": "Amazon.es",
            "it": "Amazon.it",
            "fr": "Amazon.fr",
            "mx": "Amazon.com.mx",
            "ca": "Amazon.ca",
        }

    def get_bsr_day_asin(self):
        sql_connect(self.site)
        # 修改每三个小时的爬取状态
        sql = f'update {self.site}_self_real_spider set state=1 WHERE data_type like "%%7%%";'
        # sql = f'update {self.site}_self_real_spider set state=3;'
        # sql = f'update {self.site}_self_real_spider set state=1 WHERE data_type like "%%7%%" and state in (3, 4, 12, 13);'
        # 测试
        # sql = f"SELECT distinct asin, date_info from bsr_day_asin WHERE created_at>='2023-05-15' and site_name='{self.site}';"
        sql_update(sql)


if __name__ == '__main__':
    for i in ["us"]:
        try:
            logging.info(f"开始运行----{i}")
            AsinStateUpdate(i).get_bsr_day_asin()
            time.sleep(3)
        except:
            account = 'hezhe'
            title = f'{i} 站点 每三个小时爬取 状态修改失败'
            content = f"{i} 站点 每三个小时爬取 状态修改失败 时间：{time.strftime('%Y-%m-%d %H:%M:%S', time.localtime())}"
            send_mg(account, title, content)


# 0 */3 * * * cd /mnt/hezhe/utils && /opt/module/anaconda3/envs/pyspark/bin/python Every_three_hours.py > real_three_hours.log 2>&1 &
