import pandas as pd
import sys, os
import logging
sys.path.append(os.path.dirname(sys.path[0]))
from db.pg_db import get_pg_country_engine, get_pg_con


logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                    level=logging.INFO)


class AsinInsert:
    def __init__(self, site):
        self.site = site
        self.engine = None
        self.conn = None

    def group_b(self, x):
        if x:
            # 通过取asin前三个 进行分类
            if x[0:3].lower() in ["b00", "b01", "b02", "b03", "b04", "b05", "b06"]:
                return "b00_b06"
            elif x[0:3].lower() == "b07":
                return "b07"
            elif x[0:3].lower() == "b08":
                return "b08"
            elif x[0:3].lower() == "b09":
                return "b09"
            elif x[0:3].lower() == "b0b":
                return "b0b"
            else:
                return "other"
        else:
            print(x)

    def if_asin(self, name, group):
        logging.info(f"source rows columns {group.shape}")
        b_date = self.get_b_date(name)
        result = group[~group['asin'].isin(b_date["asin"])]
        return result

    def get_b_date(self, b):
        sql1 = f"select asin from {self.site}_keepa_trend_{b};"
        df_keepa_trend = pd.read_sql(sql1, con=self.engine)
        return df_keepa_trend

    def insert_asin(self, date, name):
        self.conn = get_pg_con(self.site)
        date.to_sql(name=f"{self.site}_keepa_trend_{name}", con=self.conn, if_exists='append', index=False)

    def get_keepa_trend(self, site="us"):
        logging.info("开始运行------------")
        self.engine = get_pg_country_engine(self.site)
        sql1 = f"select * from {site}_keepa_trend;"
        df_keepa_trend = pd.read_sql(sql1, con=self.engine)

        df_keepa_trend = df_keepa_trend[~df_keepa_trend.asin.isnull()]
        del df_keepa_trend["bsr_orders_list"]
        del df_keepa_trend["bsr_orders_sale_list"]
        del df_keepa_trend["id"]
        df_keepa_trend["group_b"] = df_keepa_trend["asin"].apply(lambda x: self.group_b(x))
        b_ = df_keepa_trend.groupby("group_b")
        for name, group in b_:
            df = self.if_asin(name, group)
            del df["group_b"]
            logging.info(f"data is {df}")
            logging.info(f"df rows columns {df.shape}")
            self.insert_asin(df, name)


AsinInsert("us").get_keepa_trend()

# nohup /home/pengyanbing/anaconda3/bin/python3.8 keepa_group_asin.py > keepa_group.log 2>&1 &

# ps -ef|grep keepa_group_asin