import re


def time_ch(site, time_msg):
    time_dict = {
        # us
        "June": "06",
        "April": "04",
        "January": "01",
        "October": "10",
        "November": "11",
        "August": "08",
        "March": "03",
        "December": "12",
        "July": "07",
        "September": "09",
        "Feb": '02',
        "May": "05",
        # de
        "Januar": "01",
        "Februar": '02',
        "März": '03',
        # "April": "04",
        "Mai": '05',
        "Juni": '06',
        "Juli": '07',
        # "August": "08",
        "September ": "09",
        "Oktober": '10',
        # "November": "11",
        "Dezember": "12",
        # es
        "enero": '01',
        "febrero": '02',
        "marzo": '03',
        "abril": "04",
        "mayo": "05",
        "junio": '06',
        "julio": "07",
        "agosto": "08",
        "septiembre": '09',
        "octubre": '10',
        "noviembre": "11",
        "diciembre": "12",
        # fr
        "janvier": "01",
        "février": '02',
        "mars": "03",
        "avril": "04",
        "mai": "05",
        "juin": "06",
        "juillet": "07",
        "août": "08",
        "septembre": "09",
        "octobre": "10",
        "novembre": "11",
        "décembre": "12",
        # it
        "gennaio": "01",
        "febbraio": "02",
        # "marzo": '03',
        "aprile": "04",
        "maggio": '05',
        "giugno": "06",
        "luglio": "07",
        # "agosto": "08",
        "settembre": '09',
        "ottobre": '10',
        # "novembre": "11",
        "dicembre": "12",
        # uk
        # "January": "01",
        "February": '02',
        "Aug": '08',
        "Jun": "06",
        "Mar": "03",
        "Nov": "11",
        "Sept": "09",
        "Oct": "10",
        "Dec": "12",
        "Jan": "01",
        # "June": "06",
        # "Nov": "07",
        # "August": "08",
        # "September": "09",
        # "October": "10",
        # "November": "11",
        # "December": "12"
    }
    if t := re.match("([0-9]{2}).([0-9]{2}).([0-9]{4})", time_msg):
        return f"{t.group(3)}-{t.group(2)}-{t.group(1)}"
    if site == "de":
        if "/" in time_msg:
            return time_msg.strip().replace("/", "-")
        if not time_dict.get(time_msg.split(" ")[1].strip()):
            return ""
        day = time_msg.split(".")[0].replace("\xa0", "").strip()
        month = time_dict.get(time_msg.split(" ")[1].strip())
        year = time_msg.split(" ")[-1]
    elif site == "uk":
        if not time_dict.get(time_msg.split(" ")[1].strip().replace(".", "")):
            return ""
        day = time_msg.split(" ")[0].strip()
        month = time_dict[time_msg.split(" ")[1].strip().replace(".", "")]
        year = time_msg.split(" ")[2]
    elif site == "fr":
        if not time_dict.get(time_msg.split(" ")[1].strip()):
            return ""
        day = time_msg.split(" ")[0].strip()
        month = time_dict[time_msg.split(" ")[1].strip()]
        year = time_msg.split(" ")[2]
    elif site == "es":
        if len(time_msg.split(" ")) == 1:
            return ""
        if not time_dict.get(time_msg.split(" ")[1].strip()):
            return ""
        day = time_msg.split(" ")[0].strip()
        month = time_dict[time_msg.split(" ")[1].strip()]
        year = time_msg.split(" ")[-1]
    elif site == "it":
        if len(time_msg) == 4:
            return time_msg
        if not time_dict.get(time_msg.split(" ")[1].strip()):
            return ""
        day = time_msg.split(" ")[0].strip()
        month = time_dict[time_msg.split(" ")[1].strip()]
        year = time_msg.split(" ")[-1]
    elif site == "ca":
        if not time_dict.get(time_msg.replace(".", "").split(" ")[0].strip()):
            return ""
        day = time_msg.split(" ")[1].strip().split(" ")[0].strip()
        month = time_dict[time_msg.replace(".", "").split(" ")[0].strip()]
        year = time_msg.split(" ")[-1]
    elif site == "mx":
        if not time_dict.get(time_msg.replace(".", "").split(" ")[1].strip()):
            return ""
        day = time_msg.split(" ")[0].strip()
        month = time_dict[time_msg.replace(".", "").split(" ")[1].strip()]
        year = time_msg.split(" ")[-1]
    else:
        if not time_dict.get(time_msg.split(" ")[0]):
            return ""
        day = time_msg.split(",")[0].split(" ")[-1].replace("\xa0", "")
        month = time_dict[time_msg.split(" ")[0]]
        year = time_msg.split(",")[-1].strip()
    day = day if len(day) == 2 else "0" + day
    return "{}-{}-{}".format(year, month, day)


# print(time_ch("mx", "16 junio 2017"))