Java.perform(function () {
    // 定位 Credentials 类（确保类名正确）
    const Credentials = Java.use("com.amazon.vsearch.lens.api.config.Credentials");

    // 明确指定要 Hook 的构造函数：4个参数（String, String, String, boolean）
    Credentials.$init.overload(
        "java.lang.String",    // username
        "java.lang.String",    // secret
        "java.lang.String",    // application
        "boolean"              // removeCredentialsGate（实验开关）
    ).implementation = function (username, secret, application, removeCredentialsGate) {
        console.log("\n=== Credentials 4参数构造函数被调用 ===");
        console.log("1. username: " + username);
        console.log("2. secret: " + secret);
        console.log("3. application: " + application);
        console.log("4. removeCredentialsGate（实验开关）: " + removeCredentialsGate);
        console.log("\n调用栈:");
        console.log(Java.use("android.util.Log").getStackTraceString(Java.use("java.lang.Exception").$new()));

        // 调用原构造函数，不影响正常逻辑
        this.$init(username, secret, application, removeCredentialsGate);
    };
});