import os
import sys
from sqlalchemy import text
sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.db_connect import BaseUtils
from flask import Flask, request, jsonify
import pandas as pd
app = Flask(__name__)
def db_mysql_connect():
    mysql_db = BaseUtils().mysql_connect()
    return mysql_db


def select_workflow_progress(sql_select):
    print('查询语句：',sql_select)
    mysql_connect = db_mysql_connect()
    df = pd.read_sql(sql_select, con=mysql_connect)
    if df.values:
        return list(df['status_val'])[0]
    else:
        return None
def update_workflow_progress(sql_update):
    print('更新语句：',sql_update)
    mysql_connect = db_mysql_connect()
    stmt = text(sql_update)
    with mysql_connect.begin() as conn:
        conn.execute(stmt)

@app.route('/workflow_progress', methods=['POST'])
def get_args():
    print(request.form)  # 打印所有表单数据
    site_name = request.form.get('site_name')
    sql = request.form.get('sql')
    sql_type = request.form.get('sql_type')
    if sql_type == 'select':
        status_val = select_workflow_progress(sql)
        items = {"code": 200, "message": "select success", 'status_val': status_val}
    elif sql_type == 'update':
        update_workflow_progress(sql)
        items = {"code": 200, "message": "update success", 'status_val': 1}
    else:
        items = {"code": 400, "message": "Parameter error"}
    return jsonify(items)


if __name__ == '__main__':
    app.run('0.0.0.0', 10249)
