import sys
import os
from datetime import datetime, timedelta

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from multiprocessing import Pool
from amazon_spider.merchantwords_search_term_pg6 import search_temp_merchantwords
from threading_spider.db_connectivity import connect_db
import time
import pandas as pd
import random
import socket
from amazon_spider.VPS_IP import pppoe_ip


def select_sate_mysql(site, num=None):
    db_class = connect_db(site)
    engine_pg6 = db_class.pg_21_db()  # pg
    if num == 3:
        sql_read = f'SELECT id FROM {site}_merchantwords_search_term_month_syn_2024 where state in (1,2) LIMIT 1'
        print(sql_read)
        df = pd.read_sql(sql_read, con=engine_pg6)
        id_tuple = list(df.id)
        if id_tuple:
            id_tuple = [1]
        else:
            id_tuple = None

        if id_tuple is None:
            return False
        else:
            return True


def get_ip_address():
    # 返回内网ip
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.connect(('baidu.com', 0))
    ip = s.getsockname()[0]
    return ip


def long_time_task(site, proxy_name):
    spider_us = search_temp_merchantwords(site_name=site, read_size=270, proxy_name=proxy_name)
    spider_us.run_pol()


if __name__ == '__main__':
    pppoe_ip()
    proxy_name = None
    site_list = ['us']
    for site in site_list:
        while True:
            current_time = datetime.now()
            # 计算后五分钟的时间
            five_minutes_later = current_time + timedelta(minutes=1)
            print('后五分钟时间', five_minutes_later)
            p = Pool(3)
            for i in range(3):
                p.apply_async(long_time_task, args=(site, proxy_name))
            print('等待所有子进程运行完成')
            # 执行该方法后不能继续添加新的Process
            p.close()
            # 等待所有子进程执行完毕
            p.join()
            print('所有进程运行完毕！')
            print('所有进程运行完毕！开始切换ip')
            print('所有进程运行完毕！开始切换ip')
            print('所有进程运行完毕！开始切换ip')
            print('所有进程运行完毕！开始切换ip')
            current_time = datetime.now()
            if current_time > five_minutes_later:
                pppoe_ip()
            else:
                time.sleep(random.uniform(200, 300))
                pppoe_ip()
            if select_sate_mysql(site, num=3) == False:
                break