Java.perform(function () {
    // 定位目标类：com.amazon.vsearch.lens.network.internal.NetworkManagerImpl
    const NetworkManagerImpl = Java.use("com.amazon.vsearch.lens.network.internal.NetworkManagerImpl");

    // Hook createParamsMapForNetworkCall 方法
    NetworkManagerImpl.createParamsMapForNetworkCall.implementation = function (additionalBodyParams) {
        console.log("\n=== 检测到 createParamsMapForNetworkCall 被调用 ===");

        // 1. 打印调用者信息（调用栈）
        console.log("调用栈:");
        console.log(Java.use("android.util.Log").getStackTraceString(Java.use("java.lang.Exception").$new()));

        // 2. 打印传入的参数 additionalBodyParams（业务参数）
        console.log("\n传入的 additionalBodyParams 参数:");
        try {
            // 将 Map 转换为 JSON 字符串打印（便于阅读）
            const gson = Java.use("com.google.gson.Gson").$new();
            const paramsJson = gson.toJson(additionalBodyParams);
            console.log(paramsJson);
        } catch (e) {
            // 若没有 Gson，直接打印 Map 内容
            console.log(additionalBodyParams.toString());
        }

        // 3. 调用原方法，获取返回值
        const result = this.createParamsMapForNetworkCall(additionalBodyParams);

        // 4. 打印返回值（组装后的完整请求参数，含 query_metadata）
        console.log("\n返回的完整请求参数:");
        try {
            const gson = Java.use("com.google.gson.Gson").$new();
            const resultJson = gson.toJson(result);
            console.log(resultJson);
        } catch (e) {
            console.log(result.toString());
        }

        // 返回原方法的结果，不影响正常流程
        return result;
    };

    console.log("✅ 已成功 Hook createParamsMapForNetworkCall 方法");
});