import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.hdfs_utils import HdfsUtils


if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    hive_table = f"ods_merchantwords_brand_analytics"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info
    }

    # 落表路径校验
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)
    print(f"hdfs_path is {hdfs_path}")

    year, month, day = date_info.split("-")
    db_type = 'postgresql_16'
    import_table = f"{site_name}_merchantwords_brand_analytics_{year}_{month}_{day}"

    sql_query = f"""
        select 
         id,
         search_term,
         quantity_being_sold,
         created_time,
         updated_time,
         quantity_being_sold_str,
         result_count,
         departments
        from {import_table} 
        where 1=1
        and \$CONDITIONS
    """
    # 进行schema和数据校验
    CommonUtil.check_schema_before_import(db_type=db_type,
                                          site_name=site_name,
                                          query=sql_query,
                                          hive_tb_name=hive_table,
                                          msg_usr=['chenyuanjie'],
                                          partition_dict=partition_dict)
    # 生成导出脚本
    import_sh = CommonUtil.build_import_sh(site_name=site_name,
                                           db_type=db_type,
                                           query=sql_query,
                                           hdfs_path=hdfs_path,
                                           map_num=1,
                                           key='id'
                                           )
    HdfsUtils.delete_hdfs_file(hdfs_path)
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, import_sh, ignore_err=False)
    CommonUtil.after_import(hdfs_path=hdfs_path, hive_tb=hive_table)
    client.close()

    CommonUtil.check_import_sync_num(db_type=db_type,
                                     partition_dict=partition_dict,
                                     import_query=sql_query,
                                     hive_tb_name=hive_table,
                                     msg_usr=['chenyuanjie'])