import sys
import os
from datetime import datetime, timedelta

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
import time, random
import multiprocessing
from amazon_spider.asin_detail_pg import async_asin_pg
from amazon_spider.VPS_IP import pppoe_ip
from threading_spider.update_spdier_state import select_sate_mysql


def long_time_task(site, proxy_name, month, spider_int):
    print("当前 抓取 站点 ", site, proxy_name)
    print(f"开始=============== {site} asin 抓取 =======================", proxy_name)
    async_asin_us = async_asin_pg(site, proxy_name=proxy_name, month=month, spider_int=spider_int)
    async_asin_us.run()


if __name__ == '__main__':
    pppoe_ip()
    site_list = ['us','de','uk']
    month = int(sys.argv[1])
    spider_int = int(sys.argv[2])
    week = int(sys.argv[3])
    if int(month) < 10:
        month = '0' + str(month)
    if week < 10:
        week = '0' + str(week)
    proxy_name = None
    for site in site_list:
        if select_sate_mysql(site=site, week=week, spider_int=spider_int, month=month):
            while True:
                current_time = datetime.now()
                # 计算后五分钟的时间
                five_minutes_later = current_time + timedelta(minutes=2)
                print('后五分钟时间', five_minutes_later)
                processes = []
                for _ in range(4):
                    process = multiprocessing.Process(target=long_time_task, args=(site, proxy_name, month, spider_int))
                    processes.append(process)
                    process.start()
                # 等待所有子进程执行完毕
                for process in processes:
                    process.join()
                print('所有进程运行完毕！开始切换ip')
                current_time = datetime.now()
                if current_time > five_minutes_later:
                    pppoe_ip()
                else:
                    time.sleep(random.uniform(150, 220))
                    pppoe_ip()
                if select_sate_mysql(site=site, num=3, month=month, week=week, spider_int=spider_int) == False:
                    break
