Java.perform(function () {
    try {
        const TrackingInfo = Java.use("com.amazon.vsearch.lens.api.config.TrackingInfo");
        // 遍历所有构造方法（重点关注传入9个参数的构造方法）
        TrackingInfo.$init.overloads.forEach((ctor, index) => {
            ctor.implementation = function () {
                // 只关注9个参数的构造方法（已确认的核心构造）
                if (arguments.length === 9) {
                    console.log("\n=== 检测到 9 参数的 TrackingInfo 构造函数被调用 ===");
                    console.log("调用栈（谁在创建 TrackingInfo）:");
                    // 打印完整调用栈
                    console.log(Java.use("android.util.Log").getStackTraceString(Java.use("java.lang.Exception").$new()));
                }
                return this.$init.apply(this, arguments);
            };
        });
        console.log("✅ 已 Hook TrackingInfo 构造函数（跟踪调用者）");
    } catch (e) {
        console.log("❌ Hook 失败: " + e.message);
    }
});