import sys
import os
sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录

import requests
import pymysql
from utils.requests_param import Requests_param_val
from amazon_params.params import DB_CONN_DICT, PG_CONN_DICT
from queue import Queue
import time
import threading
import random

"""谷歌翻译"""

class Google_translates():

    def __init__(self,site_name):
        self.site_name = site_name
        self.init_db(site_name)

    def init_db(self,site_name):
        self.site_name = site_name
        if site_name == 'us':
            self.connect = pymysql.connect(host=DB_CONN_DICT['mysql_host'], port=DB_CONN_DICT['mysql_port'], user=DB_CONN_DICT['mysql_user'],
                             password=DB_CONN_DICT['mysql_pwd'], database="selection", charset="utf8mb4")
        else:
            self.connect = pymysql.connect(host=DB_CONN_DICT['mysql_host'], port=DB_CONN_DICT['mysql_port'], user=DB_CONN_DICT['mysql_user'],
                             password=DB_CONN_DICT['mysql_pwd'], database="selection_" + site_name,
                                           charset="utf8mb4")
        self.cursor = self.connect.cursor()

        self.reuests_para_val = Requests_param_val(site_name=self.site_name, spider="seller_account_product")
        self.name_id_queue = Queue()
        self.insert_list = []

    def translate(self,fromLang="auto", toLang="zh-CN"):
        # https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=zh-CN&dt=t&q=Carretillas
        while True:
            if self.name_id_queue.empty() == False:
                querys = self.name_id_queue.get()
                print(querys)
                print(f" id：", querys[0], " 分类:", querys[1])
                while True:
                    try:
                        headers = {}
                        ua = f'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/{random.randint(50, 104)}.0.{random.randint(1000, 5000)}.{random.randint(1, 181)} Safari/537.36'
                        headers['user-agent'] = ua
                        url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=' + fromLang + '&tl=' + toLang + '&dt=t&q=' + querys[1].replace(' ', '%20').replace('&', '%26')
                        print(url)
                        data = requests.get(url,timeout=15,headers=headers).json()
                        print(data)
                        if data[0][0][0]:
                            self.insert_list.append((querys[0],data[0][0][0].strip()))
                        break
                    except Exception as e:
                        if "'NoneType' object is not subscriptable" in str(e):
                            break
                        else:
                            print("google API翻译接口异常:",e,url)
                            time.sleep(random.uniform(2, 10))
                            continue
            else:
                break

    def db_read_data(self, i):
        while True:
            try:
                self.connect.ping(reconnect=True)
                print(f"当前请求 类目 {i}")
                sql_1 = f'select id,en_name from {self.site_name}_bs_category where nodes_num={i} and ch_name is NULL'
                print("获取请求 类目sql_1:", sql_1)
                time.sleep(3)
                self.cursor.execute(sql_1)
                name_1_list = self.cursor.fetchall()
                return name_1_list
            except Exception as e:
                print("db_read_data 报错：", e)
                time.sleep(10)
                self.init_db(self.site_name)
                continue

    def get_all_read_data(self):
        while True:
            try:
                self.connect.ping(reconnect=True)
                sql_1 = f'select id,en_name from {self.site_name}_bs_category where ch_name is NULL'
                print("获取请求 类目sql_1:", sql_1)
                time.sleep(3)
                self.cursor.execute(sql_1)
                name_1_list = self.cursor.fetchall()
                return name_1_list
            except Exception as e:
                print("db_read_data 报错：", e)
                time.sleep(10)
                self.init_db(self.site_name)
                continue


    def init_list(self):
        self.insert_list = []
        self.name_id_queue = Queue()

    def save_date(self):
        for name_id in self.insert_list:
            while True:
                try:
                    self.connect.ping(reconnect=True)
                    update_sql_ch_name = f'UPDATE {self.site_name}_bs_category set ch_name="{name_id[1]}" WHERE id={name_id[0]}'
                    print("更新：", update_sql_ch_name)
                    self.cursor.execute(update_sql_ch_name)
                    self.connect.commit()
                    break
                except Exception as e:
                    print(e)
                    time.sleep(10)
                    self.init_db(self.site_name)
                    continue
    def run(self):
        num = 1
        while True:
            print(num)
            time.sleep(3)
            name_1_list = self.db_read_data(num)
            if name_1_list and num < 15:
                for name_1 in name_1_list:
                    self.name_id_queue.put(name_1)
                html_thread = []
                for i in range(20):
                    thread2 = threading.Thread(target=self.translate)
                    html_thread.append(thread2)
                for ti in html_thread:
                    ti.start()
                    time.sleep(random.uniform(2, 5))
                for t2 in html_thread:
                    t2.join()
                print("self.insert_list: ",self.insert_list)
                print(f"当前 {num} 级分类 全部翻译完毕", len(self.insert_list))
                num += 1
            else:
                break
            self.save_date()
            self.init_list()

    def run_start(self):
        name_1_list = self.get_all_read_data()
        if name_1_list:
            for name_1 in name_1_list:
                self.name_id_queue.put(name_1)
            html_thread = []
            for i in range(20):
                thread2 = threading.Thread(target=self.translate)
                html_thread.append(thread2)
            for ti in html_thread:
                ti.start()
                time.sleep(random.uniform(2, 5))
            for t2 in html_thread:
                t2.join()
            print("self.insert_list: ", self.insert_list)
            print(f"当前 级分类 全部翻译完毕", len(self.insert_list))

        self.save_date()
        self.init_list()

if __name__ == '__main__':
    spider_us = Google_translates(site_name='us')
    spider_us.run_start() # 查询所有没有翻译的分类名称
    spider_uk = Google_translates(site_name='uk')
    spider_uk.run_start()
    spider_fr = Google_translates(site_name='fr')
    spider_fr.run_start()
    spider_es = Google_translates(site_name='es')
    spider_es.run_start()
    spider_it = Google_translates(site_name='it')
    spider_it.run_start()
    spider_de = Google_translates(site_name='de')
    spider_de.run_start()