from sqlalchemy import create_engine
import pandas as pd


def rank_search():
    with engine.begin() as conn:
        sql = f"truncate {site_name}_rank_search_rate;"
        conn.execute(sql)
    df_rank_rate['year'] = year
    df_rank_rate['month'] = month
    df_rank_rate.to_sql(f"{site_name}_rank_search_rate", con=engine, if_exists='append', index=False)


def rank_search_repeat():
    data_list = []
    rank_list = list(df_rank_rate['rank'])
    search_num_list = list(df_rank_rate['search_num'])
    rate_list = list(df_rank_rate['rate'])
    for rank, search_num, rate in zip(rank_list[:-2], search_num_list[:-2], rate_list[:-2]):
        print(rank, search_num, rate)
        index = rank_list.index(rank)
        if index + 1 < len(rank_list):
            rank_next = rank_list[index + 1]
            search_num_next = search_num_list[index + 1]
            rate_next = rate_list[index + 1]
            rank_diff = rank_next - rank
            search_num_diff = search_num - search_num_next
            rate_diff = rate - rate_next
            search_num_avg = search_num_diff / rank_diff
            rate_avg = rate_diff / rank_diff
            rank_range_list = list(range(rank, rank_next, 1))
            for rank_range in rank_range_list:
                index_range = rank_range_list.index(rank_range)
                s = search_num - search_num_avg * index_range
                r = rate - rate_avg * index_range
                data_list.append([rank_range, s, r])
        else:
            data_list.append([rank, search_num, rate])
        print("data_list:", len(data_list))

    rank_last, rank, search_num, rate = rank_list[-1], rank_list[-2], search_num_list[-2], rate_list[-2]
    for rank in range(rank_list[-2], rank_list[-1] + 1, 1):
        data_list.append([rank, search_num, rate])
        if rank == int(rank_last / 4):
            print("rank:", rank)
        elif rank == int(rank_last / 3):
            print("rank:", rank)
        elif rank == int(rank_last / 2):
            print("rank:", rank)
    print("data_list:", len(data_list))
    df_rank_rate_repeat = pd.DataFrame(data_list, columns=['rank', 'search_num', 'rate'])
    df_rank_rate_repeat['search_sum'] = df_rank_rate_repeat['search_num'] * df_rank_rate_repeat['rate']
    df_rank_rate_repeat['year'] = year
    df_rank_rate_repeat['month'] = month
    df_rank_rate_repeat.to_sql(f"{site_name}_rank_search_rate_repeat", con=engine, if_exists='append', index=False)


if __name__ == '__main__':
    site_name_list = ['us', 'uk', 'de', 'es', 'fr', 'it']
    # site_name_list = ['us']
    year = 2023
    month = 3

    for site_name in site_name_list:
        print("site_name:", site_name)
        if site_name == 'us':
            db = "selection"
        else:
            db = f"selection_{site_name}"

        DB_CONN_DICT = {
            "mysql_port": "3306",
            "mysql_db": db,
            "mysql_user": "adv_test",
            # "mysql_pwd": "S4FeR09bFF441lTz",
            "mysql_pwd": "Yswg%40XP_test",
            "mysql_host": "rm-wz9yg9bsb2zf01ea4yo.mysql.rds.aliyuncs.com",
        }
        # df_rank_rate = pd.read_clipboard()
        df_rank_rate = pd.read_excel(rf'E:/temp/销量分析算法/销量算法分析-{year}-{month}.xlsx', sheet_name=f'{site_name}')

        engine = create_engine(
            f'mysql+pymysql://{DB_CONN_DICT["mysql_user"]}:' + f'{DB_CONN_DICT["mysql_pwd"]}@{DB_CONN_DICT["mysql_host"]}:{DB_CONN_DICT["mysql_port"]}/{DB_CONN_DICT["mysql_db"]}?charset=utf8mb4')  # , pool_recycle=3600

        rank_search()
        rank_search_repeat()