# Define here the models for your scraped items
#
# See documentation in:
# https://docs.scrapy.org/en/latest/topics/items.html

import scrapy

from amazon_spider.utils.schema import Schema, Required, Optional, REMOVE_EXTRA

# class AmazonSpiderItem(scrapy.Item):
#     # define the fields for your item here like:
#     # name = scrapy.Field()
#     pass

detail_item = Schema({
	Optional('asin'): str,
	Optional('asin_state'): int,
	# news original url
	Optional('img_url'): str or None,
	Optional('title'): str or None,
	Optional('title_len'): int or None,
	Optional('price'): str or None,
	Optional('rating'): str or None,
	# news small cover.
	Optional('total_comments'): str or None,
	# news big cover.
	Optional('buy_box_seller_type'): int or None,
	Optional('page_inventory'): int or None,
	# country.
	Optional('category'): str or None,
	Optional('volume'): str or None,
	Optional('weight'): str or None,
	Optional('rank'): str or None,
	Optional('launch_time'): str or None,
	# Optional('category_state'): str,
	Optional('img_num'): int or None,
	Optional('img_type'): str or None,
	Optional('activity_type'): str or None,
	Optional('one_two_val'): str or None,
	Optional('three_four_val'): str or None,
	Optional('five_six_val'): str or None,
	Optional('eight_val'): str or None,
	Optional('qa_num'): str or None,
	Optional('one_star'): str or None,
	Optional('two_star'): str or None,
	Optional('three_star'): str or None,
	Optional('four_star'): str or None,
	Optional('five_star'): str or None,
	Optional('low_star'): int or None,
	Optional('together_asin'): str or None,
	Optional('brand'): str or None,
	Optional('ac_name'): str or None,
	Optional('sp_num'): str or None,
	Optional('data_type'): str or None,
	Optional('describe'): str or None,
	Optional('material'): str or None,
	Optional('node_id'): str or None,
	Optional('weight_str'): str or None,
	Optional('date_info'): str or None,
	Optional('package_quantity'): str or None,
	Optional('pattern_name'): str or None,
	Optional('follow_sellers'): str or None,
}, extra=REMOVE_EXTRA)


variat_item = Schema({
	Optional('asin'): str,
	Optional('color'): str,
	Optional('parent_asin'): str,
	Optional('size'): str,
	Optional('state'): str,
	Optional('style'): str,
	Optional('column_2'): str,
}, extra=REMOVE_EXTRA)


keepa_item = Schema({
	Optional('asin'): str,
	Optional('salesChannel'): str,
	Optional('reviews'): str,
	Optional('rating'): str,
	Optional('current_rank'): str,
	Optional('brand_name'): str,
	Optional('root_category'): str,
	Optional('second_category'): str,
	Optional('three_category'): str,
	Optional('four_category'): str,
	Optional('five_category'): str,
	Optional('six_category'): str,
	Optional('seven_category'): str,
	Optional('cat_id'): str,

	Optional('history_rank'): str,
	Optional('history_category'): str,
	Optional('current_rank_avg'): str,

}, extra=REMOVE_EXTRA)

detail_inner_item = Schema({
	Optional('asin'): str,
	# news original url
	Optional('img_url'): str or None,
	Optional('title'): str or None,
	Optional('title_len'): int or None,
	Optional('price'): str or None,
	Optional('rating'): str or None,
	Optional('total_comments'): str or None,
	Optional('buy_box_seller_type'): int or None,
	Optional('page_inventory'): int or None,
	Optional('category'): str or None,
	Optional('volume'): str or None,
	Optional('weight'): str or None,
	Optional('rank'): str or None,
	Optional('launch_time'): str or None,
	# Optional('category_state'): str,
	Optional('video_url'): str or None,
	Optional('add_url'): str or None,
	Optional('material'): str or None,

	Optional('img_num'): int or None,
	Optional('img_type'): str or None,
	Optional('qa_num'): str or None,
	Optional('brand'): str or None,
	Optional('ac_name'): str or None,
	Optional('node_id'): str or None,
	Optional('sp_num'): str or None,
	Optional('mpn'): str or None,
	Optional('online_time'): str or None,
	Optional('describe'): str or None,
	Optional('one_star'): str or None,
	Optional('two_star'): str or None,
	Optional('three_star'): str or None,
	Optional('four_star'): str or None,
	Optional('five_star'): str or None,
	Optional('low_star'): int or None,
	Optional('asin_type'): str or None,
	Optional('is_coupon'): str or None,
	Optional('search_category'): str or None,
	Optional('weight_str'): str or None,
	Optional('date_info'): str or None,
	Optional('site'): str or None,
	Optional('account_name'): str or None,
	Optional('other_seller_name'): str or None,
	Optional('bsr_date_info'): str or None,
	Optional('account_id'): str or None,

	Optional('package_quantity'): str or None,
	Optional('pattern_name'): str or None,
	Optional('together_asin'): str or None,
	Optional('activity_type'): str or None,
	Optional('one_two_val'): str or None,
	Optional('three_four_val'): str or None,
	Optional('five_six_val'): str or None,
	Optional('eight_val'): str or None,
	Optional('product_description'): str,
	Optional('follow_sellers'): str or None,
	Optional('buy_sales'): str or None,
	Optional('image_view'): str,
	Optional('product_json'): str,
	Optional('productdetail_json'): str,
	Optional('review_ai_text'): str,
	Optional('review_label_json'): str,
	Optional('lob_asin_json'): str,

	Optional('sp_initial_seen_asins_json'): str,
	Optional('sp_4stars_initial_seen_asins_json'): str,
	Optional('sp_delivery_initial_seen_asins_json'): str,
	Optional('compare_similar_asin_json'): str,
	Optional('customer_reviews_json'): str,
	Optional('together_asin_json'): str,
	Optional('min_match_asin_json'): str,
	Optional('seller_json'): str,
	Optional('returns'): str,
	Optional('result_list_json'): str,
}, extra=REMOVE_EXTRA)


detail_inner_return_item = Schema({
	Optional('asin'): str,
	# news original url
	Optional('img_url'): str or None,
	Optional('title'): str or None,
	Optional('title_len'): int or None,
	Optional('price'): str or None,
	Optional('rating'): str or None,
	Optional('total_comments'): str or None,
	Optional('buy_box_seller_type'): int or None,
	Optional('page_inventory'): int or None,
	Optional('category'): str or None,
	Optional('volume'): str or None,
	Optional('weight'): str or None,
	Optional('rank'): str or None,
	Optional('launch_time'): str or None,
	# Optional('category_state'): str,
	Optional('video_url'): str or None,
	Optional('add_url'): str or None,
	Optional('material'): str or None,

	Optional('img_num'): int or None,
	Optional('img_type'): str or None,
	Optional('qa_num'): str or None,
	Optional('brand'): str or None,
	Optional('ac_name'): str or None,
	Optional('node_id'): str or None,
	Optional('sp_num'): str or None,
	Optional('mpn'): str or None,
	Optional('online_time'): str or None,
	Optional('describe'): str or None,
	Optional('one_star'): str or None,
	Optional('two_star'): str or None,
	Optional('three_star'): str or None,
	Optional('four_star'): str or None,
	Optional('five_star'): str or None,
	Optional('low_star'): int or None,
	Optional('asin_type'): str or None,
	Optional('is_coupon'): str or None,
	Optional('search_category'): str or None,
	Optional('weight_str'): str or None,
	Optional('date_info'): str or None,
	Optional('site'): str or None,
	Optional('account_name'): str or None,
	Optional('other_seller_name'): str or None,
	Optional('bsr_date_info'): str or None,
	Optional('account_id'): str or None,

	Optional('package_quantity'): str or None,
	Optional('pattern_name'): str or None,
	Optional('together_asin'): str or None,
	Optional('activity_type'): str or None,
	Optional('one_two_val'): str or None,
	Optional('three_four_val'): str or None,
	Optional('five_six_val'): str or None,
	Optional('eight_val'): str or None,
	Optional('product_description'): str,
	Optional('follow_sellers'): str or None,
	Optional('buy_sales'): str or None,
	Optional('image_view'): str,
	Optional('product_json'): str,
	Optional('productdetail_json'): str,
	Optional('review_ai_text'): str,
	Optional('review_label_json'): str,
	Optional('lob_asin_json'): str,

	Optional('sp_initial_seen_asins_json'): str,
	Optional('sp_4stars_initial_seen_asins_json'): str,
	Optional('sp_delivery_initial_seen_asins_json'): str,
	Optional('compare_similar_asin_json'): str,
	Optional('customer_reviews_json'): str,
	Optional('together_asin_json'): str,
	Optional('min_match_asin_json'): str,
	Optional('seller_json'): str,
	Optional('returns'): str,
}, extra=REMOVE_EXTRA)

self_asin_seller_item = Schema({
	Optional('asin'): str,
	Optional('site'): str,
	Optional('seller_id'): str,
	Optional('seller_name'): str,
	Optional('buy_boy_type'): str,
	Optional('other_sellers_id'): str,
	Optional('other_seller_name'): str,
	Optional('other_seller_buy_boy_type'): str,
	Optional('updated_at'): str,

}, extra=REMOVE_EXTRA)


self_ama_temu_item = Schema({
	Optional('asin'): str,
	Optional('asin_compet'): str,
	Optional('img_url'): str,
	Optional('page'): int,
	Optional('page_row'): int,
	Optional('state'): int,
	Optional('site'): str,
}, extra=REMOVE_EXTRA)

self_temu_item = Schema({
	Optional('asin'): str,
	Optional('asin_compet'): str,
	Optional('img_url'): str,
	Optional('page'): int,
	Optional('page_row'): int,
	Optional('state'): int,
	Optional('site'): str,
}, extra=REMOVE_EXTRA)


amazon_comment_item = Schema({
	Optional('asin'): str,
	Optional('parent_asin'): str,
	Optional('title'): str,
	Optional('content'): str,
	Optional('is_vp'): str,

	Optional('model'): str,
	Optional('rating'): str,
	Optional('agree_num'): int,
	Optional('img_num'): int,
	Optional('img_url'): str,

	Optional('is_video'): str,
	Optional('video_url'): str,
	Optional('comment_url'): str,
	Optional('user_name'): str,
	Optional('user_img'): str,

	Optional('country'): str,
	Optional('user_page'): str,
	Optional('is_earns_commissions'): str,
	Optional('comment_time'): str,
	Optional('page'): int,

	Optional('md5_unique'): str,
	Optional('star'): str,
	Optional('vine_review_flag'): str,
}, extra=REMOVE_EXTRA)


detail_1688_item = Schema({
	Optional('memberId'): str,
	Optional('company_name'): str,
	Optional('factoryLevel'): str,
	Optional('factorySize'): str,
	Optional('repeatRate'): str,

	Optional('wwResponseRate'): str,
	Optional('companyYearStarted'): str,
	Optional('deepFactoryControlAcreage'): str,
	Optional('deepWorkerNum2'): str,
	Optional('deepProductNum'): str,

	Optional('highQualityTagList'): str,
	Optional('processingCapacity'): str,
	Optional('annualTradeVolume'): str,
	Optional('minOrderNumOem'): str,
	Optional('minOrderNum'): str,

	Optional('monthProductValue'): str,
	Optional('specialProcess'): str,
	Optional('materialPurchaseDay'): str,
	Optional('productQualityVerfity'): str,
	Optional('managerSystemVertify'): str,

	Optional('isVatInvoice'): str,
	Optional('invoicePoint'): str,
	Optional('reBuyRate'): str,
	Optional('medalName'): str,
	Optional('responseRate'): str,

	Optional('protectionRate'): str,
	Optional('easyBuyGmvSum'): str,
	Optional('intendedBuyerCount'): str,
	Optional('customGmvSum'): str,
	Optional('factoryDetailedAddress'): str,

	Optional('productionService'): str,
	Optional('authProvider'): str,
}, extra=REMOVE_EXTRA)