import sys
import os
import traceback

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
import pandas as pd
import json
from threading_spider.db_connectivity import connect_db


# 更新 keepa us_keepa_trend_b 表的 bsr_orders_list bsr_orders_sale_list 字段

def str_to_list(df_resp):
    df_asin_list = list(
        df_resp.asin.astype(str) + '|-|' + df_resp.last_price.astype(str) + '|-|' + df_resp.first_bsr_list.astype(
            str) + '|-|' + df_resp.first_bsr_label.astype(str))
    print('df_asin_list::', df_asin_list)
    return df_asin_list


def update_asin_orders():
    db_class = connect_db('us')
    engine_pg = db_class.pg_db()  # pg
    while True:
        try:
            for table_name in ['us_keepa_trend_b08', 'us_keepa_trend_b09', 'us_keepa_trend_other', 'us_keepa_trend_b07',
                               'us_keepa_trend_b00_b06']:
                sleect_sql = f'select asin, last_price, first_bsr_list, first_bsr_label  from {table_name} where bsr_orders_list is null ORDER BY id FETCH FIRST 1000 ROWS ONLY FOR UPDATE;'
                print('sleect_sql::', sleect_sql)
                df_resp = pd.read_sql(sleect_sql, con=engine_pg)
                df_asin_list = str_to_list(df_resp)
                list_asin = []
                for df_asin in df_asin_list:
                    asin_bsr_price_list = df_asin.split('|-|')
                    list_asin.append(asin_bsr_price_list)
                data_list = []
                for asins in list_asin:
                    print(asins)
                    asin = asins[0]
                    if asins[1] and asins[1] != 'nan':
                        price = asins[1]
                    else:
                        price = 0.0
                    bsr_list = json.loads(asins[2].replace('None', 'null'))
                    rank_lists = [] if bsr_list is None else [x if x is not None else None for x in bsr_list]
                    rank_data = eval(str(rank_lists))
                    category = asins[3]
                    rank_list = [x for x in rank_data if x is not None]
                    if rank_list:
                        if len(rank_list) == 1:
                            sql_read = f"""SELECT orders,orders*{price} as "销售额" from us_one_category_report_2023_05  where name  = '{category}'  and rank in ('{rank_list[0]}')"""
                        else:
                            sql_read = f"""SELECT orders,orders*{price} as "销售额" from us_one_category_report_2023_05  where name  = '{category}'  and rank in {tuple(rank_list)}"""
                        df = pd.read_sql(sql_read, con=engine_pg)
                        if not df['销售额'].empty and not df['orders'].empty:
                            # 定义要更新的数据
                            orders = str(list(df.orders))
                            orders_sale = str(list(df['销售额']))
                            data_list.append([orders, orders_sale, asin])
                        else:
                            data_list.append(['[-1]', '[-1]', asin])
                    else:
                        data_list.append(['[-1]', '[-1]', asin])
                # 构建更新SQL语句
                print('构建更新SQL语句::', table_name)
                sql_update = f"UPDATE {table_name} SET bsr_orders_list = %s, bsr_orders_sale_list = %s WHERE asin = %s"
                with engine_pg.begin() as conn:
                    # 执行批量更新操作
                    conn.execute(sql_update, data_list)
                    conn.execute(sql_update, data_list)
                print('执行完成。', table_name)
        except Exception as e:
            db_class = connect_db('us')
            engine_pg = db_class.pg_db()  # pg
            print("存储  数据错误数据错误", e, f"\n{traceback.format_exc()}")
            print(sleect_sql)


if __name__ == '__main__':
    update_asin_orders()
