import json

from utils.datahub_util import build_column_lineages

to_tb = "dim_cal_asin_history_detail"
sources = [
    {
        "form": "dim_asin_detail",
        "mappings": [
            ("asin", "asin"),
            ("asin_title", "asin_title"),
            ("asin_title_len", "asin_title_len"),
            ("asin_category_desc", "asin_category_desc"),
            ("asin_rank", "asin_rank"),
            ("asin_volume", "asin_volume"),
            ("asin_weight", "asin_weight"),
            ("asin_color", "asin_color"),
            ("asin_size", "asin_size"),
            ("asin_style", "asin_style"),
            ("asin_price", "asin_price"),
            ("asin_rating", "asin_rating"),
            ("asin_total_comments", "asin_total_comments"),
            ("asin_material", "asin_material"),
            ("asin_brand_name", "asin_brand_name"),
            ("asin_page_inventory", "asin_page_inventory"),
            ("bsr_cate_1_id", "bsr_cate_1_id"),
            ("bsr_cate_current_id", "bsr_cate_current_id"),
            ("asin_buy_box_seller_type", "asin_buy_box_seller_type"),
            ("asin_img_url", "asin_img_url"),
            ("updated_time", "asin_crawl_date"),
        ]
    },
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
