// 文章类型枚举
export enum ArticleTypeEnum {
  VIDEO = 'video', // 视频
  POST = 'post', // 帖子
  QUESTION = 'question', // 问题
  COLUMN = 'column', // 专栏
  PRACTICE = 'practice', // 实践
  INTERVIEW = 'interview', // 专访
}

// 发布状态枚举
export enum ReleaseStatusTypeEnum {
  DRAFT = 1, // 草稿
  PUBLISH = 2, // 发布
}

// 任务类型枚举
export enum TaskTypeEnum {
  // 常规任务
  REGULAR_TASK = 1,
  // 特殊任务
  SPECIAL_TASK = 2,
}

// 商品类型枚举
export enum ShopGoodsTypeEnum {
  // 实物
  REAL_GOODS = 1,
  // 虚拟
  VIRTUAL_GOODS = 2,
}

// 布尔值枚举
export enum BooleanFlag {
  NO = 0, // 否
  YES = 1, // 是
}

// 发送类型枚举
export enum SendTypeEnum {
  // 立即发送
  IMMEDIATE = 1,
  // 定时发送
  SCHEDULED = 2,
}

// 任务日期限制类型枚举
export enum TaskDateLimitTypeEnum {
  // 每日
  DAY = 'DAY',
  // 每周
  WEEK = 'WEEK',
  // 每月
  MONTH = 'MONTH',
}

// 标签类型枚举
export enum TagTypeEnum {
  // 文化关键词
  CULTURE_TAG = 0,
  // 年度关键词
  YEAR_TAG = 1,
  // 关联场景
  SCENE_TAG = 2,
}

// 标签级别
export enum TagLevelEnum {
  // 副标签
  SUB_TAG = 0,
  // 主标签
  MAIN_TAG = 1,
}

// 回复类型
export enum CommentTypeEnum {
  // 我评论别人的
  COMMNET_TO_OTHER = 1,
  // 别人评论我的
  COMMNET_TO_SELF = 2,
}

// 审核状态枚举
export enum AuditStatusEnum {
  // 未审核
  UNAUDITED = 0,
  // 通过审核
  AGREED = 1,
  // 驳回审核
  REJECTED = 2,
}

// 使用状态枚举
export enum UsageStatusEnum {
  // 待使用
  UNUSABLE = 0,
  // 已使用
  USED = 1,
}

// 视频位置枚举
export enum VideoPositionEnum {
  // 顶部
  TOP = 1,
  // 底部
  BOTTOM = 2,
}

// 活动分类
export enum ActivityTypeEnum {
  // 竞拍
  AUCTION = 1,
  // 活动
  // ACTIVITY = 2,
}

// 竞拍状态枚举
export enum AuctionStatusEnum {
  // 已发布
  PUBLISHED = 0,
  // 竞拍中
  AUCTIONING = 1,
  // 竞拍成功
  AUCTION_SUCCESS = 2,
  // 已流拍
  AUCTION_FAILED = 3,
}
