/**
 * 表情相关的 缓存
 */
import { defineStore } from 'pinia'

export interface IEmoji {
  url: string
  name: string
  group: string
  className: string
}
interface IEmojiObj {
  [name: string]: IEmoji
}
interface IGroupEmojy {
  [groupName: string]: IEmojiObj
}
export const useEmojiStore = defineStore({
  id: 'emoji',
  state: () => {
    return {
      emoji: {} as IGroupEmojy
    }
  },
  actions: {
    /**
     * 获取emojy标签
     */
    async getEmojiUrl(name: string, group: string) {
      if (this.emoji[group]) {
        return this.emoji[group][name]
      }
      const data = await this.generateEmojiGroup(group)
      if (!data) {
        return
      }
      this.emoji[group] = data

      return this.emoji[group][name]
    },

    async generateEmojiGroup(group: string): Promise<IEmojiObj | null> {
      let jsonData

      // 这里必须这样写，否则vite打包，会导致这个找不到文件
      if (group === 'face') {
        jsonData = (await import(`../../utils/emoji/face.json`)) as { default: IEmoji[] }
      }

      if (!jsonData) return null
      const obj: IEmojiObj = {}
      jsonData.default.forEach(v => {
        obj[v.name] = v
      })
      return obj
    }
  }
})
