import service from '@/utils/request/index'
import type { AddOrUpdateCaseDto } from './types'

// 案例库相关的接口

/**
 * 获取最新的案例编号
 */
export const getMaxCaseNumber = () => {
  return service.request<string>({
    url: '/api/cultureCase/getMaxCaseNumber',
    method: 'POST',
    data: {},
  })
}

/**
 * 新增案例库
 */
export const addOrUpdateCase = (data: AddOrUpdateCaseDto) => {
  return service.request({
    url: '/api/cultureCase/addOrUpdateCase',
    method: 'POST',
    data,
  })
}
