import service from '@/utils/request/index'
import type { UpdateUserInfoDto, SelfPublishDetailDto } from './types'
import type { BackendServicePageResult, PageSearchParams } from '@/utils/request/types'

/**
 * 更新用户信息
 */
export const updateUserInfo = (data: UpdateUserInfoDto) => {
  return service.request({
    url: '/api/personalCenter/updateUser',
    method: 'POST',
    data,
  })
}

/**
 * 是否有官方账号权限
 */
export const hasOfficialAccount = () => {
  return service.request<[]>({
    url: '/api/personalCenter/getIsOfficial',
    method: 'POST',
    data: {},
  })
}

/**
 * 获取我的发布列表
 */
export const getSelfPublishList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<SelfPublishDetailDto>>({
    url: '/api/personalCenter/selfPublish',
    method: 'POST',
    data,
  })
}

/**
 * 获取我的草稿列表
 */
export const getSelfDraftList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<SelfPublishDetailDto>>({
    url: '/api/personalCenter/selfDraft',
    method: 'POST',
    data,
  })
}

/**
 * 获取我的收藏列表
 */
export const getSelfCollectList = (data: PageSearchParams) => {
  return service.request<
    BackendServicePageResult<{
      id: number
      title: string
      content: string
      createTime: string
      updateTime: string
    }>
  >({
    url: '/api/personalCenter/selfCollect',
    method: 'POST',
    data,
  })
}

/**
 * 获取我的点赞列表
 */
export const getSelfPraiseList = (data: PageSearchParams) => {
  return service.request<
    BackendServicePageResult<{
      id: number
      title: string
      content: string
      createTime: string
      updateTime: string
    }>
  >({
    url: '/api/personalCenter/selfPraise',
    method: 'POST',
    data,
  })
}

/**
 * 获取我的案例库列表
 */
export const getSelfCaseList = (data: PageSearchParams) => {
  return service.request<
    BackendServicePageResult<{
      id: number
      title: string
      content: string
      createTime: string
      updateTime: string
    }>
  >({
    url: '/api/personalCenter/selfCase',
    method: 'POST',
    data,
  })
}

/**
 * 获取我的任务列表
 */
export const getSelfTaskList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<SelfPublishDetailDto>>({
    url: '/api/personalCenter/selfTaskConfig',
    method: 'POST',
    data,
  })
}

/**
 * 评论回复
 */
export const getSelfCommentList = (data: PageSearchParams) => {
  return service.request({
    url: '/api/personalCenter/selfComment',
    method: 'POST',
    data,
  })
}
