export function useResetData<T>(initialValue: T) {
  const state = ref(structuredClone(initialValue))
  const reset = () => {
    state.value = structuredClone(initialValue)
  }
  return [state, reset] as [Ref<T>, () => void]
}
