/**
 * 添加或更新案例库DTO
 */
import { ArticleTypeEnum, BooleanFlag, ReleaseStatusTypeEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

export interface OtherUserInfoDto {
  ayabiAvailable: number
  ayabiTotal: number
  createTime: string
  expTotal: number
  id: number
  isDelete: BooleanFlag
  level: number
  remark: string
  showAvatar: string
  showName: string
  signature: string
  updateTime: string
}

export interface OtherUserPostDataSearchParams extends PageSearchParams {
  createUserId: string
  isReal: BooleanFlag
}

export interface OtherUserPostDataDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: string
  cultureCommentListVo: null
  description: string
  faceUrl: string
  hasAddQuestion: BooleanFlag
  hasCollect: BooleanFlag
  hasPraised: BooleanFlag
  id: number
  isRecommend: BooleanFlag
  isRelateColleague: BooleanFlag
  playCount: number
  praiseCount: number
  releaseStatus: ReleaseStatusTypeEnum
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum
  videoDuration: string
  videoUrl: string
  viewCount: number
}
