import { createApp } from 'vue'
import { createPinia } from 'pinia'

import App from './App.vue'
import router from './router'

import './style/index.css'

import 'virtual:uno.css'
// 注册svg
import 'virtual:svg-icons-register'
import SvgIcon from '@/components/common/SvgIcon/svgIcon.vue'

if (import.meta.env.MODE === 'production') {
  import('@/utils/version').then(({ loopGetVersion }) => loopGetVersion())
}

const app = createApp(App)
app.use(createPinia())
app.use(router)

// 全局组件挂载
app.component('SvgIcon', SvgIcon)
app.mount('#app')
