/**
 * 针对树形的一些工具方法
 */

/**
 * 扁平数组转tree
 * @param {*} items 要转换的数组
 * @param {*} items 作为父id的字段名，默认 parentId
 * @param {*} items 作为id的字段名，默认id
 * @returns
 */
interface IObject {
  [key: string]: any
  children?: IObject[]
}
export function arrayToTree<T extends IObject>(items: T[], parentKey = 'parentId', primaryKey = 'id') {
  const result: T[] = []
  const itemMap = new Map<string | number, T>()
  // 遍历源数组，给map添加数据
  for (const item of items) {
    itemMap.set(item[primaryKey], item)
  }
  for (const item of items) {
    const pId = item[parentKey]
    // 根元素
    if (!itemMap.has(pId)) {
      result.push(item)
    }
    // 如果itemMap中存在 当前元素的parentId，则该元素不为根元素
    else {
      const parent = itemMap.get(pId)
      if (parent!.children && parent!.children instanceof Array) {
        parent!.children.push(item)
      } else {
        parent!.children = [item]
      }
    }
  }
  return result
}
